--
-- OperatingHours
-- Specialization for counting the operating hours of a vehicle
--
-- @author:  	Manuel Leithner
-- @date:		29/08/10
-- @version:	v2.0
-- @history:	v1.0 - initial implementation
--				v2.0 - convert to LS2011 (Networksupport) and some bugfixes

--@edit to attachableOperatingHours: Ifko[nator]
-- Zählt nun die Arbeitstunden eines Gerätes das den Befehl 'self.isTurnedOn' zum Arbeiten braucht. (Presse, Ladewagen, Schwader, Zetter ..) 
-- Man kann auch bei den Backgroundhud's zwischen dem alten und neuem Overlay hin und her wechseln.
--@date:		13/03/14

attachableOperatingHours = {};

function attachableOperatingHours.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function attachableOperatingHours:load(xmlFile)
	self.addOperatingTime = SpecializationUtil.callSpecializationsFunction("addOperatingTime");
	self.operatingTime = 0;	
	self.ohX = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.attachableOperatingHours#posX"), 0.6543);
	self.ohY = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.attachableOperatingHours#posY"), 0.1315);
	self.ohX2 = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.attachableOperatingHours#posX2"), 0.6543);
	self.ohY2 = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.attachableOperatingHours#posY2"), 0.1715);
	self.yOffset = 0.0087;
	self.yOffset2 = 0.0107;
	self.ohOverlayNew = Overlay:new("hudOHOverlayNew", Utils.getFilename("Textur/Textur_BP/attachableOperatingHours_hud_new.png", self.baseDirectory), self.ohX, self.ohY, 0.11855, 0.039525)
	self.ohOverlay2New = Overlay:new("hudOHOverlay2New", Utils.getFilename("Textur/Textur_BP/attachableOperatingHours_hud2_new.png", self.baseDirectory), self.ohX2, self.ohY2, 0.11855, 0.039525);
	self.displayHUD2 = false;
	self.ohOverlayOld = Overlay:new("hudOHOverlayOld", Utils.getFilename("Textur/Textur_BP/attachableOperatingHours_hud_old.png", self.baseDirectory), self.ohX, self.ohY, 0.11855, 0.039525)
	self.ohOverlay2Old = Overlay:new("hudOHOverlay2Old", Utils.getFilename("Textur/Textur_BP/attachableOperatingHours_hud2_old.png", self.baseDirectory), self.ohX2, self.ohY2, 0.11855, 0.039525);
	self.displayHUD2Old = false;
end;

function attachableOperatingHours:delete()
end;

function attachableOperatingHours:readStream(streamId, connection)
	self:addOperatingTime(streamReadFloat32(streamId), true);
end;

function attachableOperatingHours:writeStream(streamId, connection)
	streamWriteFloat32(streamId, self.operatingTime);
end;

function attachableOperatingHours:mouseEvent(posX, posY, isDown, isUp, button)
end;

function attachableOperatingHours:keyEvent(unicode, sym, modifier, isDown)
end;

function attachableOperatingHours:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLEHUD2) then
			if self.displayHUD2 then
				self.displayHUD2 = false;
				self.displayHUDOld2 = false;
			else
				self.displayHUD2 = true;
				self.displayHUDOld2 = false;
			end;
		end;
		if InputBinding.hasEvent(InputBinding.TOGGLEHUDOLD2) then
			if self.displayHUDOld2 then
				self.displayHUDOld2 = false;
				self.displayHUD2 = false;
			else
				self.displayHUDOld2 = true;
				self.displayHUD2 = false;
			end;
		end;
	end;
end;

function attachableOperatingHours:updateTick(dt)
    if self.isTurnedOn then 
		self:addOperatingTime(dt);
	end;
end;

function attachableOperatingHours:draw()
	local attachableOperatingHours = math.floor((self.operatingTime / 1000 / 60 / 60)*10) / 10;
	local Hours = math.floor(attachableOperatingHours);
	local Minutes = tostring(math.floor((attachableOperatingHours - Hours)*10));
	
	if self.displayHUD2 then
		self.ohOverlayNew:render();
		self.ohOverlay2New:render();
		
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("HIDE_HUD"), self.typeDesc), InputBinding.TOGGLEHUD2);
		
		setTextAlignment(RenderText.ALIGN_RIGHT);
		setTextBold(true);	
		
		setTextColor(0, 0, 0, 1);
		renderText(self.ohX+0.062, self.ohY+self.yOffset, 0.022, tostring(Hours) .. ",");
		renderText(self.ohX+0.085, self.ohY+0.057, 0.014, "Arbeitsstunden");
		renderText(self.ohX+0.08, self.ohY+0.047, 0.014, "der Maschine");
		renderText(self.ohX+0.08, self.ohY+self.yOffset, 0.022, "h");
		renderText(self.ohX+0.071, self.ohY+self.yOffset, 0.022, Minutes);
		
		setTextColor(1, 1, 1, 1);
		renderText(self.ohX+0.062, self.ohY+self.yOffset2, 0.022, tostring(Hours) .. ",");
		renderText(self.ohX+0.085, self.ohY+0.059, 0.014, "Arbeitsstunden");
		renderText(self.ohX+0.08, self.ohY+0.049, 0.014, "der Maschine");
		renderText(self.ohX+0.08, self.ohY+self.yOffset2, 0.022, "h");
		
		setTextColor(0.95,0,0,1);
		renderText(self.ohX+0.071, self.ohY+self.yOffset2, 0.022, Minutes);
	
		setTextAlignment(RenderText.ALIGN_LEFT);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("SHOW_NEW_HUD"), self.typeDesc), InputBinding.TOGGLEHUD2);
	end;
	
	if self.displayHUDOld2 then
		self.ohOverlayOld:render();
		self.ohOverlay2Old:render();
		
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("HIDE_HUD"), self.typeDesc), InputBinding.TOGGLEHUDOLD2);
		
		setTextAlignment(RenderText.ALIGN_RIGHT);
		setTextBold(true);	
		
		setTextColor(0, 0, 0, 1);
		renderText(self.ohX+0.062, self.ohY+self.yOffset, 0.022, tostring(Hours) .. ",");
		renderText(self.ohX+0.085, self.ohY+0.057, 0.014, "Arbeitsstunden");
		renderText(self.ohX+0.08, self.ohY+0.047, 0.014, "der Maschine");
		renderText(self.ohX+0.08, self.ohY+self.yOffset, 0.022, "h");
		renderText(self.ohX+0.071, self.ohY+self.yOffset, 0.022, Minutes);
		
		setTextColor(1, 1, 1, 1);
		renderText(self.ohX+0.062, self.ohY+self.yOffset2, 0.022, tostring(Hours) .. ",");
		renderText(self.ohX+0.085, self.ohY+0.059, 0.014, "Arbeitsstunden");
		renderText(self.ohX+0.08, self.ohY+0.049, 0.014, "der Maschine");
		renderText(self.ohX+0.08, self.ohY+self.yOffset2, 0.022, "h");
		
		setTextColor(0.95,0,0,1);
		renderText(self.ohX+0.071, self.ohY+self.yOffset2, 0.022, Minutes);
	
		setTextAlignment(RenderText.ALIGN_LEFT);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("SHOW_OLD_HUD"), self.typeDesc), InputBinding.TOGGLEHUDOLD2);
	end;
end;

function attachableOperatingHours:addOperatingTime(addTime)
	local time = math.max(Utils.getNoNil(addTime, 0), 0);	
	self.operatingTime = self.operatingTime + time;	
	
	if self.operatingTime > (99999.9 * 1000 * 60 * 60) then
		self.operatingTime = 0;
	end;
end;

function attachableOperatingHours:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local operatingTime = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#operatingTime"), self.operatingTime) * 1000;
	self:addOperatingTime(operatingTime);
    return BaseMission.VEHICLE_LOAD_OK;
end;

function attachableOperatingHours:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'operatingTime="' .. tostring((self.operatingTime / 1000)) ..'"';
	return attributes, nil;
end;