-- VehicleIncreaseRpmBaler 
-- Spezi fr eine erhhte Drezahl beim Pressen.
-- Datum: 27.12.2013
-- Autor: Ifko[nator] alex2009 meyer123
-- Last Edit: 10.03.2014 by Ifko[nator]

VehicleIncreaseRpmBaler = {};

function VehicleIncreaseRpmBaler.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Baler, specializations);
end;

function VehicleIncreaseRpmBaler:load(xmlFile)
	self.modDir_VehicleIncreaseRpmBaler = self.baseDirectory;
	self.setVehicleIncreaseRpmBaler = SpecializationUtil.callSpecializationsFunction("setVehicleIncreaseRpmBaler");
end;

function VehicleIncreaseRpmBaler:delete()
end;

function VehicleIncreaseRpmBaler:mouseEvent(posX, posY, isDown, isUp, button)
end;

function VehicleIncreaseRpmBaler:keyEvent(unicode, sym, modifier, isDown)
end;

function VehicleIncreaseRpmBaler:update(dt)
	if self.modDir_VehicleIncreaseRpmBaler == self.baseDirectory then
		if self:getIsActive() then
			if self.isTurnedOn then
				if self.lastAttacherVehicle == nil then
					self.lastAttacherVehicle = self.attacherVehicle
				end;
				if self.attacherVehicle ~= nil or self.lastAttacherVehicle ~= nil then
					if self.attacherVehicle.motor ~= nil then
						self:setVehicleIncreaseRpmBaler(dt, true);
					end;
				end;
			else
				self:setVehicleIncreaseRpmBaler(nil, false);
			end;
		end;
	end;
end;

function VehicleIncreaseRpmBaler:setVehicleIncreaseRpmBaler(dt, isActive)
	if self.attacherVehicle ~= nil and self.saveMinimumRpm ~= 0 and self.attacherVehicle.motor ~= nil then
		if dt ~= nil then
			if isActive == true then
				self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-(dt*2), -1800);
			else
				self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+(dt*5), self.saveMinimumRpm);
			end;
		else
			self.attacherVehicle.motor.minRpm = self.saveMinimumRpm;
		end;
	end;
end;

function VehicleIncreaseRpmBaler:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
	if self.attacherVehicleCopy1 == nil then
		self.attacherVehicleCopy1 = self.attacherVehicle;
	end;
	if self.attacherVehicle.motor ~= nil then
		self.saveMinimumRpm = self.attacherVehicle.motor.minRpm;
	else
		if self.attacherVehicle.saveMinRpm ~= nil then
			self.saveMinimumRpm = self.attacherVehicle.saveMinimumRpm;
		else
			self.attacherVehicle.saveMinimumRpm  = 100;
		end;
	end;
end;

function VehicleIncreaseRpmBaler:onDetach()
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy1 == steerable then
			steerable.motor.minRpm = self.saveMinimumRpm;
			self.attacherVehicleCopy1 = nil;
		end;
	end;
end;

function VehicleIncreaseRpmBaler:setIsTurnedOn(isTurnedOn, noEventSend)
end;

function VehicleIncreaseRpmBaler:draw()
end