--
-- FahrAPN
-- This is the specialization for balers
--
-- @author  Manuel Leithner
-- @date  17/05/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
-- Gendert von: 	Ifko[nator]
-- am:			 	02.07.2013
-- Gendert wurde: 	Nun zustndig fr die Rotation der PickUp Federzinken einer Presse oder eines Ladewagens.

PickUpZinken = {};

function PickUpZinken.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations); --and SpecializationUtil.hasSpecialization(Cylindered, specializations);
end;

function PickUpZinken:load(xmlFile)
	self.rotationNodes = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.rotationNodes.rotationNode(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local rotSpeed = math.rad(Utils.getNoNil(getXMLFloat(xmlFile, key.."#rotSpeed"), 1)*0.001);
        if node ~= nil then
            table.insert(self.rotationNodes, {node=node, rotSpeed=rotSpeed, rotation=0});
        end;
        i = i + 1;
    end;
end;

function PickUpZinken:delete()
end;

function PickUpZinken:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PickUpZinken:keyEvent(unicode, sym, modifier, isDown)
end;

function PickUpZinken:update(dt)
	if self:getIsActive() then
        if self.isTurnedOn then
			for _, node in pairs(self.rotationNodes) do
				node.rotation = (node.rotation + dt*node.rotSpeed) % (2*math.pi);
				setRotation(node.node, node.rotation, 0, 0);
			end;
		end;
    end;
end;

function PickUpZinken:draw()
end

function PickUpZinken:onDetach()
end;

function PickUpZinken:onAttach(attacherVehicle, jointDescIndex)
end;

function PickUpZinken:setIsTurnedOn(isTurnedOn, noEventSend)
end;