--[[ 
	emptySquarebales
	Spezi um die letzten Ballen (maximal 2) einer Quaderballenpresse zu entleeren.
	Author:	Ifko[nator]
	Datum:	05.03.2014
	
	Edit: Der Motor des Traktors und die Presse müssen nun an sein, damit das Script arbeitet. 
		Es sind auch 3 neue Warnungen hinzugekommen: 
		Eine für den Hinweiß, dass der Motor des Traktors erst gestartet werden muss.
		Eine für den Hinweiß, dass die Ballenpresse erst angeschalten werden muss.
		Eine für den Hinweiß, dass die Ballenpresse bereits entleert ist.
	Edit am: 10.03.2014 by Ifko[nator]
	
	Fix: Das Script pfuscht nun nicht mehr in die 'attachableOpersatingHours.lua' rein.
	Gefixt am: 11.03.2014 von Ifko[nator] mit Hilfe von meyer123 und modelleicher.
	
	Erneuter Fix: Da Script ballert nun nicht mehr die LOG zu wenn man die Taste [Ö] drückt, ohne dass die Presse am Trecker hängt .. 
	Gefixt am: 13.03.2014 von Ifko[nator]
]]

emptySquarebales = {};

function emptySquarebales.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Baler, specializations);
end;

function emptySquarebales:load(xmlFile)
	self.startMotorFirst = false;
	self.startBalerFirst = false;
	self.moveBalesOutside = false;
	self.cantMoveBalesOutside = false;
end;

function emptySquarebales:delete()
end;

function emptySquarebales:mouseEvent(posX, posY, isDown, isUp, button)
end;

function emptySquarebales:keyEvent(unicode, sym, modifier, isDown)
end;

function emptySquarebales:update(dt)
	local startMotor = false;
	local startBaler = false;
	local moveBales = false;
	local cantMoveBales = false;
	if self:getIsActive() then
		if InputBinding.isPressed(InputBinding.Move_Bales_Out) then
			for k, bale in pairs(self.bales) do
				if self.attacherVehicle.isMotorStarted then
					if self.isTurnedOn then
						if bale.time > 0.4384 then
							local sendTime = math.min(1, bale.time+dt/30000);
							self.setBaleTime(self, k, sendTime, true);
							moveBales = true;
						else
							cantMoveBales = true;
						end;
					else
						startBaler = true;
					end;
				else
					startMotor = true;
				end;
			end;
		end;
	end;
	self.startMotorFirst = startMotor;
	self.startBalerFirst = startBaler;
	self.moveBalesOutside = moveBales;
	self.cantMoveBalesOutside = cantMoveBales;
	return;
end;

	
function emptySquarebales:draw()
	g_currentMission:addHelpButtonText(g_i18n:getText("Move_Bales_Out"), InputBinding.Move_Bales_Out);
	if self.startMotorFirst then
		g_currentMission:addWarning(g_i18n:getText("startMotorFirst"), 0.040, 0.035);
	elseif self.startBalerFirst then
		g_currentMission:addWarning(g_i18n:getText("startBalerFirst"), 0.040, 0.035);
	elseif self.moveBalesOutside then
		g_currentMission:addWarning(g_i18n:getText("moveBalesOutside"), 0.040, 0.035);
	elseif self.cantMoveBalesOutside then
		g_currentMission:addWarning(g_i18n:getText("cantMoveBalesOutside"), 0.040, 0.035);
	end;
end;