--
-- BaleCounter
-- Specialization for baler to display a bale counter.
--
-- @author  	Benjamin Biot (J&B Modding)
-- @version 	v1.0
-- @date  		30/11/10
--
-- Edit by Ifko[nator]
-- Geändert wurde: Man kann bei den Backgroundhud's zwischen dem alten und neuem Overlay hin und her wechseln.
-- Edit am: 13.03.2014

KroneBigPackBaleCounter = {};

function KroneBigPackBaleCounter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Baler, specializations);
end;

function KroneBigPackBaleCounter:load(xmlFile)
	self.KroneBigPackSetBaleCount= SpecializationUtil.callSpecializationsFunction("KroneBigPackSetBaleCount");
	
	self.FileOld = Utils.getFilename("Textur/Textur_BP/KroneBigPackBallenHudOld.png", self.baseDirectory);
	self.hudPosX = 0.05;
    self.hudPosY = 0.025; 
    self.hudWidth = 0.300;
    self.hudHeight = 0.200;
    self.HudKroneBigPackOld = Overlay:new("HudKroneBigPackOld", self.FileOld, self.hudPosX, self.hudPosY, self.hudWidth, self.hudHeight);
    self.displayHUDOld = false;
	
	self.FileNew = Utils.getFilename("Textur/Textur_BP/KroneBigPackBallenHudNew.png", self.baseDirectory);
    self.HudKroneBigPackNew = Overlay:new("HudKroneBigPackNew", self.FileNew, self.hudPosX, self.hudPosY, self.hudWidth, self.hudHeight);
    self.displayHUD = false;
	
	self.KroneBigPackTotalBalesCount = 0;
	self.KroneBigPackCurrentBalesCount = 0;
	self.KroneBigPackNoRopesBalesCount = 0;
end;

function KroneBigPackBaleCounter:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
   local KroneBigPackTotalBalesCount =  Utils.getNoNil(getXMLInt(xmlFile, key.."#KroneBigPackTotalBalesCount"),0);
   local KroneBigPackNoRopesBalesCount =  Utils.getNoNil(getXMLInt(xmlFile, key.."#KroneBigPackNoRopesBalesCount"),0);
   self.KroneBigPackTotalBalesCount = KroneBigPackTotalBalesCount;
   self.KroneBigPackNoRopesBalesCount = KroneBigPackNoRopesBalesCount;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function KroneBigPackBaleCounter:getSaveAttributesAndNodes(nodeIdent)
   local KroneBigPackTotalBalesCount= Utils.getNoNil(self.KroneBigPackTotalBalesCount, 0);
   local KroneBigPackNoRopesBalesCount= Utils.getNoNil(self.KroneBigPackNoRopesBalesCount, 0);
    local attributes = 'KroneBigPackTotalBalesCount="'..string.format("%.1f",KroneBigPackTotalBalesCount)..'" KroneBigPackNoRopesBalesCount="'..string.format("%.1f",KroneBigPackNoRopesBalesCount)..'"';
   return attributes, nil;
end;

function KroneBigPackBaleCounter:delete()
end;

function KroneBigPackBaleCounter:readStream(streamId, connection)
    self.KroneBigPackTotalBalesCount = streamReadInt32(streamId);
    self.KroneBigPackNoRopesBalesCount = streamReadInt32(streamId);
    self.KroneBigPackCurrentBalesCount = streamReadInt32(streamId);
end;

function KroneBigPackBaleCounter:writeStream(streamId, connection)
    streamWriteInt32(streamId, self.KroneBigPackTotalBalesCount);
    streamWriteInt32(streamId, self.KroneBigPackNoRopesBalesCount);
    streamWriteInt32(streamId, self.KroneBigPackCurrentBalesCount);
end;

function KroneBigPackBaleCounter:readUpdateStream(streamId, timestamp, connection)
end;

function KroneBigPackBaleCounter:writeUpdateStream(streamId, connection, dirtyMask)
end;

function KroneBigPackBaleCounter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KroneBigPackBaleCounter:keyEvent(unicode, sym, modifier, isDown)
end;

function KroneBigPackBaleCounter:update(dt)		
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLEHUD) then
			if self.displayHUD then
				self.displayHUD = false;
				self.displayHUDOld = false;
			else
				self.displayHUD = true;
				self.displayHUDOld = false;
			end;
		end;
		if InputBinding.hasEvent(InputBinding.TOGGLEHUDOLD) then
			if self.displayHUDOld then
				self.displayHUDOld = false;
				self.displayHUD = false;
			else
				self.displayHUDOld = true;
				self.displayHUD = false;
			end;
		end;
	end;
end;

function KroneBigPackBaleCounter:updateTick(dt)	
end;

function KroneBigPackBaleCounter:draw()
	setTextBold(true);
	setTextAlignment(RenderText.ALIGN_RIGHT);
	setTextColor(1, 1, 1, 1);
	
	if self.displayHUD then
		self.HudKroneBigPackNew:render();
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("HUD_OFF"), self.typeDesc), InputBinding.TOGGLEHUD);
		if self.KroneBigPackCurrentBalesCount~= nil then
			renderText(0.165, 0.157, 0.020, string.format(self.KroneBigPackCurrentBalesCount));
		end;
		if self.KroneBigPackTotalBalesCount~= nil then
			renderText(0.165, 0.086, 0.020, string.format(self.KroneBigPackTotalBalesCount));
		end;
	else
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("HUD_ON"), self.typeDesc), InputBinding.TOGGLEHUD);	
	end;
	
	if self.displayHUDOld then
		self.HudKroneBigPackOld:render();
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("HUD_OFF"), self.typeDesc), InputBinding.TOGGLEHUDOLD);
		if self.KroneBigPackCurrentBalesCount~= nil then
			renderText(0.165, 0.157, 0.020, string.format(self.KroneBigPackCurrentBalesCount));
		end;
		if self.KroneBigPackTotalBalesCount~= nil then
			renderText(0.165, 0.086, 0.020, string.format(self.KroneBigPackTotalBalesCount));
		end;
	else
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("HUD_ON_OLD"), self.typeDesc), InputBinding.TOGGLEHUDOLD);	
	end;
end;

function KroneBigPackBaleCounter.dropBale(self, baleIndex)
	if self.KroneBigPackCurrentBalesCount ~= nil and self.KroneBigPackTotalBalesCount ~= nil and self.KroneBigPackNoRopesBalesCount ~= nil then
		self.KroneBigPackCurrentBalesCount = self.KroneBigPackCurrentBalesCount +1;
		self.KroneBigPackTotalBalesCount = self.KroneBigPackTotalBalesCount +1;
		self.KroneBigPackNoRopesBalesCount = self.KroneBigPackNoRopesBalesCount +1;
	end;
end;

Baler.dropBale = Utils.appendedFunction(Baler.dropBale, KroneBigPackBaleCounter.dropBale);