-- Regestrierung von neuen Frchten im LS 13
-- Vorlage: ffentliche Script Doku http://www.ls-mods.de/scriptDocumentation.php by GIANTS Software GmbH

-- Author:	Ifko[nator]
-- Datum:	05.07.2013

-- Gendert am:	11.07.2013
-- Gendert wurde: Frucht Typ Mist hinzugefgt damit das Frderband am Mistzwischenlager funktioniert!

-- Erneut gendert am:	17.07.2013
-- Gendert wurde: Manure Mod hinzugefgt.

-- Erneut gendert am:	18.07.2013
-- Gendert wurde: Roggen- und Haferstroh haben nun als filltype "barley_windrow" um maximale kompatibilitt zu gewhrleisten!

-- Erneut nderung am: 	26.07.2013
-- Gndert wurde: Pfade auf den Finalen .zip Namen angepasst und Farben der neuen Frchten in der Fruchtsortenbersicht inGame angepasst.

-- Erneut nderung am:	04.08.2013
-- Gendert wurde: Reg Animal von Marhu hinzugefgt.

-- Letzte nderung am:	17.08.2013
-- Gendert wurde: Fertilizer(Kunstdnger) Mod wurde hinzugefgt.

-- Alle nderungen von: Ifko[nator] 

local regFileLUA = g_currentModDirectory.."textures/huds/";

-- Sonnenblumen

print("  Register fruit type: Sonnenblumen on: Ifko World");
local sunflowerHudFile = regFileLUA.."sunflowerHud.dds";
FruitUtil.registerFruitType("sunflower", g_i18n:getText("sunflower"), true, true, false, 0, 4, 6, 8, false, 0.5, 2.0, 0.05, true, sunflowerHudFile, {1, 1, 1, 1});

local origSowingMachineLoad = SowingMachine.load;
local orig TrailerLoad =  Trailer.load;

SowingMachine.load = function (self, xmlFile)
	if origSowingMachineLoad ~= nil then
		origSowingMachineLoad(self, xmlFile);
	end;
	
	for k,v in pairs(self.seeds) do  
		fruitTypeDesc = FruitUtil.fruitTypes["maize"];
		if v == fruitTypeDesc.index then
			table.insert(self.seeds, FruitUtil.fruitTypes["sunflower"].index);
		end;
	end
end;

-- Hanf

print("  Register fruit type: Hanf on: Ifko World");
local weedHudFile = regFileLUA.."weedHud.dds";
FruitUtil.registerFruitType("weed", g_i18n:getText("weed"), true, true, false, 0, 4, 6, 8, false, 0.5, 2.0, 0.05, true, weedHudFile, {1, 0.6, 1, 1});

local origSowingMachineLoad = SowingMachine.load;
local orig TrailerLoad =  Trailer.load;

SowingMachine.load = function (self, xmlFile)
	if origSowingMachineLoad ~= nil then
		origSowingMachineLoad(self, xmlFile);
	end;
	
	for k,v in pairs(self.seeds) do  
		fruitTypeDesc = FruitUtil.fruitTypes["maize"];
		if v == fruitTypeDesc.index then
			table.insert(self.seeds, FruitUtil.fruitTypes["weed"].index);
		end;
	end
end

-- Roggen

print("  Register fruit type: Roggen on: Ifko World");
local ryeHudFile = regFileLUA.."ryeHud.dds";
FruitUtil.registerFruitType( "rye", g_i18n:getText("rye"), true, true, false, 0, 4, 6, 8, true, 0.3, 1.5, 0.1, true, ryeHudFile,  {0.1, 0.1, 0.9, 1});		

-- Stroh Anfang
FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_RYE, "barley_windrow", g_i18n:getText("straw"), 0.04, 3, false, Utils.getFilename("mods/IfkoWorldAddOn/textures/huds/hud_fill_straw.dds", getUserProfileAppPath()));
-- Stroh Ende
	
local origSowingMachineLoad = SowingMachine.load;
local orig TrailerLoad =  Trailer.load;

SowingMachine.load = function (self, xmlFile)
	if origSowingMachineLoad ~= nil then
		origSowingMachineLoad(self, xmlFile);
	end;
	
	for k,v in pairs(self.seeds) do  
		fruitTypeDesc = FruitUtil.fruitTypes["wheat"];
		if v == fruitTypeDesc.index then
			table.insert(self.seeds, FruitUtil.fruitTypes["rye"].index);
		end;
	end
end;

-- Hafer

print("  Register fruit type: Hafer on: Ifko World");
local oatHudFile = regFileLUA.."oatHud.dds";
FruitUtil.registerFruitType("oat", g_i18n:getText("oat"), true, true, false, 0, 4, 6, 8, true, 0.25, 1.2, 0.05, true, oatHudFile, {0.5, 0.5, 0, 1});

-- Stroh Anfang
FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_OAT, "barley_windrow", g_i18n:getText("straw"), 0.04, 3, false, Utils.getFilename("mods/IfkoWorldAddOn/textures/huds/hud_fill_straw.dds", getUserProfileAppPath()));
-- Stroh Ende

local origSowingMachineLoad = SowingMachine.load;
local orig TrailerLoad =  Trailer.load;

SowingMachine.load = function (self, xmlFile)
	if origSowingMachineLoad ~= nil then
		origSowingMachineLoad(self, xmlFile);
	end;
	
	for k,v in pairs(self.seeds) do  
		fruitTypeDesc = FruitUtil.fruitTypes["wheat"];
		if v == fruitTypeDesc.index then
			table.insert(self.seeds, FruitUtil.fruitTypes["oat"].index);
		end;
	end
end;

-- Mist - wird fr das Mistladeband beim Mistzwischenlager bentigt!

print("  Register fruit type: Mist on: Ifko World");
FruitUtil.registerFruitType("manure", false, false, true, 1, 100, 2, 1, 1, nil)


local orig TrailerLoad =  Trailer.load;

-- Manure, Liquidmanure Mod by TMT 
-- Fertilizer Mod added by Ifko[nator]

print("  Register Manure, Liquidmanure and Fertilizer Mod on: Ifko World");
FruitUtil.registerFruitType("manureSolid", false, false, true, 1, 100, 2, 1, 1, nil)
FruitUtil.registerFruitType("manureLiquid", false, false, true, 1, 100, 2, 1, 1, nil)
FruitUtil.registerFruitType("fertilizerSolid", false, false, true, 1, 100, 2, 1, 1, nil)

FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_MANURESOLID, "manureSolid_windrow", g_i18n:getText("manure"), 0, 3, false, nil );
FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_MANURELIQUID, "manureLiquid_windrow", g_i18n:getText("liquidManure"), 0, 3, false, nil );
FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_FERTILIZERSOLID, "fertilizerSolid_windrow", g_i18n:getText("fertilizer"), 0, 3, false, nil );

local orgi_sprayerUpdateTick = Sprayer.updateTick
Sprayer.updateTick = function(self, dt)
	orgi_sprayerUpdateTick(self, dt)
	if self.isTurnedOn and self.fillLevel > 0 then
		local windrowId = nil;
		if self.currentFillType == Fillable.FILLTYPE_MANURE then
			if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID] then
				windrowId = g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID].windrowId;
			end;
		elseif self.currentFillType == Fillable.FILLTYPE_LIQUIDMANURE then
			if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID] then
				windrowId = g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID].windrowId;
			end;
		elseif self.currentFillType == Fillable.FILLTYPE_FERTILIZER then
			if g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID] then
				windrowId = g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID].windrowId;
			end;
		end;
		if windrowId ~= nil then
			for i = 1, table.getn(self.cuttingAreas) do
				local x, y, z = getWorldTranslation(self.cuttingAreas[i].start)
				local x1, y1, z1 = getWorldTranslation(self.cuttingAreas[i].width)
				local x2, y2, z2 = getWorldTranslation(self.cuttingAreas[i].height)
				Utils.updateManureWindrowArea(windrowId, x, z, x1, z1, x2, z2)
			end;
		end;
	end;
end;

Utils.updateManureWindrowArea = function(windrowId, x, z, x1, z1, x2, z2)
	local IDs,detailId = {},g_currentMission.terrainDetailId;
	table.insert(IDs,g_currentMission.cultivatorChannel);
	table.insert(IDs,g_currentMission.sowingChannel);
	table.insert(IDs,g_currentMission.ploughChannel);
	local dx, dz, dwidthX, dwidthZ, dheightX, dheightZ = Utils.getXZWidthAndHeight(detailId, x, z, x1, z1, x2, z2)
	for i = 1, table.getn(IDs) do
		setDensityMaskedParallelogram(windrowId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, 0, 1, detailId, IDs[i], 1, 1)
	end
end;

local orgi_UpdateDestroyCommonArea = Utils.updateDestroyCommonArea;
Utils.updateDestroyCommonArea = function(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
	orgi_UpdateDestroyCommonArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
end;

local orgi_cutFruitArea = Utils.cutFruitArea;
Utils.cutFruitArea =  function(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, destroySpray, destroySeedingWidth)
	local pixelsSum, numPixels, spraySum = orgi_cutFruitArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, destroySpray, destroySeedingWidth);
	if destroySpray then
		if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID] ~= nil then
			Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
		end;
		if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID] ~= nil then
			Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
		end;
		if g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID] ~= nil then
			Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
		end;
	end;
	return pixelsSum, numPixels, spraySum;
end;

local orgi_updateSowingArea = Utils.updateSowingArea;
Utils.updateSowingArea = function(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, angle, useDirectPlanting)
	local numPixels, numDetailPixels = orgi_updateSowingArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, angle, useDirectPlanting);
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_FERTILIZERSOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	return numPixels, numDetailPixels;
end;


-- Reg Animal by Marhu

RegAnimal = {};
RegAnimal.dir = g_currentModDirectory

local org_FSBaseMission_loadMap = FSBaseMission.loadMap
FSBaseMission.loadMap = function(a, b, c, d, e)
	if a.baseDirectory == RegAnimal.dir then
		local xmlFile = loadXMLFile("TempXML", RegAnimal.dir.."modDesc.xml");
		local Key = "modDesc.RegAnimal";
		local i=0;
		while true do
			local AnimalKey = Key..string.format(".Animal(%d)", i);
			if not hasXMLProperty(xmlFile, AnimalKey) then
				break;
			end;
			local name = getXMLString(xmlFile, AnimalKey.."#name");
			local price = getXMLFloat(xmlFile, AnimalKey.."#price");
			local Eco = getXMLBool(xmlFile, AnimalKey.."#Eco");
			local hud = getXMLString(xmlFile, AnimalKey.."#hud");
			local HudFile = RegAnimal.dir..hud;
			local FillType = Fillable.registerFillType(name, g_i18n:getText(name), price, Eco, HudFile)
			if Fillable.fillTypeIndexToDesc[FillType].nameI18N then
				FSBaseMission.addFillTypeOverlay(a,FillType,HudFile)
				print("  Register animal type: Schwein on: Ifko World");
			end
			i=i+1;
		end;
		delete(xmlFile);
	end
	ra,rb,rc,rd,re = org_FSBaseMission_loadMap(a, b, c, d, e)
	return ra,rb,rc,rd,re 
end