--
-- CutterParticle
-- This is the CutterParticle
--
-- M@D Author  Mr. F
-- M@D date 02.09.2009
--
-- > Copyright (C) Mr. F - www.planet-ls.de < --

-- Edit to CutterParticleSunflower by Ifko[nator]

-- Date of edit: 23.08.2013

CutterParticleSunflower = {};

function CutterParticleSunflower.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function CutterParticleSunflower:load(xmlFile)


	self.cutterSunflowerParticleSystems = {};
	local numsunflowerParticleAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.sunflowerParticleAreas#count"), 0);
    self.sunflowerParticleAreas = {};   
	for i=1, numsunflowerParticleAreas do
        local key = string.format("vehicle.cutterSunflowerParticleSystem.cutterSunflowerParticleSystem(%d)", i-1);
		local currentPS = {};
		local particleNode = Utils.loadStaticParticleSystem(xmlFile, currentPS, key, self.components, false, nil, self.baseDirectory);
		table.insert(self.cutterSunflowerParticleSystems, currentPS);
        self.sunflowerParticleAreas[i] = {};
        local areanamei = string.format("vehicle.sunflowerParticleAreas.sunflowerParticleArea%d", i);
        self.sunflowerParticleAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.sunflowerParticleAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.sunflowerParticleAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;
	

end;

function CutterParticleSunflower:delete()

	for i=1, table.getn(self.cutterSunflowerParticleSystems) do
		Utils.deleteParticleSystem(self.cutterSunflowerParticleSystems[i]);
	end;
	
end;

function CutterParticleSunflower:mouseEvent(posX, posY, isDown, isUp, button)
end;

function CutterParticleSunflower:keyEvent(unicode, sym, modifier, isDown)
end;

function CutterParticleSunflower:update(dt)

	if self:getIsActive() then
		
		if self.movingDirection < 0 and self.reelStarted and self.attacherVehicle.allowsThreshing then
			for k,area in pairs(self.sunflowerParticleAreas) do
				local x,y,z = getWorldTranslation(area.start);
				local x1,y1,z1 = getWorldTranslation(area.width);
				local x2,y2,z2 = getWorldTranslation(area.height);   
				local area = Utils.getFruitArea(FruitUtil.FRUITTYPE_SUNFLOWER, x, z, x1, z1, x2, z2);
				
				if area > 0 then	 

					Utils.setEmittingState(self.cutterSunflowerParticleSystems[k], true);
				else
					Utils.setEmittingState(self.cutterSunflowerParticleSystems[k], false);
				end;
			end;
		else
		
			for k,area in pairs(self.cutterSunflowerParticleSystems) do
				Utils.setEmittingState(self.cutterSunflowerParticleSystems[k], false);
			end;
		
		end;
		
	end;
	
	
end;

function CutterParticleSunflower:updateTick(dt)

    --if self:getIsActive() then
        --if self.foldMoveDirection > 0.1 or (self.foldMoveDirection == 0 and self.foldAnimTime > 0.5) then
           --self.attacherVehicle.attacherJoints[1].moveDown = true;
        --end;
	--end;
	
end;

function CutterParticleSunflower:draw()
end;

function CutterParticleSunflower:onDetach()
    CutterParticleSunflower.onDeactivate(self);
end;

function CutterParticleSunflower:onLeave()
	CutterParticleSunflower.onDeactivate(self);
end;

function CutterParticleSunflower:onDeactivate()
    for k,area in pairs(self.cutterSunflowerParticleSystems) do
		Utils.setEmittingState(self.cutterSunflowerParticleSystems[k], false);
	end;
end;


Utils.loadStaticParticleSystem = function(xmlFile, psTable, baseString, linkNode, defaultEmittingState, filename, baseDirectory)
	--
	-- Static Particle System
	--
	-- Author:  Heady | www.planet-ls.de
	-- Date: 30.04.2011
	--
	--
	
	local defaultLinkNode = linkNode;
		if type(linkNode) == "table" then
			defaultLinkNode = linkNode[1].node;
		end;
	local linkNode = Utils.getNoNil(Utils.indexToObject(linkNode, getXMLString(xmlFile, baseString .. "#node")), defaultLinkNode);

	local psFile = getXMLString(xmlFile, baseString .. "#file");
	if psFile == nil then
		psFile = filename;
	end;
	if psFile == nil then
		return;
	end;
	psFile = Utils.getFilename(psFile, baseDirectory);  
	local rootNode = loadI3DFile(psFile);
	if rootNode == 0 then
		print("Error: failed to load particle system " .. psFile);
		return;
	end	
	
	link(linkNode, rootNode)	

	local posString = getXMLString(xmlFile, baseString .. "#position");
	if posString ~= nil then
		local posX, posY, posZ = Utils.getVectorFromString(posString);
		setTranslation(rootNode, posX, posY, posZ);
	end;	
	local rotString = getXMLString(xmlFile, baseString .. "#rotation");
	if rotString ~= nil then
		local rotX, rotY, rotZ = Utils.getVectorFromString(rotString);
		rotX = Utils.degToRad(rotX);
		rotY = Utils.degToRad(rotY);
		rotZ = Utils.degToRad(rotZ);
		setRotation(rootNode, rotX, rotY, rotZ);
	end;

	--for i = getNumOfChildren(rootNode) - 1, 0, -1 do
	for i=1, getNumOfChildren(rootNode) do
		local child = getChildAt(rootNode, i-1);
		if getClassName(child) == "Shape" then
			local geometry = getGeometry(child);
			if geometry ~= 0 and getClassName(geometry) == "ParticleSystem" then
				table.insert(psTable, {geometry = geometry, shape = child});
				if defaultEmittingState ~= nil then
					setEmittingState(geometry, defaultEmittingState);
				end;
			end;
		end;
	end;

	return rootNode;
end;