--
-- BaleCounter
-- Specialization for baler to display a bale counter.
--
-- @author  	Benjamin Biot (J&B Modding)
-- @version 	v1.0
-- @date  		30/11/10
--
-- @edit		Ifko[nator]
-- @date		27/05/2013

KroneComprimaBaleCounterIfkoWorld = {};

function KroneComprimaBaleCounterIfkoWorld.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Baler, specializations);
end;

function KroneComprimaBaleCounterIfkoWorld:load(xmlFile)
	self.KroneComprimaIfkoWorldSetBaleCount= SpecializationUtil.callSpecializationsFunction("KroneComprimaIfkoWorldSetBaleCount");
	--  HUD --
	self.File = Utils.getFilename("Fahrzeuge/Trailer/Rundballentechnik_Pack_by_Ifko/Textur/Textur_V180/KroneComprimaBallenHud.png", self.baseDirectory);
	self.hudPoxX = 0.05;
    self.hudPoxY = 0.025; 
    self.hudWidth = 0.300;
    self.hudHeight = 0.200;
    self.HUDNHBB = Overlay:new("HUDNHBB", self.File, self.hudPoxX, self.hudPoxY, self.hudWidth, self.hudHeight);
    self.HUD = false;
	
	self.KroneComprimaIfkoWorldTotalBalesCount = 0;
	self.KroneComprimaIfkoWorldCurrentBalesCount = 0;
	self.KroneComprimaIfkoWorldNoRopesBalesCount = 0;
end;

function KroneComprimaBaleCounterIfkoWorld:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
   local KroneComprimaIfkoWorldTotalBalesCount =  Utils.getNoNil(getXMLInt(xmlFile, key.."#KroneComprimaIfkoWorldTotalBalesCount"),0);
   local KroneComprimaIfkoWorldNoRopesBalesCount =  Utils.getNoNil(getXMLInt(xmlFile, key.."#KroneComprimaIfkoWorldNoRopesBalesCount"),0);
   self.KroneComprimaIfkoWorldTotalBalesCount = KroneComprimaIfkoWorldTotalBalesCount;
   self.KroneComprimaIfkoWorldNoRopesBalesCount = KroneComprimaIfkoWorldNoRopesBalesCount;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function KroneComprimaBaleCounterIfkoWorld:getSaveAttributesAndNodes(nodeIdent)
   local KroneComprimaIfkoWorldTotalBalesCount= Utils.getNoNil(self.KroneComprimaIfkoWorldTotalBalesCount, 0);
   local KroneComprimaIfkoWorldNoRopesBalesCount= Utils.getNoNil(self.KroneComprimaIfkoWorldNoRopesBalesCount, 0);
    local attributes = 'KroneComprimaIfkoWorldTotalBalesCount="'..string.format("%.1f",KroneComprimaIfkoWorldTotalBalesCount)..'" KroneComprimaIfkoWorldNoRopesBalesCount="'..string.format("%.1f",KroneComprimaIfkoWorldNoRopesBalesCount)..'"';
   return attributes, nil;
end;

function KroneComprimaBaleCounterIfkoWorld:delete()
end;

function KroneComprimaBaleCounterIfkoWorld:readStream(streamId, connection)
    self.KroneComprimaIfkoWorldTotalBalesCount = streamReadInt32(streamId);
    self.KroneComprimaIfkoWorldNoRopesBalesCount = streamReadInt32(streamId);
    self.KroneComprimaIfkoWorldCurrentBalesCount = streamReadInt32(streamId);
end;

function KroneComprimaBaleCounterIfkoWorld:writeStream(streamId, connection)
    streamWriteInt32(streamId, self.KroneComprimaIfkoWorldTotalBalesCount);
    streamWriteInt32(streamId, self.KroneComprimaIfkoWorldNoRopesBalesCount);
    streamWriteInt32(streamId, self.KroneComprimaIfkoWorldCurrentBalesCount);
end;

function KroneComprimaBaleCounterIfkoWorld:readUpdateStream(streamId, timestamp, connection)
end;

function KroneComprimaBaleCounterIfkoWorld:writeUpdateStream(streamId, connection, dirtyMask)
end;

function KroneComprimaBaleCounterIfkoWorld:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KroneComprimaBaleCounterIfkoWorld:keyEvent(unicode, sym, modifier, isDown)
end;

function KroneComprimaBaleCounterIfkoWorld:update(dt)		
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
			self.HUD = not self.HUD;
		end;
    end;
end;

function KroneComprimaBaleCounterIfkoWorld:updateTick(dt)	
end;

function KroneComprimaBaleCounterIfkoWorld:draw()
	setTextBold(true);
	setTextAlignment(RenderText.ALIGN_RIGHT);
	setTextColor(1, 1, 1, 1);
	if self.HUD then
		self.HUDNHBB:render();
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("HUD_OFF"), self.typeDesc), InputBinding.ACTIVATE_OBJECT);
		if self.KroneComprimaIfkoWorldCurrentBalesCount~= nil then
			renderText(0.165, 0.157, 0.020, string.format(self.KroneComprimaIfkoWorldCurrentBalesCount));
		end;
		if self.KroneComprimaIfkoWorldTotalBalesCount~= nil then
			renderText(0.165, 0.086, 0.020, string.format(self.KroneComprimaIfkoWorldTotalBalesCount));
		end;
	else
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("HUD_ON"), self.typeDesc), InputBinding.ACTIVATE_OBJECT);	
	end;
end;

function KroneComprimaBaleCounterIfkoWorld.dropBale(self, baleIndex)
	if self.KroneComprimaIfkoWorldCurrentBalesCount ~= nil and self.KroneComprimaIfkoWorldTotalBalesCount ~= nil and self.KroneComprimaIfkoWorldNoRopesBalesCount ~= nil then
		self.KroneComprimaIfkoWorldCurrentBalesCount = self.KroneComprimaIfkoWorldCurrentBalesCount +1;
		self.KroneComprimaIfkoWorldTotalBalesCount = self.KroneComprimaIfkoWorldTotalBalesCount +1;
		self.KroneComprimaIfkoWorldNoRopesBalesCount = self.KroneComprimaIfkoWorldNoRopesBalesCount +1;
	end;
end;

Baler.dropBale = Utils.appendedFunction(Baler.dropBale, KroneComprimaBaleCounterIfkoWorld.dropBale);