
-- BaleCounter
-- Specialization for baler to display a bale counter.

-- @author  	Benjamin Biot (J&B Modding)
-- @version 	v1.0
-- @date  		30/11/10

-- @edit		Ifko[nator]
-- @date		27/05/2013

-- @Bugfix		Speicherfehler behoben der Auftrat, 
--				wenn man die Quaderballenpresse aus 
--				dem einzelnen Quaderballentechnikpack 
--				gekauft hatte. Fhrte zur Zestrung 
--				der vehicles.xml. Danke an Jaguar95
--				fr die Meldung!

-- @date		03/06/2013 by Ifko[nator]


KroneBigPackBaleCounterIfkoWorld = {};

function KroneBigPackBaleCounterIfkoWorld.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Baler, specializations);
end;

function KroneBigPackBaleCounterIfkoWorld:load(xmlFile)
	self.KroneBigPackIfkoWorldSetBaleCount= SpecializationUtil.callSpecializationsFunction("KroneBigPackIfkoWorldSetBaleCount");
	--  HUD --
	self.File = Utils.getFilename("Fahrzeuge/Trailer/Quaderballentechnik_Pack_by_Ifko/Textur/Textur_BP/KroneBigPackBallenHud.png", self.baseDirectory);
	self.hudPoxX = 0.05;
    self.hudPoxY = 0.025; 
    self.hudWidth = 0.300;
    self.hudHeight = 0.200;
    self.HUDNHBB = Overlay:new("HUDNHBB", self.File, self.hudPoxX, self.hudPoxY, self.hudWidth, self.hudHeight);
    self.HUD = false;
	
	self.KroneBigPackIfkoWorldTotalBalesCount = 0;
	self.KroneBigPackIfkoWorldCurrentBalesCount = 0;
	self.KroneBigPackIfkoWorldNoRopesBalesCount = 0;
end;

function KroneBigPackBaleCounterIfkoWorld:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
   local KroneBigPackIfkoWorldTotalBalesCount =  Utils.getNoNil(getXMLInt(xmlFile, key.."#KroneBigPackIfkoWorldTotalBalesCount"),0);
   local KroneBigPackIfkoWorldNoRopesBalesCount =  Utils.getNoNil(getXMLInt(xmlFile, key.."#KroneBigPacIfkoWorldkNoRopesBalesCount"),0);
   self.KroneBigPackIfkoWorldTotalBalesCount = KroneBigPackIfkoWorldTotalBalesCount;
   self.KroneBigPackIfkoWorldNoRopesBalesCount = KroneBigPackIfkoWorldNoRopesBalesCount;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function KroneBigPackBaleCounterIfkoWorld:getSaveAttributesAndNodes(nodeIdent)
   local KroneBigPackIfkoWorldTotalBalesCount= Utils.getNoNil(self.KroneBigPackIfkoWorldTotalBalesCount, 0);
   local KroneBigPackIfkoWorldNoRopesBalesCount= Utils.getNoNil(self.KroneBigPackIfkoWorldNoRopesBalesCount, 0);
    local attributes = 'KroneBigPackIfkoWorldTotalBalesCount="'..string.format("%.1f",KroneBigPackIfkoWorldTotalBalesCount)..'" KroneBigPackIfkoWorldNoRopesBalesCount="'..string.format("%.1f",KroneBigPackIfkoWorldNoRopesBalesCount)..'"';
   return attributes, nil;
end;

function KroneBigPackBaleCounterIfkoWorld:delete()
end;

function KroneBigPackBaleCounterIfkoWorld:readStream(streamId, connection)
    self.KroneBigPackIfkoWorldTotalBalesCount = streamReadInt32(streamId);
    self.KroneBigPackIfkoWorldNoRopesBalesCount = streamReadInt32(streamId);
    self.KroneBigPackIfkoWorldCurrentBalesCount = streamReadInt32(streamId);
end;

function KroneBigPackBaleCounterIfkoWorld:writeStream(streamId, connection)
    streamWriteInt32(streamId, self.KroneBigPackIfkoWorldTotalBalesCount);
    streamWriteInt32(streamId, self.KroneBigPackIfkoWorldNoRopesBalesCount);
    streamWriteInt32(streamId, self.KroneBigPackIfkoWorldCurrentBalesCount);
end;

function KroneBigPackBaleCounterIfkoWorld:readUpdateStream(streamId, timestamp, connection)
end;

function KroneBigPackBaleCounterIfkoWorld:writeUpdateStream(streamId, connection, dirtyMask)
end;

function KroneBigPackBaleCounterIfkoWorld:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KroneBigPackBaleCounterIfkoWorld:keyEvent(unicode, sym, modifier, isDown)
end;

function KroneBigPackBaleCounterIfkoWorld:update(dt)		
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
			self.HUD = not self.HUD;
		end;
    end;
end;

function KroneBigPackBaleCounterIfkoWorld:updateTick(dt)	
end;

function KroneBigPackBaleCounterIfkoWorld:draw()
	setTextBold(true);
	setTextAlignment(RenderText.ALIGN_RIGHT);
	setTextColor(1, 1, 1, 1);
	if self.HUD then
		self.HUDNHBB:render();
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("HUD_OFF"), self.typeDesc), InputBinding.ACTIVATE_OBJECT);
		if self.KroneBigPackIfkoWorldCurrentBalesCount ~= nil then
			renderText(0.165, 0.157, 0.020, string.format(self.KroneBigPackIfkoWorldCurrentBalesCount));
		end;
		if self.KroneBigPackIfkoWorldTotalBalesCount ~= nil then
			renderText(0.165, 0.086, 0.020, string.format(self.KroneBigPackIfkoWorldTotalBalesCount));
		end;
	else
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("HUD_ON"), self.typeDesc), InputBinding.ACTIVATE_OBJECT);	
	end;
end;

function KroneBigPackBaleCounterIfkoWorld.dropBale(self, baleIndex)
	if self.KroneBigPackIfkoWorldCurrentBalesCount ~= nil and self.KroneBigPackIfkoWorldTotalBalesCount ~= nil and self.KroneBigPackIfkoWorldNoRopesBalesCount ~= nil then
		self.KroneBigPackIfkoWorldCurrentBalesCount = self.KroneBigPackIfkoWorldCurrentBalesCount +1;
		self.KroneBigPackIfkoWorldTotalBalesCount = self.KroneBigPackIfkoWorldTotalBalesCount +1;
		self.KroneBigPackIfkoWorldNoRopesBalesCount = self.KroneBigPackIfkoWorldNoRopesBalesCount +1;
	end;
end;

Baler.dropBale = Utils.appendedFunction(Baler.dropBale, KroneBigPackBaleCounterIfkoWorld.dropBale);