﻿-- ##############################################
-- #	Custom Info Trigger						#
-- #	version: 1.3							#
-- #	Date: 12.05.2013						#
-- #	author: [FSM]Webby /[FSM]Chefkoch		#
-- # 	Keine Veränderung ohne					# 
-- # 	meine Erlaubnis!						#
-- # 	No modification without					# 
-- # 	my permission!							#
-- #											#
-- #	MEGA THX 2:								#
-- #											#
-- #	Bluebaby210 (to save a XML in 			#
-- #	savegame for found Triggers) and much	#
-- #	more Stuff in this Script :)			#
-- #											#
-- #	Fiat80-90DT								#
-- #	webalizer								#
-- #	@planet-ls.de							#
-- #											#
-- #	4 helping me out 						#
-- #	with this Script						#
-- #											#
-- #	History:								#
-- #	v1.0 = Projekt started					#
-- #	v1.1 = Nomore HelpIcons in MP			#
-- #	v1.2 = variable TimeToShow				#
-- #	v1.3 = Nomore HelpIcons after Mapreload #
-- #											#
-- ############################################## 

-- Edit: Gehüpfe abgestellt und die Drehgeschwindigkeit den Originalen Icons angepasst.

-- Geändert am: 30.07.2013

print("CustomInfoTrigger v1.3 by [FSM]Chefkoch loaded!	Save and Load from XML by Bluebaby210")

ModEvent = {};

ModEvent.triggers = {};

function ModEvent:loadMap(name)

	local dir = getUserProfileAppPath() .. "savegame"..g_currentMission.missionInfo.savegameIndex;
	createFolder(dir);
	self.saveXMLFile = dir .. "/CustomInfoTrigger.xml";

	if g_currentMission.missionStats.playTime == 0 then
		self.firstRun = false;
	else
		self.firstRun = true;
	end;

end;

function ModEvent:deleteMap()	
	ModEvent.triggers = {};
end;

function ModEvent:delete()
end;

function ModEvent:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ModEvent:keyEvent(unicode, sym, modifier, isDown)
end;

function ModEvent:update(dt)

		if self.firstRun then
			ModEvent:loadCustomInfoTriggerFromXML();
			self.firstRun = false;			
		end;
		
end;

function ModEvent:draw()
	for i=1, table.getn(ModEvent.triggers) do
		ModEvent.triggers[i]:draw();
	end;
end;

local CareerScreenSaveSelectedGame = CareerScreen.saveSelectedGame;
CareerScreen.saveSelectedGame = function(self)
	CareerScreenSaveSelectedGame(self); 
	ModEvent:saveCustomInfoTriggerToXML();
end;

function ModEvent:loadCustomInfoTriggerFromXML()

	if fileExists(self.saveXMLFile) then
		local xmlFile = loadXMLFile("CustomInfoTrigger", self.saveXMLFile);
			for i=1, table.getn(ModEvent.triggers) do
				local key = ("CustomInfoTrigger."..ModEvent.triggers[i].textInfo.."");
				ModEvent.triggers[i].isEnabled = Utils.getNoNil(getXMLBool(xmlFile, key.."#visibility"),true);
				setVisibility(ModEvent.triggers[i].triggerId, ModEvent.triggers[i].isEnabled);
			end;
	end;

end;

function ModEvent:saveCustomInfoTriggerToXML()

	local existDir = io.open (self.saveXMLFile, "w");	
	if existDir == nil then
		createXMLFile("CustomInfoTrigger", self.saveXMLFile, "saveObject");
	end;
	
    local xmlFile = io.open (self.saveXMLFile, "w");
    if xmlFile ~= nil then
        xmlFile:write('<?xml version="1.0" encoding="utf-8" standalone="no" ?>\n');
		xmlFile:write('\n');
        xmlFile:write('<CustomInfoTrigger>\n');
		for i=1, table.getn(ModEvent.triggers) do
			xmlFile:write('    <'..ModEvent.triggers[i].textInfo..'  visibility="'..tostring(ModEvent.triggers[i].isEnabled)..'"/> \n');
		end;		
        xmlFile:write("</CustomInfoTrigger>");
        xmlFile:close();
    end;	

end;

addModEventListener(ModEvent);

customInfoTrigger ={};

local customInfoTrigger_mt = Class(customInfoTrigger, Object);
function customInfoTrigger.onCreate(id)
    local instance = customInfoTrigger:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(instance);
    instance:load(id);
    instance:register(true);
	table.insert(ModEvent.triggers, instance);
end;

function customInfoTrigger:new(isServer, isClient)
    local self = Object:new(isServer, isClient, customInfoTrigger_mt);
    self.className = "customInfoTrigger";
    return self;
end;

function customInfoTrigger:load(id)

	self.triggerId = id;
	addTrigger(id, "triggerCallback", self);
	
	self.infoSymbol = getChildAt(id, 0);		
	local x, y, z = getTranslation(self.infoSymbol);
	self.posY = y;
	self.jump = 0;
	
	self.isEnabled = true;
 	self.textInfo = getUserAttribute(id, "InfoField");
	self.titleInfo = getUserAttribute(id, "Title");
	self.victorySymbol = Utils.getNoNil(getUserAttribute(id, "Victory"), false);	--boolean

end;

function customInfoTrigger:delete()
	removeTrigger(self.triggerId);
end;

function customInfoTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	if onEnter and self.isEnabled then 
		if (g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode) or (g_currentMission.controlledVehicle ~= nil and otherId == g_currentMission.controlledVehicle.components[1].node) then
			g_currentMission.inGameMessage:showMessage((self.titleInfo), g_i18n:getText(self.textInfo), 0, self.victorySymbol);
			setVisibility(self.triggerId, false);
			self.isEnabled = false;
		end;
	end;
end;

function customInfoTrigger:update(dt)

	if self.isEnabled then
		rotate(self.infoSymbol, 0, 0.0018 * dt, 0);		
		self.jump = self.jump - 0 * dt;
		local x, y, z = getTranslation(self.infoSymbol);
		setTranslation(self.infoSymbol, x, y + self.jump, z);
		
		if y + self.jump <= self.posY then
		self.jump = 0;
		end;
	end;

end;


g_onCreateUtil.addOnCreateFunction("customInfoTriggerOnCreate", customInfoTrigger.onCreate);