--
-- Strassensperre.lua
--
-- @Author: Alex2009(www.Alex2009.de)
--

function onCreateStrassensperre(self,id)
	local instance = Strassensperre:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(instance);
    instance:load(id);
    instance:register(true);
end;

Strassensperre = {}
local Strassensperre_mt = Class(Strassensperre, Object);

function Strassensperre:new(isServer, isClient)
    local self = Object:new(isServer, isClient, Strassensperre_mt);
    self.className = "Strassensperre";
    return self;
end;

function Strassensperre:load(id)  
    self.object = id;
    self.nightOnly = Utils.getNoNil(getUserAttribute(id, "nightOnly"),false);
    self.flash = Utils.getNoNil(getUserAttribute(id, "flash"),false);
    self.dtTime = 0;
end;

function Strassensperre:update(dt)
    if self.flash then
        if self.nightOnly then
            if not g_currentMission.environment.isSunOn then
                self.dtTime = self.dtTime + dt;
                if self.dtTime > 1500 then
                    self.dtTime = 0;
                    setVisibility(self.object,not getVisibility(self.object));
                end;
            else
                setVisibility(self.object,false);
            end;
        else
            self.dtTime = self.dtTime + dt;
            if self.dtTime > 1500 then
                self.dtTime = 0;
                setVisibility(self.object,not getVisibility(self.object));
            end;
        end;
    else
        if self.nightOnly then
            if g_currentMission.environment.isSunOn then
                setVisibility(self.object,false);
            else
                setVisibility(self.object,true);
            end;
        else
            setVisibility(self.object,true);
        end;
    end;
end;

function Strassensperre:delete()
end;