-- by "Marhu" 
-- v 1.0.1
-- Date: 02.07.2013
-- MSG text einblendungen

LiveTicker = {};
LiveTicker.version = 10001;

function LiveTicker:loadMap(name)
	if g_currentMission.LiveTicker == nil or g_currentMission.LiveTicker.version < self.version then
		g_currentMission.LiveTicker = {}
		g_currentMission.LiveTicker.version = self.version
		g_currentMission.LiveTicker.Add = function(sender,text) self:Add(sender,text); end;
	end;
	self.textH = 0.02;
	self.MSG = {}
	self.overlay = createImageOverlay("dataS2/menu/white.png");
	self.sample = createSample("NewMSGSound");
    loadSample(self.sample,  Utils.getFilename("$data/maps/sounds/pdaBeep.wav", self.baseDirectory), false);
end;
function LiveTicker:deleteMap()
end;
function LiveTicker:mouseEvent(posX, posY, isDown, isUp, button)
end;
function LiveTicker:keyEvent(unicode, sym, modifier, isDown)
end;
function LiveTicker:update(dt)
	for k,v in pairs(self.MSG) do
		if v.pos + v.width <= 0 then
			table.remove(self.MSG,k);
		end;
	end;
	for i = 1, table.getn(self.MSG) do
		self.MSG[i].pos = self.MSG[i].pos - (dt / 20000)
	end
end;
function LiveTicker:draw()
	if table.getn(self.MSG) > 0 then
		setOverlayColor(self.overlay, 0,0,0,0.4);
		renderOverlay(self.overlay, 0, 1-self.textH, 1, self.textH);
		for i = 1, table.getn(self.MSG) do
			renderText(self.MSG[i].pos, 1-self.textH, self.textH, self.MSG[i].text);
		end
		if not self.SoundPlay then
			self.SoundPlay = true;
			playSample(self.sample, 1, 1, 0);
		end
	else
		self.SoundPlay = nil;
	end;
end;

function LiveTicker:Add(sender,text)
	
	local pos = 1
	local num = table.getn(self.MSG)
	if num > 0 then
		pos = self.MSG[num].pos + self.MSG[num].width;
		if pos < 1 then
			local t = {}
			t.text = " +++ "
			t.width = getTextWidth(self.textH ,tostring(t.text));
			if pos + (t.width * 2) < 1 then
				t.pos = 1
				pos = t.pos + t.width
				table.insert(self.MSG,t)
			else
				pos = 1;
			end;
		end;
	else
		local t = {}
		t.text = " +++ "
		t.pos = pos
		t.width = getTextWidth(self.textH ,tostring(t.text));
		table.insert(self.MSG,t)
		pos = self.MSG[1].pos + self.MSG[1].width
	end
		
	local t = {}
	t.text = text
	t.pos = pos
	t.width = getTextWidth(self.textH ,tostring(t.text));
	table.insert(self.MSG,t)
	
	num = table.getn(self.MSG)
	pos = self.MSG[num].pos + self.MSG[num].width
	local t = {}
	t.text = " +++ "
	t.pos = pos
	t.width = getTextWidth(self.textH ,tostring(t.text));
	table.insert(self.MSG,t)
	
end;

addModEventListener(LiveTicker);

