--
-- CutterParticle
-- This is the CutterParticle
--
-- M@D Author  Mr. F
-- M@D date 02.09.2009
--
-- > Copyright (C) Mr. F - www.planet-ls.de < --

-- Fix: Es wird kein PS mehr erzeugt wenn das Schneidwerk angehoben und eingeschaltet ist.

-- Fefixta am 23.08.2013 by Ifko[nator]

CutterParticle = {};

function CutterParticle.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function CutterParticle:load(xmlFile)


	self.cutterParticleSystems = {};
	local numparticleAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.particleAreas#count"), 0);
    self.particleAreas = {};   
	for i=1, numparticleAreas do
        local key = string.format("vehicle.cutterParticleSystem.cutterParticleSystem(%d)", i-1);
		local currentPS = {};
		local particleNode = Utils.loadStaticParticleSystem(xmlFile, currentPS, key, self.components, false, nil, self.baseDirectory);
		table.insert(self.cutterParticleSystems, currentPS);
        self.particleAreas[i] = {};
        local areanamei = string.format("vehicle.particleAreas.particleArea%d", i);
        self.particleAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.particleAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.particleAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;
	

end;

function CutterParticle:delete()

	for i=1, table.getn(self.cutterParticleSystems) do
		Utils.deleteParticleSystem(self.cutterParticleSystems[i]);
	end;
	
end;

function CutterParticle:mouseEvent(posX, posY, isDown, isUp, button)
end;

function CutterParticle:keyEvent(unicode, sym, modifier, isDown)
end;

function CutterParticle:update(dt)

	if self:getIsActive() then
		
		if self.movingDirection < 0 and self.reelStarted and self.attacherVehicle.allowsThreshing then
			for k,area in pairs(self.particleAreas) do
				local x,y,z = getWorldTranslation(area.start);
				local x1,y1,z1 = getWorldTranslation(area.width);
				local x2,y2,z2 = getWorldTranslation(area.height);   
				local area = Utils.getFruitArea(FruitUtil.FRUITTYPE_MAIZE, x, z, x1, z1, x2, z2);
				
				if area > 0 then	 

					Utils.setEmittingState(self.cutterParticleSystems[k], true);
				else
					Utils.setEmittingState(self.cutterParticleSystems[k], false);
				end;
			end;
		else
		
			for k,area in pairs(self.cutterParticleSystems) do
				Utils.setEmittingState(self.cutterParticleSystems[k], false);
			end;
		
		end;
		
	end;
	
	
end;

function CutterParticle:updateTick(dt)

    --if self:getIsActive() then
        --if self.foldMoveDirection > 0.1 or (self.foldMoveDirection == 0 and self.foldAnimTime > 0.5) then
           --self.attacherVehicle.attacherJoints[1].moveDown = true;
        --end;
	--end;
	
end;

function CutterParticle:draw()
end;

function CutterParticle:onDetach()
    CutterParticle.onDeactivate(self);
end;

function CutterParticle:onLeave()
	CutterParticle.onDeactivate(self);
end;

function CutterParticle:onDeactivate()
    for k,area in pairs(self.cutterParticleSystems) do
		Utils.setEmittingState(self.cutterParticleSystems[k], false);
	end;
end;


Utils.loadStaticParticleSystem = function(xmlFile, psTable, baseString, linkNode, defaultEmittingState, filename, baseDirectory)
	--
	-- Static Particle System
	--
	-- Author:  Heady | www.planet-ls.de
	-- Date: 30.04.2011
	--
	--
	
	local defaultLinkNode = linkNode;
		if type(linkNode) == "table" then
			defaultLinkNode = linkNode[1].node;
		end;
	local linkNode = Utils.getNoNil(Utils.indexToObject(linkNode, getXMLString(xmlFile, baseString .. "#node")), defaultLinkNode);

	local psFile = getXMLString(xmlFile, baseString .. "#file");
	if psFile == nil then
		psFile = filename;
	end;
	if psFile == nil then
		return;
	end;
	psFile = Utils.getFilename(psFile, baseDirectory);  
	local rootNode = loadI3DFile(psFile);
	if rootNode == 0 then
		print("Error: failed to load particle system " .. psFile);
		return;
	end	
	
	link(linkNode, rootNode)	

	local posString = getXMLString(xmlFile, baseString .. "#position");
	if posString ~= nil then
		local posX, posY, posZ = Utils.getVectorFromString(posString);
		setTranslation(rootNode, posX, posY, posZ);
	end;	
	local rotString = getXMLString(xmlFile, baseString .. "#rotation");
	if rotString ~= nil then
		local rotX, rotY, rotZ = Utils.getVectorFromString(rotString);
		rotX = Utils.degToRad(rotX);
		rotY = Utils.degToRad(rotY);
		rotZ = Utils.degToRad(rotZ);
		setRotation(rootNode, rotX, rotY, rotZ);
	end;

	--for i = getNumOfChildren(rootNode) - 1, 0, -1 do
	for i=1, getNumOfChildren(rootNode) do
		local child = getChildAt(rootNode, i-1);
		if getClassName(child) == "Shape" then
			local geometry = getGeometry(child);
			if geometry ~= 0 and getClassName(geometry) == "ParticleSystem" then
				table.insert(psTable, {geometry = geometry, shape = child});
				if defaultEmittingState ~= nil then
					setEmittingState(geometry, defaultEmittingState);
				end;
			end;
		end;
	end;

	return rootNode;
end;