-- ##########################################
-- #	Balloon Wheels						#
-- #	version: 1.1						#
-- #	Date: 23.12.2012					#
-- #	author: [FSM]Webby					#
-- #	hp: fieldstar.forumprofi.de			#
-- #										#
-- # 	Keine Vernderung ohne				# 
-- # 	meine Erlaubnis!					#
-- # 	No modification without				# 
-- # 	my permission!						#
-- #										#
-- #	history:							#
-- #	v1.0	Project started				#
-- #	v1.1	support for all wheels		#
-- #			saving wheel status			#
-- #			set values in XML			#
-- #										#
-- ########################################## 	

balloonWheels = {};

function balloonWheels.prerequisitesPresent(specializations)
	print("BalloonWheels v1.1 by [FSM]Webby loaded!");
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function balloonWheels:load(xmlFile)
	self.wheelToBalloonRearLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.balloonWheels.wheelToBalloonRearLeft#index"));
	self.wheelToBalloonRearRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.balloonWheels.wheelToBalloonRearRight#index"));
	self.wheelToBalloonFrontLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.balloonWheels.wheelToBalloonFrontLeft#index"));
	self.wheelToBalloonFrontRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.balloonWheels.wheelToBalloonFrontRight#index"));
	
	self.bwRLX, self.bwRLY, self.bwRLZ = getScale(self.wheelToBalloonRearLeft);
	self.bwRRX, self.bwRRY, self.bwRRZ = getScale(self.wheelToBalloonRearRight);
	self.bwFLX, self.bwFLY, self.bwFLZ = getScale(self.wheelToBalloonFrontLeft);
	self.bwFRX, self.bwFRY, self.bwFRZ = getScale(self.wheelToBalloonFrontRight);
	
	self.bwTRLX, self.bwTRLY, self.bwTRLZ = getTranslation(self.wheelToBalloonRearLeft);
	self.bwTRRX, self.bwTRRY, self.bwTRRZ = getTranslation(self.wheelToBalloonRearRight);
	self.bwTFLX, self.bwTFLY, self.bwTFLZ = getTranslation(self.wheelToBalloonFrontLeft);
	self.bwTFRX, self.bwTFRY, self.bwTFRZ = getTranslation(self.wheelToBalloonFrontRight);
	
	self.balloonWheelsWidth = getXMLFloat(xmlFile, "vehicle.balloonWheels#wheelWidth");
	self.balloonWheelsAxleDiv = getXMLFloat(xmlFile, "vehicle.balloonWheels#axleDiv");
	self.balloonWheelsState = false;
end;

function balloonWheels:delete()
end;

function balloonWheels:mouseEvent(posX, posY, isDown, isUp, button)
end;

function balloonWheels:keyEvent(unicode, sym, modifier, isDown)
end;

function balloonWheels:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.BALLOONWHEELS) then
			self.balloonWheelsState = not self.balloonWheelsState;
		end;
		
		if self.balloonWheelsState == true then
			setScale(self.wheelToBalloonRearLeft, (self.bwRLX / 100) + self.balloonWheelsWidth, self.bwRLY ,self.bwRLZ);
			setScale(self.wheelToBalloonRearRight, (self.bwRRX / 100) + self.balloonWheelsWidth, self.bwRRY ,self.bwRRZ);
			setScale(self.wheelToBalloonFrontLeft, (self.bwFLX / 100) + self.balloonWheelsWidth, self.bwFLY ,self.bwFLZ);
			setScale(self.wheelToBalloonFrontRight, (self.bwFRX / 100) + self.balloonWheelsWidth, self.bwFRY ,self.bwFRZ);
			
			setTranslation(self.wheelToBalloonRearLeft, self.bwTRLX + self.balloonWheelsAxleDiv, self.bwTRLY, self.bwTRLZ);
			setTranslation(self.wheelToBalloonRearRight, self.bwTRRX - self.balloonWheelsAxleDiv, self.bwTRRY, self.bwTRRZ);
			setTranslation(self.wheelToBalloonFrontLeft, self.bwTFLX + self.balloonWheelsAxleDiv, self.bwTFLY, self.bwTFLZ);
			setTranslation(self.wheelToBalloonFrontRight, self.bwTFRX - self.balloonWheelsAxleDiv, self.bwTFRY, self.bwTFRZ);
			
		elseif self.balloonWheelsState == false then
			setScale(self.wheelToBalloonRearLeft, self.bwRLX, self.bwRLY ,self.bwRLZ);
			setScale(self.wheelToBalloonRearRight, self.bwRRX, self.bwRRY ,self.bwRRZ);
			setScale(self.wheelToBalloonFrontLeft, self.bwFLX, self.bwFLY ,self.bwFLZ);
			setScale(self.wheelToBalloonFrontRight, self.bwFRX, self.bwFRY ,self.bwFRZ);
			
			setTranslation(self.wheelToBalloonRearLeft, self.bwTRLX, self.bwTRLY, self.bwTRLZ);
			setTranslation(self.wheelToBalloonRearRight, self.bwTRRX, self.bwTRRY, self.bwTRRZ);
			setTranslation(self.wheelToBalloonFrontLeft, self.bwTFLX, self.bwTFLY, self.bwTFLZ);
			setTranslation(self.wheelToBalloonFrontRight, self.bwTFRX, self.bwTFRY, self.bwTFRZ);
			
		end;
	end;
end;

function balloonWheels:draw()
	if self.balloonWheelsState then
		g_currentMission:addHelpButtonText(g_i18n:getText("BALLOONOFF"), InputBinding.BALLOONWHEELS);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("BALLOONON"), InputBinding.BALLOONWHEELS);
	end;
end;

 function balloonWheels:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local balloonWheelsState = getXMLBool(xmlFile, key.."#balloonWheelsState");		
	if balloonWheelsState ~= nil then
		self.balloonWheelsState = balloonWheelsState;
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function balloonWheels:getSaveAttributesAndNodes(nodeIdent)
	local attributes = ""
	if self.balloonWheelsState ~= nil then
		attributes = ' balloonWheelsState="'.. tostring(self.balloonWheelsState) ..'"';
	end;
    return attributes, nil;
end; 

function balloonWheels:onLeave()
end;
