--
-- Change DriveDirection
--
-- You can change the DriveDirection inGame!
-- @author  FIAT80-90DT 
-- @date  26/02/2011
-- Version [1.1]            
--		1	- ChangeDirection per Keyactivation
--		1.1	-added start direction (forward/backward)
--		1.2	-save the actually direction and take it on the next start!
-- Copyright (C), All Rights Reserved.  DO NOT EDIT WITHOUT OUR PERMISSION!!

ChangeDriveDirection = {};

function ChangeDriveDirection.prerequisitesPresent(specializations)
    return true;
end;

function ChangeDriveDirection:load(xmlFile)
	self.isBackwardRotate = false;
	self.accelerationDirection = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.AccelerationDirection#start"), 1);
end;

function ChangeDriveDirection:delete()
end;

function ChangeDriveDirection:readStream(streamId, connection)	
end;

function ChangeDriveDirection:writeStream(streamId, connection)
end;

function ChangeDriveDirection:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ChangeDriveDirection:keyEvent(unicode, sym, modifier, isDown)
end;

function ChangeDriveDirection:getSaveAttributesAndNodes(nodeIdent)
	local attributes
	attributes = 'accelerationDirection="'..self.accelerationDirection..'" '
	return attributes
end;

function ChangeDriveDirection:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local lastAccelerationDirection = getXMLFloat(xmlFile, key.."#accelerationDirection");
	if not resetVehicles then	
		if lastAccelerationDirection ~= nil then
			self.accelerationDirection = lastAccelerationDirection;			
		end;		
		if lastAccelerationDirection == nil then
			self.accelerationDirection = self.accelerationDirection;			
		end;
	end;
end

function ChangeDriveDirection:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.XERION_CAB_ROTATION) then
			self.accelerationDirection = self.accelerationDirection*-1;
		end;
	end;
end;

function ChangeDriveDirection:updateTick(dt)
end;

function ChangeDriveDirection:draw()
	g_currentMission:addHelpButtonText(("Fahrtrichtung umkehren"), InputBinding.XERION_CAB_ROTATION);
end;