FasterProductions = {}
function FasterProductions:load(success, components, xmlFile, key, customEnv, i3dMappings)
    if success then
        local multiplier = 1000

        for _, production in ipairs(self.productions) do
            if production.outputs[1] ~= nil then
                -- Zyklen unverändert lassen
                -- production.cyclesPerHour = production.cyclesPerHour

                -- Input- und Output-Mengen hochsetzen
                for _, input in pairs(production.inputs) do
                    input.amount = input.amount * multiplier
                end

                for _, output in pairs(production.outputs) do
                    output.amount = output.amount * multiplier
                end

                printf("Boosted %s by x%d (cyclesPerHour=%d)", production.name, multiplier, production.cyclesPerHour)
            end
        end
    end
    return success
end

local function appendedFunction(oldFunc, newFunc)
	if oldFunc ~= nil then
		return function (self, ...)
			retValue = oldFunc(self, ...)
			return newFunc(self, retValue, ...)
		end
	else
		return newFunc
	end
end

ProductionPoint.load = appendedFunction(ProductionPoint.load, FasterProductions.load)

