-- Author:Raptor5
-- Name:R5TerrainUtils
-- Description: Terrain-Function-Collection
-- Icon:
-- Hide: yes
-- Version: 1.0.1

R5TerrainUtils = {}

-- GENERAL
------------------------------------------------------------------

source("editorUtils.lua")

--[[ Modified setTerrainHeight Version, for custom Terrain resolutions
-- params:	
	mHeightOffset:	heightoffset from spline
	mSideCount:		half-width in m
    terrainRes:     terrain-resolution (meters per pixel on heightmap)
-- return:
    void
]]
function R5TerrainUtils.setTerrainHeight( mHeightOffset, mSideCount, terrainRes )

    local mSceneID = getChildAt(getRootNode(), 0)
    local mTerrainID = 0

    for i = 0, getNumOfChildren(mSceneID) - 1 do
        local mID = getChildAt(mSceneID, i)
        if (getName(mID) == "terrain") then
            mTerrainID = mID
            break
        end
    end

    if (mTerrainID == 0) then
        print("Error: Terrain node not found. Node needs to be named 'terrain'.")
        return nil
    end

    if (getNumSelected() == 0) then
        print("Error: Select one or more splines.")
        return nil
    end

    local mSplineIDs = {}
    for i = 0, getNumSelected() - 1 do
        mID = getSelection( i )
        table.insert( mSplineIDs, mID )
    end

    for _, mSplineID in pairs(mSplineIDs) do
        local mSplineLength = getSplineLength( mSplineID ) 
        -- Rmod:
        local mSplinePiece = 0.5 * terrainRes -- real size in m based on terrain Resolution
        local mSplinePiecePoint = mSplinePiece / mSplineLength  -- relative size [0..1]

        local mSplinePos = 0.0
        while mSplinePos <= 1.0 do
            -- get XYZ at position on spline
            local mPosX, mPosY, mPosZ = getSplinePosition( mSplineID, mSplinePos )
            -- define height value
            local mHeight = mPosY + mHeightOffset
            -- directional vector at the point
            local mDirX, mDirY,   mDirZ   = worldDirectionToLocal( mSplineID, getSplineDirection ( mSplineID, mSplinePos) )
            local mVecDx, mVecDy, mVecDz = EditorUtils.crossProduct( mDirX, mDirY, mDirZ, 0, 1, 0)
            -- set HEIGHT at the center
            setTerrainHeightAtWorldPos( mTerrainID, mPosX, mPosY, mPosZ, mHeight )
            -- define side to side shift in meters
            -- local mSideCount = 10
            -- Rmod: distance based on terrainRes
            local rdist = 0.5 * terrainRes
            
            for i = rdist, mSideCount, rdist do
             local mNewPosX1 = mPosX + i * mVecDx
             local mNewPosY1 = mPosY + i * mVecDy
             local mNewPosZ1 = mPosZ + i * mVecDz
             local mNewPosX2 = mPosX  - i * mVecDx
             local mNewPosY2 = mPosY  - i * mVecDy
             local mNewPosZ2 = mPosZ  - i * mVecDz
            -- set HEIGHT aon the left and right side from the center
            setTerrainHeightAtWorldPos( mTerrainID, mNewPosX1, mNewPosY1, mNewPosZ1, mHeight )
            setTerrainHeightAtWorldPos( mTerrainID, mNewPosX2, mNewPosY2, mNewPosZ2, mHeight )
            end
            -- goto next point
            mSplinePos = mSplinePos + mSplinePiecePoint
        end
    end
end


--[[ Modified paintTerrainBySpline Version, for custom Terrain resolutions
-- params:	
	mLayerId:	    layerID
	mSideCount:		half-width in m
    terrainRes:     terrain-resolution (meters per pixel on heightmap)
-- return:
    void
]]
-- INFO:
-- Texture Layerpainting First Layer (Not Group) = Layer ID1
function R5TerrainUtils.paintTerrainBySpline( mLayerId, mSideCount, terrainRes )
-- paintTerrainBySpline ( take x,z value from spline every 1 meter and paint selected texture on the terrain)


    local mSceneID = getChildAt(getRootNode(), 0)
    local mTerrainID = 0

    for i = 0, getNumOfChildren(mSceneID) - 1 do
        local mID = getChildAt(mSceneID, i)
        if (getName(mID) == "terrain") then
            mTerrainID = mID
            break
        end
    end

    if (mTerrainID == 0) then
        print("Error: Terrain node not found. Node needs to be named 'terrain'.")
        return nil
    end

    if (getNumSelected() == 0) then
        print("Error: Select one or more splines.")
        return nil
    end

    local mSplineIDs = {}
    for i = 0, getNumSelected() - 1 do
        mID = getSelection( i )
        table.insert( mSplineIDs, mID )
    end

    for _, mSplineID in pairs(mSplineIDs) do
        local mSplineLength = getSplineLength( mSplineID ) 
        -- Rmod:
        local mSplinePiece = 0.25 * terrainRes -- real size in m based on terrain Resolution
        local mSplinePiecePoint = mSplinePiece / mSplineLength  -- relative size [0..1]

        local mSplinePos = 0.0
        while mSplinePos <= 1.0 do
            -- get XYZ at position on spline
            local mPosX, mPosY, mPosZ = getSplinePosition( mSplineID, mSplinePos )
            -- directional vector at the point
            local mDirX, mDirY,   mDirZ   = worldDirectionToLocal( mSplineID, getSplineDirection ( mSplineID, mSplinePos) )
            local mVecDx, mVecDy, mVecDz = EditorUtils.crossProduct( mDirX, mDirY, mDirZ, 0, 1, 0)
            -- paint at the center
            setTerrainLayerAtWorldPos(mTerrainID, mLayerId, mPosX, mPosY, mPosZ, 128.0 )
            -- define side to side shift in meters
            -- Rmod: distance based on terrainRes
            local rdist = 0.5 * terrainRes
            
            for i = rdist, mSideCount, rdist do
                local mNewPosX1 = mPosX + i * mVecDx
                local mNewPosZ1 = mPosZ + i * mVecDz
                local mNewPosX2 = mPosX  - i * mVecDx
                local mNewPosZ2 = mPosZ  - i * mVecDz
                -- paint at the center
                setTerrainLayerAtWorldPos(mTerrainID, mLayerId, mNewPosX1, mPosY, mNewPosZ1, 128.0 )
                setTerrainLayerAtWorldPos(mTerrainID, mLayerId, mNewPosX2, mPosY, mNewPosZ2, 128.0 )
            end
            -- goto next point
            mSplinePos = mSplinePos + mSplinePiecePoint
        end
    end
end

--[[			CHANGELOG
===================================================
V 1.0.1:
*	added editorUtils reference 
]]