--[[
Script to change the mod title in the mod view

Author:		Ifko[nator]
Date:		07.08.2019
Version:	2.0

History:	V 1.0 @ 11.05.2018 - initial release in FS 17
			V 2.0 @ 07.08.2019 - initial release in FS 19

<changeModTitle modTitle="_modTitle_"/>
]]

ChangeModTitle = {};

ChangeModTitle.modDirectory = g_currentModDirectory;
ChangeModTitle.currentModName = g_currentModName;

local function changeModTitle()
	local modDesc = loadXMLFile("modDesc", ChangeModTitle.modDirectory .. "modDesc.xml");
	local modTitle = Utils.getNoNil(getXMLString(modDesc, "modDesc.changeModTitle#modTitle"), "");

	if modTitle == "" then
		for _, mods in pairs(g_modManager.mods) do
			for modTypeName, modDescFilename in pairs(mods) do
				if tostring(modTypeName) == "modFile" and mods.modName == ChangeModTitle.currentModName then
					local modDesc = loadXMLFile("modDesc", modDescFilename);
					local title = getXMLString(modDesc, "modDesc.title." .. g_languageShort);
	
					if title == nil then
						title = getXMLString(modDesc, "modDesc.title.en");
	
						if title == nil then
							title = getXMLString(modDesc, "modDesc.title");

							if title == nil then
								title = mods.modName;
							end;
						end;
					end;
					
					modTitle = title;
				end;
			end;
		end;
	elseif string.sub(modTitle, 1, 6) == "$l10n_" then
		modTitle = g_i18n:getText(string.sub(modTitle, 7));
	elseif g_i18n:hasText(modTitle) then
		modTitle = g_i18n:getText(modTitle);
	end;

	for _, storeItem in pairs(g_storeManager.modStoreItems) do
		if storeItem.customEnvironment == ChangeModTitle.currentModName then	
			storeItem.isMod = false;
			
			storeItem.dlcTitle = modTitle;
		end;
	end;

	delete(modDesc);
end;

Vehicle.init = Utils.appendedFunction(Vehicle.init, changeModTitle);