-- cylinders
-- Spezi f�r einfache Hydraulikcylinders oder cylinders aller Arten
-- Ebenfalls sind einfache setDirections m�glich

-- V2 Rotations die von einem Objekt ausgehend die Bewegung auf ein anderes �bertragen sind nun auch m�glich.
-- Damit kann man nun die komplette Animation einer Lenkung oder einer Heckhydraulik hier�ber laufen lassen!

-- by modelleicher


cylinderedV3 = {};

function cylinderedV3.prerequisitesPresent(specializations)
    return true;
end;


function cylinderedV3.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", cylinderedV3);
	SpecializationUtil.registerEventListener(vehicleType, "onUpdate", cylinderedV3);
end;

function cylinderedV3.initSpecialization()
	print("init")
	local schema = Vehicle.xmlSchema

	schema:setXMLSpecializationType("cylinderedV3")
	cylinderedV3.registerCylinderedV3XMLPaths(schema, "vehicle.cylinderedV3")

	schema:setXMLSpecializationType()
end

function cylinderedV3.registerCylinderedV3XMLPaths(schema, basePath)

	print("reg path")

	-- cylinder shema
	schema:register(XMLValueType.NODE_INDEX, basePath .. ".cylinders.cylinder(?)#dir1", "Cylinder Direction Node 1")
	schema:register(XMLValueType.NODE_INDEX, basePath .. ".cylinders.cylinder(?)#dir2", "Cylinder Direction Node 2")
	
	-- rotations shema
	schema:register(XMLValueType.NODE_INDEX, basePath .. ".rotations.rotation(?)#node", "Rotations Action Node")
	schema:register(XMLValueType.NODE_INDEX, basePath .. ".rotations.rotation(?)#ref", "Rotations Reference Node")
	schema:register(XMLValueType.FLOAT, basePath .. ".rotations.rotation(?)#addDegrees", "Amount of Degrees added", 0.0)
	schema:register(XMLValueType.STRING, basePath .. ".rotations.rotation(?)#rotAxis", "Axis of Rotation", "x")
	schema:register(XMLValueType.STRING, basePath .. ".rotations.rotation(?)#getRotAxis", "Axis of Rotation on Reference Node", "y")
	schema:register(XMLValueType.FLOAT, basePath .. ".rotations.rotation(?)#lengthMultiplicator", "Multiplicator", 1.0)
	
	-- directions shema 
	schema:register(XMLValueType.NODE_INDEX, basePath .. ".directions.direction(?)#node", "Directions Action Node")	
	schema:register(XMLValueType.NODE_INDEX, basePath .. ".directions.direction(?)#ref", "Directions Reference Node")	
	schema:register(XMLValueType.NODE_INDEX, basePath .. ".directions.direction(?)#scaleRef", "Directions Scale Reference Node")	
	schema:register(XMLValueType.BOOL, basePath .. ".directions.direction(?)#doScaleBool", "Scale active")	
	
	-- scaleOnlys shema 
	schema:register(XMLValueType.NODE_INDEX, basePath .. ".scaleOnlys.scaleOnly(?)#node", "ScaleOnly Action Node")	
	schema:register(XMLValueType.NODE_INDEX, basePath .. ".scaleOnlys.scaleOnly(?)#ref", "ScaleOnly Reference Node")			
end

function cylinderedV3:onLoad(savegame)
	self.updateCylinderedV3 = cylinderedV3.updateCylinderedV3;
	
	self.spec_cylinderedV3 = {};  -- creating the table where all the variables are stored in
	local spec = self.spec_cylinderedV3; 

	local xmlFile = self.xmlFile;
	
	local path = "vehicle.cylinderedV3.";
	
	 	--spec.leftMarker = self.xmlFile:getValue(baseName .. ".areaMarkers#leftNode", nil, self.components, self.i3dMappings)
		
	spec.cylinders = {};
	local i = 0;
	while true do
		local cyl = {};
		cyl.dir1 = self.xmlFile:getValue(path.."cylinders.cylinder("..i..")#dir1", nil, self.components, self.i3dMappings);
		cyl.dir2 = self.xmlFile:getValue(path.."cylinders.cylinder("..i..")#dir2", nil, self.components, self.i3dMappings);
		if cyl.dir1 ~= nil and cyl.dir2 ~= nil then
			
			-- get the rotation axis for upVector 

			-- get translation of cylinder first
			local x, y, z = getTranslation(cyl.dir1);
			-- add 0.5 to X axis to create axis direction vector 
			x = x + 0.5;
			-- now save this position relative to the parent of cylinder
			local pX, pY, pZ = localToLocal(getParent(cyl.dir1), cyl.dir1, x, y, z);

			-- now we have our incredients for the vector calculation
			cyl.upVector1 = {pX = pX, pY = pY, pZ = pZ}

			-- same for other cyl
			-- get translation of cylinder first
			local x2, y2, z2 = getTranslation(cyl.dir2);
			-- add 0.5 to X axis to create axis direction vector 
			x2 = x2 + 0.5;
			-- now save this position relative to the parent of cylinder
			local pX2, pY2, pZ2 = localToLocal(getParent(cyl.dir2), cyl.dir2, x2, y2, z2);

			-- now we have our incredients for the vector calculation
			cyl.upVector2 = {pX = pX2, pY = pY2, pZ = pZ2}			

		
			table.insert(spec.cylinders, cyl);
		else
			break;
		end;
		i = i+1;
	end;
		
    spec.rotations = {};
	i = 0;
	while true do	
		local rot = {};
		local path1 = path.."rotations.rotation("..i..")"
		rot.index = self.xmlFile:getValue(path1.."#node", nil, self.components, self.i3dMappings);
		if rot.index == nil or rot.index == "" then
			break;
		end;		
		rot.ref = self.xmlFile:getValue(path1.."#ref", nil, self.components, self.i3dMappings);     
		rot.addDegrees = self.xmlFile:getValue(path1.."#addDegrees", 0.0);
		
		rot.rotAxis = string.lower(self.xmlFile:getValue(path1.."#rotAxis", "x"));
		rot.getRotAxis = string.lower(self.xmlFile:getValue(path1.."#getRotAxis", "y"));
		rot.lengthMultiplicator = self.xmlFile:getValue(path1.."#lengthMultiplicator", 1.0);	
		table.insert(spec.rotations, rot);
		i = i+1;
	end;

        
		
    spec.directions = {};
	i = 0;
	while true do	
		local dir = {};
		local path1 = path.."directions.direction("..i..")"
		dir.index = self.xmlFile:getValue(path1.."#node", nil, self.components, self.i3dMappings);
		if dir.index == nil or dir.index == "" then
			break;
		end;		
		dir.ref = self.xmlFile:getValue(path1.."#ref", nil, self.components, self.i3dMappings);
		dir.doScaleBool = self.xmlFile:getValue(path1.."#doScaleBool", false);
		if dir.doScaleBool == true then
			dir.scaleRef = self.xmlFile:getValue(path1.."#scaleRef", nil, self.components, self.i3dMappings);            
			local ax, ay, az = getWorldTranslation(dir.index);
			local bx, by, bz = getWorldTranslation(dir.scaleRef);
			dir.scaleDistance = MathUtil.vector3Length(ax-bx, ay-by, az-bz);    
		end;
		table.insert(spec.directions, dir);
		i = i+1;
    end;
	
	spec.scaleOnlys = {};
	i = 0;
	while true do
		local scaleOnly = {};
		local path1 = path.."scaleOnlys.scaleOnly("..i..")"	
		scaleOnly.index = self.xmlFile:getValue(path1.."#node", nil, self.components, self.i3dMappings);
		scaleOnly.ref = self.xmlFile:getValue(path1.."#ref", nil, self.components, self.i3dMappings);
		if scaleOnly.index == nil or scaleOnly.index == "" then
			break;
		end;	
		local ax, ay, az = getWorldTranslation(scaleOnly.index);
		local bx, by, bz = getWorldTranslation(scaleOnly.ref);
		scaleOnly.scaleDistance = MathUtil.vector3Length(ax-bx, ay-by, az-bz);
		table.insert(spec.scaleOnlys, scaleOnly);
		i = i+1;		
	end;	
	
		
	self:updateCylinderedV3();
	
end;

function cylinderedV3:updateCylinderedV3()

	local spec = self.spec_cylinderedV3;

	if #spec.cylinders > 0 then
		for i=1, #spec.cylinders do
			if spec.cylinders[i].dir1 ~= nil and spec.cylinders[i].dir2 ~= nil then
			local dir1 = spec.cylinders[i].dir1;
			local dir2 = spec.cylinders[i].dir2;
			local ax, ay, az = getWorldTranslation(dir1);
			local bx, by, bz = getWorldTranslation(dir2);
			x, y, z = worldDirectionToLocal(getParent(dir1), bx-ax, by-ay, bz-az);
			
			local ux, uy, uz = localDirectionToWorld(dir1, 0,1,0)
			ux, uy, uz = worldDirectionToLocal(getParent(dir1), ux, uy, uz)

			setDirection(dir1, x, y, z, ux, uy, uz);

			local ax2, ay2, az2 = getWorldTranslation(dir2);
			local bx2, by2, bz2 = getWorldTranslation(dir1);
			x2, y2, z2 = worldDirectionToLocal(getParent(dir2), bx2-ax2, by2-ay2, bz2-az2);
			
			local ux2, uy2, uz2 = localDirectionToWorld(dir2, 0,1,0)
			ux2, uy2, uz2 = worldDirectionToLocal(getParent(dir2), ux2, uy2, uz2)		
			
			setDirection(dir2, x2, y2, z2, ux2, uy2, uz2); 
			end;
		end;
	end;
	
	
	if #spec.rotations > 0 then
		for i=1, #spec.rotations do
			--print("rotations count");
			if spec.rotations[i].index ~= nil and spec.rotations[i].ref ~= nil then
				local rx, ry, rz = getRotation(spec.rotations[i].ref);
				local rw = 0;
				if spec.rotations[i].getRotAxis == "y" then -- ask first for y because it is the most used in this case (for performance reasons)
					rw = ry*spec.rotations[i].lengthMultiplicator;
				elseif spec.rotations[i].getRotAxis == "x" then
					rw = rx*spec.rotations[i].lengthMultiplicator;
				elseif spec.rotations[i].getRotAxis == "z" then
					rw = rz*spec.rotations[i].lengthMultiplicator;
				end;
				if spec.rotations[i].rotAxis == "x" then -- ask first for x because it is the most used in this case(for performance reasons)
					setRotation(spec.rotations[i].index, rw+math.rad(spec.rotations[i].addDegrees), 0, 0);
				elseif spec.rotations[i].rotAxis == "y" then
					setRotation(spec.rotations[i].index, 0, rw+math.rad(spec.rotations[i].addDegrees), 0);
				elseif spec.rotations[i].rotAxis == "z" then
					setRotation(spec.rotations[i].index, 0, 0, rw+math.rad(spec.rotations[i].addDegrees));
				end;
			end;
		end;
	end;
	if #spec.directions > 0 then
		for i=1, #spec.directions do
			if spec.directions[i].index ~= nil and spec.directions[i].ref ~= nil then
				local ax, ay, az = getWorldTranslation(spec.directions[i].index);
				local bx, by, bz = getWorldTranslation(spec.directions[i].ref);
				x, y, z = worldDirectionToLocal(getParent(spec.directions[i].index), bx-ax, by-ay, bz-az);
				local upx, upy, upz = 0,1,0;
				if math.abs(y) > 0.99*MathUtil.vector3Length(x, y, z) then
					upy = 0;
					if y > 0 then
						upy = 1;
					else
						upy = -1;
					end;
				end;
				setDirection(spec.directions[i].index, x, y, z, upx, upy, upz);
				if spec.directions[i].doScaleBool == true and spec.directions[i].scaleRef ~= nil then
					local distance = MathUtil.vector3Length(ax-bx, ay-by, az-bz);
					local scaleX, scaleY, scaleZ = getScale(spec.directions[i].index);
					local setScaleWert = scaleZ * (distance / spec.directions[i].scaleDistance);
					setScale(spec.directions[i].index, 1, 1, setScaleWert);
				end;
			end;
		end;
	end;
	if #spec.scaleOnlys > 0 then
		for i=1, #spec.scaleOnlys do
			if spec.scaleOnlys[i].index ~= nil and spec.scaleOnlys[i].ref ~= nil then
				local ax, ay, az = getWorldTranslation(spec.scaleOnlys[i].index);
				local bx, by, bz = getWorldTranslation(spec.scaleOnlys[i].ref);
				local scaleDistance = MathUtil.vector3Length(ax-bx, ay-by, az-bz);
				setScale(spec.scaleOnlys[i].index, 1, 1/(spec.scaleOnlys[i].scaleDistance/scaleDistance), 1);
			end;
		end;
	end;	

end;

function cylinderedV3:onUpdate(dt) 
	if self:getIsActive() then
		self:updateCylinderedV3();
	end;
end;
