--
-- BaleCounter
-- Specialization for baler to display a bale counter.
--
-- @author  	Benjamin Biot (J&B Modding)
-- @version 	v1.0
-- @date  		30/11/10
--

KroneComprimaBaleCounter = {};

function KroneComprimaBaleCounter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Baler, specializations);
end;

function KroneComprimaBaleCounter:load(xmlFile)
	self.SetBaleCount= SpecializationUtil.callSpecializationsFunction("SetBaleCount");
	--  HUD --
	self.File = Utils.getFilename("Textur/Textur_V180/KroneComprimaBallenHud.png", self.baseDirectory);
	self.hudPoxX = 0.05;
    self.hudPoxY = 0.025; 
    self.hudWidth = 0.300;
    self.hudHeight = 0.200;
    self.HUDNHBB = Overlay:new("HUDNHBB", self.File, self.hudPoxX, self.hudPoxY, self.hudWidth, self.hudHeight);
    self.HUD = false;
	
	self.KroneComprimaTotalBalesCount = 0;
	self.KroneComprimaCurrentBalesCount = 0;
	self.KroneComprimaNoRopesBalesCount = 0;
end;

function KroneComprimaBaleCounter:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
   local KroneComprimaTotalBalesCount =  Utils.getNoNil(getXMLInt(xmlFile, key.."#KroneComprimaTotalBalesCount"),0);
   local KroneComprimaNoRopesBalesCount =  Utils.getNoNil(getXMLInt(xmlFile, key.."#KroneComprimaNoRopesBalesCount"),0);
   self.KroneComprimaTotalBalesCount = KroneComprimaTotalBalesCount;
   self.KroneComprimaNoRopesBalesCount = KroneComprimaNoRopesBalesCount;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function KroneComprimaBaleCounter:getSaveAttributesAndNodes(nodeIdent)
   local KroneComprimaTotalBalesCount= Utils.getNoNil(self.KroneComprimaTotalBalesCount, 0);
   local KroneComprimaNoRopesBalesCount= Utils.getNoNil(self.KroneComprimaNoRopesBalesCount, 0);
    local attributes = 'KroneComprimaTotalBalesCount="'..string.format("%.1f",KroneComprimaTotalBalesCount)..'" KroneComprimaNoRopesBalesCount="'..string.format("%.1f",KroneComprimaNoRopesBalesCount)..'"';
   return attributes, nil;
end;

function KroneComprimaBaleCounter:delete()
end;

function KroneComprimaBaleCounter:readStream(streamId, connection)
    self.KroneComprimaTotalBalesCount = streamReadInt32(streamId);
    self.KroneComprimaNoRopesBalesCount = streamReadInt32(streamId);
    self.KroneComprimaCurrentBalesCount = streamReadInt32(streamId);
end;

function KroneComprimaBaleCounter:writeStream(streamId, connection)
    streamWriteInt32(streamId, self.TotalBalesCount);
    streamWriteInt32(streamId, self.NoRopesBalesCount);
    streamWriteInt32(streamId, self.CurrentBalesCount);
end;

function KroneComprimaBaleCounter:readUpdateStream(streamId, timestamp, connection)
end;

function KroneComprimaBaleCounter:writeUpdateStream(streamId, connection, dirtyMask)
end;

function KroneComprimaBaleCounter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KroneComprimaBaleCounter:keyEvent(unicode, sym, modifier, isDown)
end;

function KroneComprimaBaleCounter:update(dt)		
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
			self.HUD = not self.HUD;
		end;
    end;
end;

function KroneComprimaBaleCounter:updateTick(dt)	
end;

function KroneComprimaBaleCounter:draw()
	setTextBold(true);
	setTextAlignment(RenderText.ALIGN_RIGHT);
	setTextColor(1, 1, 1, 1);
	if self.HUD then
		self.HUDNHBB:render();
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("HUD_OFF"), self.typeDesc), InputBinding.ACTIVATE_OBJECT);
		if self.KroneComprimaCurrentBalesCount~= nil then
			renderText(0.165, 0.157, 0.020, string.format(self.KroneComprimaCurrentBalesCount));
		end;
		if self.KroneComprimaTotalBalesCount~= nil then
			renderText(0.165, 0.086, 0.020, string.format(self.KroneComprimaTotalBalesCount));
		end;
	else
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("HUD_ON"), self.typeDesc), InputBinding.ACTIVATE_OBJECT);	
	end;
end;

function KroneComprimaBaleCounter.dropBale(self, baleIndex)
	if self.KroneComprimaCurrentBalesCount ~= nil and self.KroneComprimaTotalBalesCount ~= nil and self.KroneComprimaNoRopesBalesCount ~= nil then
		self.KroneComprimaCurrentBalesCount = self.KroneComprimaCurrentBalesCount +1;
		self.KroneComprimaTotalBalesCount = self.KroneComprimaTotalBalesCount +1;
		self.KroneComprimaNoRopesBalesCount = self.KroneComprimaNoRopesBalesCount +1;
	end;
end;

Baler.dropBale = Utils.appendedFunction(Baler.dropBale, KroneComprimaBaleCounter.dropBale);