--[[
    Author: PeterAH (Modding-Welt)
    Mod name: Adjust Working Speed
    Version: 2.0.0.0 (initial FS22)
    Date: January 2022
    Contact: https://www.modding-welt.com
    Discord: [MW] PeterAH#5807       
]]

adjustWorkingSpeed = {}

g_lastDeleteTime = 0
g_lastLoadTime = 0
g_deleteFilename = "."
g_deleteHandle = "."
g_loadFilename = "."
g_loadHandle = "."

local _modDirectory = g_currentModDirectory
local _modName = g_currentModName

function adjustWorkingSpeed.prerequisitesPresent(specializations)
    return true
end

function adjustWorkingSpeed.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onPostLoad", adjustWorkingSpeed)
    SpecializationUtil.registerEventListener(vehicleType, "onPreDelete", adjustWorkingSpeed)
	SpecializationUtil.registerEventListener(vehicleType, "saveToXMLFile", adjustWorkingSpeed)
end

function adjustWorkingSpeed:initSpecialization()
    local schemaSavegame = Vehicle.xmlSchemaSavegame
    schemaSavegame:register(XMLValueType.INT, "vehicles.vehicle(?).adjustWorkingSpeed#configurationId", "Adjust working speed configuration id", 11) -- To be on the save side because the key of "saveToXMLFile" changed since FS22 V.1.4.0.0
    schemaSavegame:register(XMLValueType.INT, "vehicles.vehicle(?)." .. _modName .. ".adjustWorkingSpeed#configurationId", "Adjust working speed configuration id", 11) -- New since FS22 V.1.4.1.0
end

function adjustWorkingSpeed:onPostLoad(savegame)
    local configurationId = Utils.getNoNil(self.configurations["adjustWorkingSpeed"], 0)
    local configurationIdOld = configurationId  -- configurationIdOld: before FS22 V.1.4.0.0

    if savegame ~= nil then
        if configurationId > 0 then
            configurationId = savegame.xmlFile:getValue(savegame.key .. "." .. _modName .. ".adjustWorkingSpeed#configurationId", configurationId)
            if configurationId < 1 or configurationId > 21 then
                configurationId = 11
            end
            configurationIdOld = savegame.xmlFile:getValue(savegame.key .. ".adjustWorkingSpeed#configurationId", configurationId)
            if configurationIdOld < 1 or configurationIdOld > 21 then
                configurationIdOld = 11
            end
            if configurationId == 11 then
                configurationId = configurationIdOld  -- for compatibility with savegame before FS22 V.1.4.0.0
            end
            self.configurations["adjustWorkingSpeed"] = configurationId
        end
    end

	g_targetSelf = nil
    local storeItem = g_storeManager:getItemByXMLFilename(self.configFileName)
    if storeItem ~= nil and storeItem.configurations ~= nil then
        if storeItem.configurations["adjustWorkingSpeed"] ~= nil then

            local numSpeedLimit
            if storeItem.awsSpeedLimit == nil then
                numSpeedLimit = 0
            elseif storeItem.awsSpeedLimit == "" then
                numSpeedLimit = 0
            else
                numSpeedLimit = Utils.getNoNil(tonumber(storeItem.awsSpeedLimit), 0)
            end
        
            if self.speedLimit ~= nil then
                if self.speedLimit > 0.5 then
                    if numSpeedLimit > 0.5 then
                        local configId = Utils.getNoNil(self.configurations["adjustWorkingSpeed"], 0)
                        if configId > 0.5 then
                            self.speedLimit = math.max(numSpeedLimit + configId - 11, 1)
                            g_targetSelf = self
                        end
                    end
                end
            end
            
        end
    end

    g_lastLoadTime = g_currentMission.time
    g_loadFilename = self.xmlFile.filename
    g_loadHandle = self.xmlFile.handle
end

function adjustWorkingSpeed:saveToXMLFile(xmlFile, key, usedModNames)
    if self.configurations ~= nil then
        if self.configurations["adjustWorkingSpeed"] ~= nil then
            xmlFile:setValue(key.."#configurationId", self.configurations["adjustWorkingSpeed"])
        end
    end
end

function adjustWorkingSpeed:onPreDelete()
    local deleteTimeGap = g_currentMission.time - g_lastDeleteTime
    local loadTimeGap = g_currentMission.time - g_lastLoadTime

    if deleteTimeGap < 130 then
        if loadTimeGap < 200 then
            if loadTimeGap > deleteTimeGap then
                if g_targetSelf ~= nil then
                    if g_deleteFilename == self.xmlFile.filename then
                        if g_loadFilename == self.xmlFile.filename then
                            if g_deleteHandle ~= self.xmlFile.handle then
                                if g_loadHandle ~= self.xmlFile.handle then
                                    if g_loadHandle ~= g_deleteHandle then
                                        g_targetSelf.configurations["adjustWorkingSpeed"] = self.configurations["adjustWorkingSpeed"]
                                        g_targetSelf.speedLimit = self.speedLimit
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end
    end

    g_lastDeleteTime = g_currentMission.time
    g_deleteFilename = self.xmlFile.filename
    g_deleteHandle = self.xmlFile.handle
end
