--[[
    Author: PeterAH (Modding-Welt)
    Mod name: Air Hose Connect Sound
    Version: 1.0.0.0
    Date: November 2021
    Contact: https://www.modding-welt.com
    Discord: [MW] PeterAH#5807
]]

airHoseConnectSound = {}

local _modDirectory = g_currentModDirectory
local _airHoseConnectVolumeSetting = 1.00

function airHoseConnectSound.prerequisitesPresent(specializations)
    return true
end

function airHoseConnectSound.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", airHoseConnectSound)
    SpecializationUtil.registerEventListener(vehicleType, "onPostLoad", airHoseConnectSound)
    SpecializationUtil.registerEventListener(vehicleType, "onPreAttach", airHoseConnectSound)
    SpecializationUtil.registerEventListener(vehicleType, "onPostAttach", airHoseConnectSound)
    SpecializationUtil.registerEventListener(vehicleType, "onDelete", airHoseConnectSound)
end

function airHoseConnectSound:onLoad(savegame)
    --print("onLoad airHoseConnectSound ===========================================================================================")	

    local modDescXMLFile = loadXMLFile("modDescXMLFile", _modDirectory .. "modDesc.xml")
    _airHoseConnectVolumeSetting = Utils.getNoNil(getXMLFloat(modDescXMLFile, "modDesc.airHoseConnectSound#volumeSetting"), 1)
    delete(modDescXMLFile)

    self.connectHose = Utils.appendedFunction(ConnectionHoses.connectHose, airHoseConnectSound.connectHose)
    self.disconnectHose = Utils.appendedFunction(ConnectionHoses.disconnectHose, airHoseConnectSound.disconnectHose)

    self.isAirDoubleYellowConnected = false
    self.playConnectSound = true
    if getfenv(0).g_manualAttach ~= nil then
        self.manualAttach = true
    else
        self.manualAttach = false
    end
end

function airHoseConnectSound:onPostLoad(savegame)

    if self.isClient then
        local baseString = "sounds"
        local xmlSoundFile
        local hasAirDoubleYellow = false

        if self.spec_connectionHoses ~= nil then
            local spec = self.spec_connectionHoses
            if type(spec.hoseNodes) == "table" then
                for i, _ in ipairs(spec.hoseNodes) do
                    if spec.hoseNodes[i].type ~= nil then
                        if spec.hoseNodes[i].type == "airDoubleYellow" then
                            hasAirDoubleYellow = true
                        end
                    end
                end                    
            end
        end

        if hasAirDoubleYellow then
            if fileExists(_modDirectory .. "sounds/airHoseConnectSound.xml") then
                xmlSoundFile = loadXMLFile("airHoseConnectSound", _modDirectory .. "sounds/airHoseConnectSound.xml")
            else
                print("Error: Script airHoseConnectSound.lua: XML-File not found: " .. _modDirectory .. "sounds/airHoseConnectSound.xml")
            end
        end
        
        if xmlSoundFile ~= nil then
            local soundNode
            if self.spec_attachable.inputAttacherJoints ~= nil then
                if self.spec_attachable.inputAttacherJoints[1] ~= nil then
                    if self.spec_attachable.inputAttacherJoints[1].node ~= nil then
                        soundNode = self.spec_attachable.inputAttacherJoints[1].node
                    end
                end
            end
            if soundNode == nil then
                soundNode = self.components
            end
            self.airSamples = {}
            self.airSamples.airConnectHose = g_soundManager:loadSampleFromXML(xmlSoundFile, baseString, "airConnectHose", _modDirectory, soundNode, 1, AudioGroup.VEHICLE, self.i3dMappings, self)
            self.airSamples.airConnectHose.indoorAttributes.volume = self.airSamples.airConnectHose.indoorAttributes.volume * _airHoseConnectVolumeSetting
            self.airSamples.airConnectHose.outdoorAttributes.volume = self.airSamples.airConnectHose.outdoorAttributes.volume * _airHoseConnectVolumeSetting
            self.airSamples.airDisconnectHose = g_soundManager:loadSampleFromXML(xmlSoundFile, baseString, "airDisconnectHose", _modDirectory, soundNode, 1, AudioGroup.VEHICLE, self.i3dMappings, self)
            self.airSamples.airDisconnectHose.indoorAttributes.volume = self.airSamples.airDisconnectHose.indoorAttributes.volume * _airHoseConnectVolumeSetting
            self.airSamples.airDisconnectHose.outdoorAttributes.volume = self.airSamples.airDisconnectHose.outdoorAttributes.volume * _airHoseConnectVolumeSetting
            delete(xmlSoundFile)
        end
    end
end

function airHoseConnectSound:onPreAttach(attacherVehicle, inputJointDescIndex, jointDescIndex)
    if self.manualAttach then
        self.playConnectSound = false
    end
end
function airHoseConnectSound:onPostAttach(attacherVehicle, inputJointDescIndex, jointDescIndex)
    self.playConnectSound = true
end

function airHoseConnectSound:connectHose(sourceHose, targetObject, targetHose, updateToolConnections)

    if self.airSamples ~= nil then
        if targetHose ~= nil then
            if targetHose.type ~= nil then
                if targetHose.type == "airDoubleYellow" then

                    if self.playConnectSound then
                        if g_currentMission.time > 2000 then    -- 2 seconds after game start active 
                            if self.manualAttach then
                                g_soundManager:playSample(self.airSamples.airConnectHose, 150)  -- 150 ms delay
                            else
                                g_soundManager:playSample(self.airSamples.airConnectHose)
                            end
                            if targetObject.attachedAirConsumptionTimer ~= nil then
                                targetObject.attachedAirConsumptionTimer = 2000   -- 2 seconds
                            end
                        end
                        self.isAirDoubleYellowConnected = true
                    elseif g_currentMission.time < 2000 then
                        self.isAirDoubleYellowConnected = true
                    end
                    
                end
            end
        end
    end

end

function airHoseConnectSound:disconnectHose(hose)

    if self.airSamples ~= nil then
        if hose ~= nil then
            if hose.type ~= nil then
                if hose.type == "airDoubleYellow" then
                    if self.isAirDoubleYellowConnected then
                        self.isAirDoubleYellowConnected = false
                        if g_currentMission.time > 2000 then
                            g_soundManager:playSample(self.airSamples.airDisconnectHose)
                        end
                    end
                end
            end
        end
    end

end

function airHoseConnectSound:onDelete()
    if self.airSamples ~= nil then
        g_soundManager:deleteSamples(self.airSamples)
    end
end