--[[ toggleAnimation 

Author: 		HoFFi (modding-welt.com)
Remarks:		animations are limited to 10 for the current state


Description: 	script for activating xml-defined animation with user-defined input keys

Version: 		1.0.0.0

Changelog: 		2021-06-06 	- initial release


--------------------------------------------------------------------------------------------------


]]


toggleAnimation = {};

toggleAnimation.modDir = g_currentModDirectory;
toggleAnimation.currentModName = g_currentModName;

function toggleAnimation.prerequisitesPresent(specializations)
    return true; 
end;

function toggleAnimation.registerEventListeners(vehicleType)
	for _, spec in pairs({"onLoad", "onRegisterActionEvents", "actionEventTA_amim1", "actionEventTA_amim2", "actionEventTA_amim3", "actionEventTA_amim4", "actionEventTA_amim5", "actionEventTA_amim6", "actionEventTA_amim7", "actionEventTA_amim8", "actionEventTA_amim9", "actionEventTA_amim10"}) do
		SpecializationUtil.registerEventListener(vehicleType, spec, toggleAnimation)
	end
end

function toggleAnimation.registerFunctions(vehicleType)
    SpecializationUtil.registerFunction(vehicleType, "actionEventTA_amim1", toggleAnimation.actionEventTA_amim1)
    SpecializationUtil.registerFunction(vehicleType, "actionEventTA_amim2", toggleAnimation.actionEventTA_amim2)
    SpecializationUtil.registerFunction(vehicleType, "actionEventTA_amim3", toggleAnimation.actionEventTA_amim3)
    SpecializationUtil.registerFunction(vehicleType, "actionEventTA_amim4", toggleAnimation.actionEventTA_amim4)
    SpecializationUtil.registerFunction(vehicleType, "actionEventTA_amim5", toggleAnimation.actionEventTA_amim5)
    SpecializationUtil.registerFunction(vehicleType, "actionEventTA_amim6", toggleAnimation.actionEventTA_amim6)
    SpecializationUtil.registerFunction(vehicleType, "actionEventTA_amim7", toggleAnimation.actionEventTA_amim7)
    SpecializationUtil.registerFunction(vehicleType, "actionEventTA_amim8", toggleAnimation.actionEventTA_amim8)
    SpecializationUtil.registerFunction(vehicleType, "actionEventTA_amim9", toggleAnimation.actionEventTA_amim9)
    SpecializationUtil.registerFunction(vehicleType, "actionEventTA_amim10", toggleAnimation.actionEventTA_amim10)
end

function toggleAnimation:onLoad(savegame)
	self.toggleAnimation = {}
	self.toggleAnimation.anim1 = getXMLString(self.xmlFile, "vehicle.toggleAnimation#anim1")
	self.toggleAnimation.anim2 = getXMLString(self.xmlFile, "vehicle.toggleAnimation#anim2")
	self.toggleAnimation.anim3 = getXMLString(self.xmlFile, "vehicle.toggleAnimation#anim3")
	self.toggleAnimation.anim4 = getXMLString(self.xmlFile, "vehicle.toggleAnimation#anim4")
	self.toggleAnimation.anim5 = getXMLString(self.xmlFile, "vehicle.toggleAnimation#anim5")
	self.toggleAnimation.anim6 = getXMLString(self.xmlFile, "vehicle.toggleAnimation#anim6")
	self.toggleAnimation.anim7 = getXMLString(self.xmlFile, "vehicle.toggleAnimation#anim7")
	self.toggleAnimation.anim8 = getXMLString(self.xmlFile, "vehicle.toggleAnimation#anim8")
	self.toggleAnimation.anim9 = getXMLString(self.xmlFile, "vehicle.toggleAnimation#anim9")
	self.toggleAnimation.anim10 = getXMLString(self.xmlFile, "vehicle.toggleAnimation#anim10")
end;

function toggleAnimation:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
	if self.isClient then
		local spec = self.spec_cylindered
		self:clearActionEventsTable(spec.actionEvents)
		if isActiveForInput then
			if self.toggleAnimation.anim1 ~= nil then
				local actionEventId1
				_, actionEventId1 = self:addActionEvent(spec.actionEvents, InputAction.TA_amim1, self, toggleAnimation.actionEventTA_amim1, false, true, false, true, nil)
				g_inputBinding:setActionEventTextPriority(actionEventId1, GS_PRIO_VERY_HIGH)
			end
			if self.toggleAnimation.anim2 ~= nil then
				local actionEventId2
				_, actionEventId2 = self:addActionEvent(spec.actionEvents, InputAction.TA_amim2, self, toggleAnimation.actionEventTA_amim2, false, true, false, true, nil)
				g_inputBinding:setActionEventTextPriority(actionEventId2, GS_PRIO_VERY_HIGH)
			end
			if self.toggleAnimation.anim3 ~= nil then	
				local actionEventId3
				_, actionEventId3 = self:addActionEvent(spec.actionEvents, InputAction.TA_amim3, self, toggleAnimation.actionEventTA_amim3, false, true, false, true, nil)
				g_inputBinding:setActionEventTextPriority(actionEventId3, GS_PRIO_VERY_HIGH)
			end
			if self.toggleAnimation.anim4 ~= nil then	
				local actionEventId4
				_, actionEventId4 = self:addActionEvent(spec.actionEvents, InputAction.TA_amim4, self, toggleAnimation.actionEventTA_amim4, false, true, false, true, nil)
				g_inputBinding:setActionEventTextPriority(actionEventId4, GS_PRIO_VERY_HIGH)
			end
			if self.toggleAnimation.anim5 ~= nil then	
				local actionEventId5
				_, actionEventId5 = self:addActionEvent(spec.actionEvents, InputAction.TA_amim5, self, toggleAnimation.actionEventTA_amim5, false, true, false, true, nil)
				g_inputBinding:setActionEventTextPriority(actionEventId5, GS_PRIO_VERY_HIGH)
			end
			if self.toggleAnimation.anim6 ~= nil then	
				local actionEventId6
				_, actionEventId6 = self:addActionEvent(spec.actionEvents, InputAction.TA_amim6, self, toggleAnimation.actionEventTA_amim6, false, true, false, true, nil)
				g_inputBinding:setActionEventTextPriority(actionEventId6, GS_PRIO_VERY_HIGH)
			end
			if self.toggleAnimation.anim7 ~= nil then	
				local actionEventId7
				_, actionEventId7 = self:addActionEvent(spec.actionEvents, InputAction.TA_amim7, self, toggleAnimation.actionEventTA_amim7, false, true, false, true, nil)
				g_inputBinding:setActionEventTextPriority(actionEventId7, GS_PRIO_VERY_HIGH)
			end
			if self.toggleAnimation.anim8 ~= nil then	
				local actionEventId8
				_, actionEventId8 = self:addActionEvent(spec.actionEvents, InputAction.TA_amim8, self, toggleAnimation.actionEventTA_amim8, false, true, false, true, nil)
				g_inputBinding:setActionEventTextPriority(actionEventId8, GS_PRIO_VERY_HIGH)
			end
			if self.toggleAnimation.anim9 ~= nil then	
				local actionEventId9
				_, actionEventId9 = self:addActionEvent(spec.actionEvents, InputAction.TA_amim9, self, toggleAnimation.actionEventTA_amim9, false, true, false, true, nil)
				g_inputBinding:setActionEventTextPriority(actionEventId9, GS_PRIO_VERY_HIGH)
			end
			if self.toggleAnimation.anim10 ~= nil then	
				local actionEventId10
				_, actionEventId10 = self:addActionEvent(spec.actionEvents, InputAction.TA_amim10, self, toggleAnimation.actionEventTA_amim10, false, true, false, true, nil)
				g_inputBinding:setActionEventTextPriority(actionEventId10, GS_PRIO_VERY_HIGH)
			end
        end
	end
end

function toggleAnimation.actionEventTA_amim1(self, actionName, inputValue, callbackState, isAnalog)
	if self:getIsAnimationPlaying(self.toggleAnimation.anim1) == false then
		if self:getAnimationTime(self.toggleAnimation.anim1) == 1 then
			self:playAnimation(self.toggleAnimation.anim1, -1, self:getAnimationTime(self.toggleAnimation.anim1), true)
		else
			self:playAnimation(self.toggleAnimation.anim1, 1, self:getAnimationTime(self.toggleAnimation.anim1), true)
		end
	else
		self:stopAnimation(self.toggleAnimation.anim1, true)
	end
end

function toggleAnimation.actionEventTA_amim2(self, actionName, inputValue, callbackState, isAnalog)
	if self:getIsAnimationPlaying(self.toggleAnimation.anim2) == false then
		if self:getAnimationTime(self.toggleAnimation.anim2) == 1 then
			self:playAnimation(self.toggleAnimation.anim2, -1, self:getAnimationTime(self.toggleAnimation.anim2), true)
		else
			self:playAnimation(self.toggleAnimation.anim2, 1, self:getAnimationTime(self.toggleAnimation.anim2), true)
		end
	else
		self:stopAnimation(self.toggleAnimation.anim2, true)
	end
end

function toggleAnimation.actionEventTA_amim3(self, actionName, inputValue, callbackState, isAnalog)
	if self:getIsAnimationPlaying(self.toggleAnimation.anim3) == false then
		if self:getAnimationTime(self.toggleAnimation.anim3) == 1 then
			self:playAnimation(self.toggleAnimation.anim3, -1, self:getAnimationTime(self.toggleAnimation.anim3), true)
		else
			self:playAnimation(self.toggleAnimation.anim3, 1, self:getAnimationTime(self.toggleAnimation.anim3), true)
		end
	else
		self:stopAnimation(self.toggleAnimation.anim3, true)
	end
end

function toggleAnimation.actionEventTA_amim4(self, actionName, inputValue, callbackState, isAnalog)
	if self:getIsAnimationPlaying(self.toggleAnimation.anim4) == false then
		if self:getAnimationTime(self.toggleAnimation.anim4) == 1 then
			self:playAnimation(self.toggleAnimation.anim4, -1, self:getAnimationTime(self.toggleAnimation.anim4), true)
		else
			self:playAnimation(self.toggleAnimation.anim4, 1, self:getAnimationTime(self.toggleAnimation.anim4), true)
		end
	else
		self:stopAnimation(self.toggleAnimation.anim4, true)
	end
end

function toggleAnimation.actionEventTA_amim5(self, actionName, inputValue, callbackState, isAnalog)
	if self:getIsAnimationPlaying(self.toggleAnimation.anim5) == false then
		if self:getAnimationTime(self.toggleAnimation.anim5) == 1 then
			self:playAnimation(self.toggleAnimation.anim5, -1, self:getAnimationTime(self.toggleAnimation.anim5), true)
		else
			self:playAnimation(self.toggleAnimation.anim5, 1, self:getAnimationTime(self.toggleAnimation.anim5), true)
		end
	else
		self:stopAnimation(self.toggleAnimation.anim5, true)
	end
end

function toggleAnimation.actionEventTA_amim6(self, actionName, inputValue, callbackState, isAnalog)
	if self:getIsAnimationPlaying(self.toggleAnimation.anim6) == false then
		if self:getAnimationTime(self.toggleAnimation.anim6) == 1 then
			self:playAnimation(self.toggleAnimation.anim6, -1, self:getAnimationTime(self.toggleAnimation.anim6), true)
		else
			self:playAnimation(self.toggleAnimation.anim6, 1, self:getAnimationTime(self.toggleAnimation.anim6), true)
		end
	else
		self:stopAnimation(self.toggleAnimation.anim6, true)
	end
end

function toggleAnimation.actionEventTA_amim7(self, actionName, inputValue, callbackState, isAnalog)
	if self:getIsAnimationPlaying(self.toggleAnimation.anim7) == false then
		if self:getAnimationTime(self.toggleAnimation.anim7) == 1 then
			self:playAnimation(self.toggleAnimation.anim7, -1, self:getAnimationTime(self.toggleAnimation.anim7), true)
		else
			self:playAnimation(self.toggleAnimation.anim7, 1, self:getAnimationTime(self.toggleAnimation.anim7), true)
		end
	else
		self:stopAnimation(self.toggleAnimation.anim7, true)
	end
end

function toggleAnimation.actionEventTA_amim8(self, actionName, inputValue, callbackState, isAnalog)
	if self:getIsAnimationPlaying(self.toggleAnimation.anim8) == false then
		if self:getAnimationTime(self.toggleAnimation.anim8) == 1 then
			self:playAnimation(self.toggleAnimation.anim8, -1, self:getAnimationTime(self.toggleAnimation.anim8), true)
		else
			self:playAnimation(self.toggleAnimation.anim8, 1, self:getAnimationTime(self.toggleAnimation.anim8), true)
		end
	else
		self:stopAnimation(self.toggleAnimation.anim8, true)
	end
end

function toggleAnimation.actionEventTA_amim9(self, actionName, inputValue, callbackState, isAnalog)
	if self:getIsAnimationPlaying(self.toggleAnimation.anim9) == false then
		if self:getAnimationTime(self.toggleAnimation.anim9) == 1 then
			self:playAnimation(self.toggleAnimation.anim9, -1, self:getAnimationTime(self.toggleAnimation.anim9), true)
		else
			self:playAnimation(self.toggleAnimation.anim9, 1, self:getAnimationTime(self.toggleAnimation.anim9), true)
		end
	else
		self:stopAnimation(self.toggleAnimation.anim9, true)
	end
end

function toggleAnimation.actionEventTA_amim10(self, actionName, inputValue, callbackState, isAnalog)
	if self:getIsAnimationPlaying(self.toggleAnimation.anim10) == false then
		if self:getAnimationTime(self.toggleAnimation.anim10) == 1 then
			self:playAnimation(self.toggleAnimation.anim10, -1, self:getAnimationTime(self.toggleAnimation.anim10), true)
		else
			self:playAnimation(self.toggleAnimation.anim10, 1, self:getAnimationTime(self.toggleAnimation.anim10), true)
		end
	else
		self:stopAnimation(self.toggleAnimation.anim10, true)
	end
end