--[[
    Author: PeterAH (Modding-Welt)
    Mod name: Air Compressor Sound
    Version: 1.0.0.0
    Date: April 2021
    Contact: https://www.modding-welt.com
    Discord: [MW] PeterAH#5807
]]

trailerAirUsage = {}

local _modDirectory = g_currentModDirectory
local _airAttachVolumeSetting = 1.00

function trailerAirUsage.prerequisitesPresent(specializations)
    return true
end

function trailerAirUsage.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", trailerAirUsage)
    SpecializationUtil.registerEventListener(vehicleType, "onPostLoad", trailerAirUsage)
    SpecializationUtil.registerEventListener(vehicleType, "onPreAttach", trailerAirUsage)
    SpecializationUtil.registerEventListener(vehicleType, "onPostAttach", trailerAirUsage)
    SpecializationUtil.registerEventListener(vehicleType, "onDelete", trailerAirUsage)
end

function trailerAirUsage:onLoad(savegame)
    --print("onLoad trailerAirUsage ===========================================================================================")	

    local modDescXMLFile = loadXMLFile("modDescXMLFile", _modDirectory .. "modDesc.xml")
    _airAttachVolumeSetting = Utils.getNoNil(getXMLFloat(modDescXMLFile, "modDesc.airAttachSound#volumeSetting"), 1)
    delete(modDescXMLFile)

    self.connectHose = Utils.appendedFunction(ConnectionHoses.connectHose, trailerAirUsage.connectHose)
    self.disconnectHose = Utils.appendedFunction(ConnectionHoses.disconnectHose, trailerAirUsage.disconnectHose)

    self.isAirDoubleYellowConnected = false
    self.playConnectSound = true
    if getfenv(0).g_manualAttach ~= nil then
        self.manualAttach = true
    else
        self.manualAttach = false
    end
end

function trailerAirUsage:onPostLoad(savegame)

    if self.isClient then
        local baseString = "sounds"
        local xmlSoundFile
        local hasAirDoubleYellow = false

        if self.spec_connectionHoses ~= nil then
            local spec = self.spec_connectionHoses
            if type(spec.hoseNodes) == "table" then
                for i, _ in ipairs(spec.hoseNodes) do
                    if spec.hoseNodes[i].type ~= nil then
                        if spec.hoseNodes[i].type == "airDoubleYellow" then
                            hasAirDoubleYellow = true
                        end
                    end
                end                    
            end
        end

        if hasAirDoubleYellow then
            if fileExists(_modDirectory .. "sounds/compressorSound.xml") then
                xmlSoundFile = loadXMLFile("compressorSound", _modDirectory .. "sounds/compressorSound.xml")
            else
                print("Error: Script compressorSound.lua: XML-File not found: " .. _modDirectory .. "sounds/compressorSound.xml")
            end
        end
        
        if xmlSoundFile ~= nil then
            local soundNode
            if self.spec_attachable.inputAttacherJoints ~= nil then
                if self.spec_attachable.inputAttacherJoints[1] ~= nil then
                    if self.spec_attachable.inputAttacherJoints[1].node ~= nil then
                        soundNode = self.spec_attachable.inputAttacherJoints[1].node
                    end
                end
            end
            if soundNode == nil then
                soundNode = self.components
            end
            self.airSamples = {}
            self.airSamples.airConnectHose = g_soundManager:loadSampleFromXML(xmlSoundFile, baseString, "airConnectHose", _modDirectory, soundNode, 1, AudioGroup.VEHICLE, self.i3dMappings, self)
            self.airSamples.airConnectHose.indoorAttributes.volume = self.airSamples.airConnectHose.indoorAttributes.volume * _airAttachVolumeSetting
            self.airSamples.airConnectHose.outdoorAttributes.volume = self.airSamples.airConnectHose.outdoorAttributes.volume * _airAttachVolumeSetting
            self.airSamples.airDisconnectHose = g_soundManager:loadSampleFromXML(xmlSoundFile, baseString, "airDisconnectHose", _modDirectory, soundNode, 1, AudioGroup.VEHICLE, self.i3dMappings, self)
            self.airSamples.airDisconnectHose.indoorAttributes.volume = self.airSamples.airDisconnectHose.indoorAttributes.volume * _airAttachVolumeSetting
            self.airSamples.airDisconnectHose.outdoorAttributes.volume = self.airSamples.airDisconnectHose.outdoorAttributes.volume * _airAttachVolumeSetting
            delete(xmlSoundFile)
        end
    end
end

function trailerAirUsage:onPreAttach(attacherVehicle, inputJointDescIndex, jointDescIndex)
    if self.manualAttach then
        self.playConnectSound = false
    end
end
function trailerAirUsage:onPostAttach(attacherVehicle, inputJointDescIndex, jointDescIndex)
    self.playConnectSound = true
end

function trailerAirUsage:connectHose(sourceHose, targetObject, targetHose, updateToolConnections)

    if self.airSamples ~= nil then
        if targetHose ~= nil then
            if targetHose.type ~= nil then
                if targetHose.type == "airDoubleYellow" then

                    if self.playConnectSound then
                        if g_currentMission.time > 2000 then    -- 2 seconds after game start active 
                            if self.manualAttach then
                                g_soundManager:playSample(self.airSamples.airConnectHose, 150)  -- 150 ms delay
                            else
                                g_soundManager:playSample(self.airSamples.airConnectHose)
                            end
                            if targetObject.attachedAirConsumptionTimer ~= nil then
                                targetObject.attachedAirConsumptionTimer = 2000   -- 2 seconds
                            end
                        end
                        self.isAirDoubleYellowConnected = true
                    elseif g_currentMission.time < 2000 then
                        self.isAirDoubleYellowConnected = true
                    end
                    
                end
            end
        end
    end

end

function trailerAirUsage:disconnectHose(hose)

    if self.airSamples ~= nil then
        if hose ~= nil then
            if hose.type ~= nil then
                if hose.type == "airDoubleYellow" then
                    if self.isAirDoubleYellowConnected then
                        self.isAirDoubleYellowConnected = false
                        if g_currentMission.time > 2000 then
                            g_soundManager:playSample(self.airSamples.airDisconnectHose)
                        end
                    end
                end
            end
        end
    end

end

function trailerAirUsage:onDelete()
    if self.airSamples ~= nil then
        g_soundManager:deleteSamples(self.airSamples)
    end
end