--[[
    Author: PeterAH (Modding-Welt)
    Mod name: Air Compressor Sound
    Version: 1.0.0.0
    Date: April 2021
    Contact: https://www.modding-welt.com
    Discord: [MW] PeterAH#5807
]]

if g_specializationManager:getSpecializationByName("compressorSound") == nil then
    g_specializationManager.addSpecialization('compressorSound', 'compressorSound', 'compressorSound', Utils.getFilename('compressorSound.lua', g_currentModDirectory))
end

for vehicleTypeName, vehicleType in pairs(g_vehicleTypeManager.vehicleTypes) do 
    if vehicleType == nil then
    elseif SpecializationUtil.hasSpecialization(compressorSound, vehicleType.specializations) then
    elseif not SpecializationUtil.hasSpecialization(Motorized, vehicleType.specializations) then
    elseif not SpecializationUtil.hasSpecialization(Drivable, vehicleType.specializations) then
    elseif not SpecializationUtil.hasSpecialization(Wheels, vehicleType.specializations) then
    elseif vehicleTypeName == 'tractor' then
        g_vehicleTypeManager:addSpecialization(vehicleTypeName, 'compressorSound')
    elseif vehicleTypeName == 'tractorCrabSteering' then
        g_vehicleTypeManager:addSpecialization(vehicleTypeName, 'compressorSound')
    elseif vehicleTypeName == 'tractorReverseDriving' then
        g_vehicleTypeManager:addSpecialization(vehicleTypeName, 'compressorSound')
    elseif vehicleTypeName == 'tractorReverseDrivingCrabSteering' then
        g_vehicleTypeManager:addSpecialization(vehicleTypeName, 'compressorSound')
    elseif vehicleTypeName == 'selfPropelledSprayer' then
        g_vehicleTypeManager:addSpecialization(vehicleTypeName, 'compressorSound')
    elseif SpecializationUtil.hasSpecialization(ConveyorBelt, vehicleType.specializations) then
    elseif SpecializationUtil.hasSpecialization(Locomotive, vehicleType.specializations) then
    elseif SpecializationUtil.hasSpecialization(MixerWagon, vehicleType.specializations) then
    elseif SpecializationUtil.hasSpecialization(Combine, vehicleType.specializations) then
    elseif SpecializationUtil.hasSpecialization(Pipe, vehicleType.specializations) then
    elseif vehicleTypeName == 'selfPropelledMower' then
    elseif vehicleTypeName == 'woodHarvester' then
    elseif vehicleTypeName == 'teleHandler' then
    elseif vehicleTypeName == 'forwarder' then
    else
        g_vehicleTypeManager:addSpecialization(vehicleTypeName, 'compressorSound')
    end 
end


if g_specializationManager:getSpecializationByName("trailerAirUsage") == nil then
    g_specializationManager.addSpecialization('trailerAirUsage', 'trailerAirUsage', 'trailerAirUsage', Utils.getFilename('trailerAirUsage.lua', g_currentModDirectory))
end

for vehicleTypeName, vehicleType in pairs(g_vehicleTypeManager.vehicleTypes) do 
    if vehicleType == nil then
    elseif SpecializationUtil.hasSpecialization(trailerAirUsage, vehicleType.specializations) then
    elseif SpecializationUtil.hasSpecialization(Motorized, vehicleType.specializations) then
    elseif SpecializationUtil.hasSpecialization(Drivable, vehicleType.specializations) then
    elseif not SpecializationUtil.hasSpecialization(Wheels, vehicleType.specializations) then
    elseif not SpecializationUtil.hasSpecialization(Attachable, vehicleType.specializations) then
    elseif not SpecializationUtil.hasSpecialization(ConnectionHoses, vehicleType.specializations) then
    elseif vehicleTypeName == 'trainTimberTrailer' then
    elseif vehicleTypeName == 'trainTrailer' then
    else
        g_vehicleTypeManager:addSpecialization(vehicleTypeName, 'trailerAirUsage')
    end 
end
