--[[ screenFunctions 

Author: 		Antonis78

Description: 	script for various tractor onboard monitor informations

Version: 		1.1.0.0

Changelog: 		05/03/2020 	- initial release
				18/01/2021  - Added Gps, Baler, Damage and EV indications and sound warnings! 

                
]]


screenFunctions = {};

screenFunctions.modDir = g_currentModDirectory;
screenFunctions.currentModName = g_currentModName;

function screenFunctions.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations) and SpecializationUtil.hasSpecialization(PowerConsumer, specializations); 
end;
local file, id
  screenFunctions.sounds = {}
  for _, id in ipairs({"baler_full", "fault_warning"}) do
    screenFunctions.sounds[id] = createSample(id)
    file = screenFunctions.modDir.."sounds/"..id..".ogg"
    loadSample(screenFunctions.sounds[id], file, false)
  end
function screenFunctions.registerEventListeners(vehicleType)
	for _, spec in pairs({"onLoad", "onUpdate"}) do
		SpecializationUtil.registerEventListener(vehicleType, spec, screenFunctions)
	end
end

function screenFunctions:onLoad(savegame)
screenFunctions.delayTime = 50;
    self.driveDistance = 0
	self.driveDistance1 = 0
	self.driveDistance2 = 0
    totalBales = 0
    self.rotorRpm = 1030
	self.ptoRpm = 1000
	self.timer2 = 0
	self.timer1 = 0
	self.barPress = 2.8
	self.previousBaleCount = 0.0
	self.previousFillRatio = 0.0
	self.overSpeed = getXMLString(self.xmlFile, "vehicle.screenFunctions.overLoadSp#animName") 
	self.overSpeed2 = getXMLString(self.xmlFile, "vehicle.screenFunctions.overLoadSp2#animName") 
	self.indicatorBarNodeTipperCap = getXMLString(self.xmlFile, "vehicle.screenFunctions.indicatorBarNodeTipperCap#animName") 
	self.indicatorBarNodeCap = getXMLString(self.xmlFile, "vehicle.screenFunctions.indicatorBarNodeCap#animName") 
	self.indicatorBarNodeWagon = getXMLString(self.xmlFile, "vehicle.screenFunctions.indicatorBarNodeWagon#animName") 
	self.indicatorBarNode = getXMLString(self.xmlFile, "vehicle.screenFunctions.indicatorBarNode#animName") 
	self.arrowAngle = getXMLString(self.xmlFile, "vehicle.screenFunctions.horrizonAr#animName") 
	self.indicatorBarGps1 = getXMLString(self.xmlFile, "vehicle.screenFunctions.gpsIndicatorBar1#animName")
	self.tractorIcon = getXMLString(self.xmlFile, "vehicle.screenFunctions.tractor#animName")
	self.stopScreen = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#blackSc"), self.i3dMappings);
	self.ptoVisual = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#ptoicon"), self.i3dMappings);
	self.overload = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#overloadicon"), self.i3dMappings);
	self.overload2 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#overloadicon2"), self.i3dMappings);
	self.unloadbales = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#unloadBaleicon"), self.i3dMappings);
	self.fullWarning = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#fullWarnicon"), self.i3dMappings);
	self.wrapWarning = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#wrWarnicon"), self.i3dMappings);
	self.lowerArms = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#armsIcon1"), self.i3dMappings);
	self.raiseArms = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#armsIcon2"), self.i3dMappings);
	self.lowerPickup = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#pickupLIcon"), self.i3dMappings);
	self.raisePickup = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#pickupRIcon"), self.i3dMappings);
	self.lowerPickup2 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#pickupL2Icon"), self.i3dMappings);
	self.raisePickup2 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#pickupR2Icon"), self.i3dMappings);
	self.damageLevel1 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#damage1Icon"), self.i3dMappings);
	self.faulCode1 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#fault1Icon"), self.i3dMappings);
	self.faulWorkshop1 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#workshop1Icon"), self.i3dMappings);
	self.faulWorkshop2 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#workshop2Icon"), self.i3dMappings);
	self.faulWorkshop3 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#workshop3Icon"), self.i3dMappings);
	self.faulWorkshop4 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#workshop4Icon"), self.i3dMappings);
	self.stopTractor = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#totalDamageIcon"), self.i3dMappings);
	self.gpsReceiver = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#gpsReceiver"), self.i3dMappings);
	self.gpsReceiverOut = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#gpsReceiverOff"), self.i3dMappings);
	self.gpsSteering = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#gpsSteering"), self.i3dMappings);
	self.gpsSteering2 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#gpsSteering2"), self.i3dMappings);
	self.frontDiff = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#fDiffOn"), self.i3dMappings);
	self.diffLock = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#lockDiff"), self.i3dMappings);
	self.parkBrake = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#pBrake"), self.i3dMappings);
	self.parkBrake2 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.screenFunctions.indications#pBrake2"), self.i3dMappings);
	self.showInHud = Utils.getNoNil(getXMLBool(self.xmlFile, "vehicle.screenFunctions#showInHud"), true);
	self.loadLevel = 0.0
	self.loadLevel2 = 0.0
	self.loadWarnSamplePlayed = false
	self.currentVoltage = 24.8
	self.batvolt = VehicleHudUtils.loadHud(self, self.xmlFile, "batteryVolt");
	self.loadprc = VehicleHudUtils.loadHud(self, self.xmlFile, "loadPercent");
	self.slipprc = VehicleHudUtils.loadHud(self, self.xmlFile, "slipPercent");
	self.bales = VehicleHudUtils.loadHud(self, self.xmlFile, "balesCount");
	self.rotor = VehicleHudUtils.loadHud(self, self.xmlFile, "rotorBaler");
	self.pto = VehicleHudUtils.loadHud(self, self.xmlFile, "ptoActive");
	self.pto2 = VehicleHudUtils.loadHud(self, self.xmlFile, "ptoActive2");
	self.pressure = VehicleHudUtils.loadHud(self, self.xmlFile, "press");
	self.capacity = VehicleHudUtils.loadHud(self, self.xmlFile, "loadCapacity");
	self.capacity2 = VehicleHudUtils.loadHud(self, self.xmlFile, "loadCapacity2");
	self.capacity3 = VehicleHudUtils.loadHud(self, self.xmlFile, "loadCapacity3");
	self.tirePress = VehicleHudUtils.loadHud(self, self.xmlFile, "air");
	self.tirePress1 = VehicleHudUtils.loadHud(self, self.xmlFile, "air1");
	self.damage = VehicleHudUtils.loadHud(self, self.xmlFile, "tractorDamage");
	self.fieldKilom = VehicleHudUtils.loadHud(self, self.xmlFile, "kmeters");
	self.fieldRad = VehicleHudUtils.loadHud(self, self.xmlFile, "radAng");
	self.implemWidth = VehicleHudUtils.loadHud(self, self.xmlFile, "implementW");
	self.implemOffset = VehicleHudUtils.loadHud(self, self.xmlFile, "implementO");
	self.fieldNo = VehicleHudUtils.loadHud(self, self.xmlFile, "fieldNr");
end;


function screenFunctions:onUpdate(dt)
    VehicleHudUtils.setHudValue(self, self.capacity, 0 , 0);
    VehicleHudUtils.setHudValue(self, self.capacity2, 0 , 0);
    VehicleHudUtils.setHudValue(self, self.capacity3, 0 , 0);
	self:setAnimationTime(self.indicatorBarNodeCap, 0);
    self:setAnimationTime(self.indicatorBarNodeTipperCap, 0);
	self:setAnimationTime(self.overSpeed, 0, 0);
	self:setAnimationTime(self.overSpeed2, 0, 0)
    setVisibility(self.fullWarning, false);
    setVisibility(self.unloadbales, false);
    setVisibility(self.wrapWarning, false);
	setVisibility(self.stopScreen, true);
     local spec = self.spec_tirePressure
	 if self:getIsMotorStarted() then
	    setVisibility(self.stopScreen, false);
            if self.tirePress ~= nil then
				if spec.inflationPressure ~= nil then
    				VehicleHudUtils.setHudValue(self, self.tirePress, spec.inflationPressure, 100); 
				end;
				if self.tirePress1 ~= nil then
				if spec.inflationPressure ~= nil then
    				VehicleHudUtils.setHudValue(self, self.tirePress1, spec.inflationPressure, 100); 
				end;
			end;
			end;
		end; 
    
	local spec = self.spec_motorized
    local loadPercentage = spec.motor:getMotorAppliedTorque() / math.max(spec.motor:getMotorAvailableTorque(), 0.0001)
    spec.actualLoadPercentage = loadPercentage
        if spec.actualLoadPercentage > spec.smoothedLoadPercentage then
            spec.smoothedLoadPercentage = 0.95*spec.smoothedLoadPercentage + 0.05*loadPercentage
        else
            spec.smoothedLoadPercentage = 0.98*spec.smoothedLoadPercentage + 0.02*loadPercentage
        end
		if self:getIsMotorStarted() then
            if self.loadprc ~= nil then
				if spec.smoothedLoadPercentage ~= nil then
    				VehicleHudUtils.setHudValue(self, self.loadprc, spec.smoothedLoadPercentage * 106, 100); 
				end;
			end;
		end; 
		local currentVoltage = self.currentVoltage + (spec.motor:getLastMotorRpm() - spec.motor:getMinRpm()) / (spec.motor:getMaxRpm() - spec.motor:getMinRpm())
		spec.batteryVolt = currentVoltage
	 	if self:getIsMotorStarted() then
            if self.batvolt ~= nil then
				if spec.batteryVolt ~= nil then
    				VehicleHudUtils.setHudValue(self, self.batvolt, spec.batteryVolt, 100); 
				end;
			end;
		end; 
	local UseGUI = true;
	    if g_client and UseGUI then
		-- Check number of vehicles
		numVehicles = table.getn(g_currentMission.vehicles);
		-- If vehicles present run code
		if numVehicles ~= nil then
			-- Run code for vehicles
			if numVehicles >= 1 then
				-- Search for controlled vehicle
				for VehicleIndex=1, numVehicles do
		local vehicle = g_currentMission.vehicles[VehicleIndex];
		if vehicle ~= nil then
		    if vehicle.spec_motorized then
				if vehicle.spec_wheels ~= nil then	
					if vehicle:getIsControlled() then
						if g_currentMission.controlledVehicle == vehicle then
		                   if self:getIsMotorStarted() then
                             if self.slipprc ~= nil then
				               if vehicle.GUISlip ~= nil then
	        					VehicleHudUtils.setHudValue(self, self.slipprc, vehicle.GUISlip , 100); 
			                	end;
			                   end;
		                     end; 				  
					       end;
						end;
					end;
				end;
			end;
        end;
	    end;
	    end;
		end;
	    local fillLevelInformations = {}
        local fillRatio = 0.0							
        self:getFillLevelInformation(fillLevelInformations)
		self.lastFT = spec.lastValidInputFruitType
        for _,fillLevelInformation in pairs(fillLevelInformations) do
        fillRatio = fillLevelInformation.fillLevel / fillLevelInformation.capacity
            if self.previousFillRatio == 0.0 then
               self.previousFillRatio = fillRatio 
				
		    end
	    local currentLoadLevel = math.min((fillRatio - self.previousFillRatio) * 450)
        self.loadLevel = self.loadLevel + (currentLoadLevel - self.loadLevel) / 40
		local currentLoadLevel2 = math.min((fillRatio - self.previousFillRatio) * 5000)
        self.loadLevel2 = self.loadLevel2 + (currentLoadLevel2 - self.loadLevel2) / 30
           end
			if self.loadLevel ~= nil then
			self:setAnimationTime(self.indicatorBarNode, self.loadLevel);
			self:setAnimationTime(self.indicatorBarNodeWagon, self.loadLevel2);
			end
			if self.loadLevel > 0.9 then
			setVisibility(self.overload, true);
			else
   			setVisibility(self.overload, false);
			end
			self.previousFillRatio = fillRatio
			
			local hudcapacity = 0
			
			for _,fillLevelInformation in pairs(fillLevelInformations) do
			hudCapacity = fillLevelInformation.fillLevel 
			
			    if hudCapacity ~= nil then
				   if self.capacity ~= nil then 
				 VehicleHudUtils.setHudValue(self, self.capacity, hudCapacity , 100);
				 VehicleHudUtils.setHudValue(self, self.capacity2, hudCapacity , 100);
				 VehicleHudUtils.setHudValue(self, self.capacity3, hudCapacity , 100);
				   end
			 	  end	
				end
		local animhudcapacity = 0
			
			 for _,fillLevelInformation in pairs(fillLevelInformations) do
			animhudCapacity = (fillLevelInformation.fillLevel / fillLevelInformation.capacity)
			
   			    if animhudCapacity ~= nil then
			     self:setAnimationTime(self.indicatorBarNodeCap, animhudCapacity);
			      self:setAnimationTime(self.indicatorBarNodeTipperCap, animhudCapacity);
                end	
            end				  
   		local spec = self.spec_powerConsumer
		
		setVisibility(self.ptoVisual, false);
		setVisibility(self.lowerArms, false);
		setVisibility(self.raiseArms, false);
		setVisibility(self.lowerPickup, false);
		setVisibility(self.raisePickup, false);
		setVisibility(self.lowerPickup2, false);
		setVisibility(self.raisePickup2, false);
        setVisibility(self.damageLevel1, false);
		setVisibility(self.faulWorkshop1, false);
		setVisibility(self.faulWorkshop2, false);
		setVisibility(self.faulWorkshop3, false);
		setVisibility(self.faulWorkshop4, false);
		setVisibility(self.stopTractor, false);
		setVisibility(self.overload2, false);
		spec.wear =  self:getWearTotalAmount()
		spec.rpmr = 1.5 / 300
		spec.rotorFactor = 3
		    if self.damage ~= nil then
    	        if spec.wear ~= nil then
	            VehicleHudUtils.setHudValue(self, self.damage, spec.wear * 100, 100); 
	            end
	        end 
	   	local delta = spec.rpmr * dt
			if spec.wear == 0 then
			self.timer2 = 0
			self.timer1 = 0
			end
	        if spec.wear >= 0.3 then
			setVisibility(self.damageLevel1, true);
			setVisibility(self.faulWorkshop1, true);
			setVisibility(self.faulWorkshop2, true);
		    if self.timer2 < 1000 then
               self.timer2 = self.timer2 + dt / spec.rotorFactor + delta
     		   setVisibility(self.faulCode1, true);
            end
			if self.timer2 > 1000 then
			   setVisibility(self.faulCode1, false);
			end
			end  
	 	   if spec.wear >= 0.6 then
		   setVisibility(self.faulWorkshop3, true);
		   setVisibility(self.faulWorkshop4, true);
		   if self.timer1 < 1000 then
              self.timer1 = self.timer1 + dt / spec.rotorFactor + delta
			  setVisibility(self.faulCode1, true);
            end
		   if self.timer1 > 1000 then
			  setVisibility(self.faulCode1, false);
		    end
		    end
		  
		   if spec.wear >= 0.96 then  
		      setVisibility(self.stopTractor, true);
		   end
		   if spec.wear >= 0.99 then 
		      self:stopMotor()
		   end
		    if self:getIsMotorStarted() and self.timer2 > 90 and self.timer2 < 100 or self:getIsMotorStarted() and self.timer1 > 90 and self.timer1 < 100 then
		       playSample(screenFunctions.sounds["fault_warning"], 2, 0.5, 0, 0, 0)
           end
		   if self.getAttachedImplements ~= nil then
           for _, implement in pairs(self:getAttachedImplements()) do
		   local object = implement.object
		   if object.spec_baler ~= nil then
		   if fillRatio == 1 then 
              setVisibility(self.unloadbales, true);
		   end
		   if self:getIsMotorStarted() and not getVisibility(self.unloadbales) and fillRatio > 0.9 then
		       playSample(screenFunctions.sounds["baler_full"], 1, 0.3, 0, 300, 0)
           end
		   end
		
		   if object.spec_baleWrapper ~= nil and object:getDoConsumePtoPower() then
		   if not object:allowsGrabbingBale() then
   		     setVisibility(self.wrapWarning, true);
	       end
		   end	
			
		   if object.spec_forageWagon ~= nil and self:getIsMotorStarted() then
		   if fillRatio > 0.95 and fillRatio < 1 then 
			  setVisibility(self.fullWarning, true);
   		   end
		   if not getVisibility(self.fullWarning) and fillRatio > 0.9 then
		       playSample(screenFunctions.sounds["baler_full"], 1, 0.3, 0, 300, 0)
           end
		   end	
			
		   local spec = self.spec_drivable
			if self.loadLevel < 0.98 and (object:getDoConsumePtoPower() and object:getIsLowered() and object.spec_baler) then
			spec.cruiseControl.speed = Baler.getDefaultSpeedLimit()
			end
			if self.getCruiseControlState ~= nil then
			if self:getCruiseControlState() == Drivable.CRUISECONTROL_STATE_ACTIVE then
			if object:getDoConsumePtoPower() and object:getIsLowered() and object.spec_baler then
			self:setAnimationTime(self.overSpeed, 1, 1)
			if self.loadLevel > 0.99 then
			spec.cruiseControl.speed = (self:getLastSpeed() /  self.loadLevel / 100) * 99
			end
			end
			end
			end
			 local spec = self.spec_drivable
			if self.loadLevel2 < 0.98 and (object:getDoConsumePtoPower() and object:getIsLowered() and object.spec_forageWagon) then
			spec.cruiseControl.speed = ForageWagon.getDefaultSpeedLimit()
			end
			if self.getCruiseControlState ~= nil then
			if self:getCruiseControlState() == Drivable.CRUISECONTROL_STATE_ACTIVE then
			if object:getDoConsumePtoPower() and object:getIsLowered() and object.spec_forageWagon then
			self:setAnimationTime(self.overSpeed2, 1, 1)
			if self.loadLevel2 > 0.99 then
			spec.cruiseControl.speed = (self:getLastSpeed() /  self.loadLevel2 / 100) * 99
			setVisibility(self.overload2, true);
			end
			end
			end
			end
			
     		spec.rpmr = 1.5 / 100
            spec.ptoFactor = 3	
		    spec.rotorFactor = 3
		    spec.pressFactor = 7
	    	if object:getDoConsumePtoPower() ~= nil then
           local delta = spec.rpmr * dt
            if object:getDoConsumePtoPower() then 
		       setVisibility(self.ptoVisual, true);
   		    if self.rotorRpm < 1730 then
               self.rotorRpm = self.rotorRpm + dt / spec.rotorFactor + delta
            end
              else
            if self.rotorRpm > 0.1 then
               self.rotorRpm = self.rotorRpm - dt / spec.rotorFactor + delta
            end
     	    end
		      VehicleHudUtils.setHudValue(self, self.rotor, self.rotorRpm, 100);
	        if object:getIsSelected() then
	           if not (object.getIsLowered ~= nil and object:getIsLowered(true)) then
		          setVisibility(self.raiseArms, true);
		          setVisibility(self.raisePickup, true);
		          setVisibility(self.raisePickup2, true);
		    else
		          setVisibility(self.lowerArms, true);
		          setVisibility(self.lowerPickup, true);
		          setVisibility(self.lowerPickup2, true);
		        end
		    end
			
	    local delta = spec.rpmr * dt
	        if object:getDoConsumePtoPower() then
		        if self.ptoRpm < 1000 then
                   self.ptoRpm = self.ptoRpm + dt / spec.ptoFactor + delta
                end
            else
                if self.ptoRpm > 0.1 then
                   self.ptoRpm = self.ptoRpm - dt / spec.ptoFactor + delta
		        end
            end
	        VehicleHudUtils.setHudValue(self, self.pto2, self.ptoRpm, 100);	
	        VehicleHudUtils.setHudValue(self, self.pto, self.ptoRpm, 100);
	    local delta = spec.rpmr * dt
	        if object:getDoConsumePtoPower() then
		       if self.barPress < 2.8 then
                  self.barPress = self.barPress + dt / spec.pressFactor 
              end
        else
            if self.barPress > 0.001 then
               self.barPress = self.barPress - dt / spec.pressFactor 
		    end 
           end
		       VehicleHudUtils.setHudValue(self, self.pressure, self.barPress, 100);    
		  end
		 end
		end
		local spec = self.spec_globalPositioningSystem
		self.driveDistance1 = self.driveDistance1 + self.lastMovedDistance*0.001
		self.driveDistance2 = self.driveDistance / 4
		    setVisibility(self.gpsReceiver, false);
        	setVisibility(self.gpsReceiverOut, true);
	        setVisibility(self.gpsSteering, false);
            setVisibility(self.gpsSteering2, false);
		if self.spec_globalPositioningSystem ~= nil then
	    if self:getIsMotorStarted() then
   	    if self:getHasGuidanceSystem() then
	       setVisibility(self.gpsReceiverOut, false);
	       setVisibility(self.gpsReceiver, true);
	   	if self.implemWidth ~= nil then
          VehicleHudUtils.setHudValue(self, self.implemWidth, spec.guidanceData.width, 100);
        end	
	    if self.implemOffset ~= nil then
	      VehicleHudUtils.setHudValue(self, self.implemOffset, spec.guidanceData.offsetWidth, 100);
	    end	
		if self.getAttachedImplements ~= nil then
        for _, implement in pairs(self:getAttachedImplements()) do
        local object = implement.object		
		if self.driveDistance2 ~= nil then
		if object:getIsLowered() or object:getDoConsumePtoPower() then
		self.driveDistance = self.driveDistance + self.lastMovedDistance*0.001
		end
		 self:setAnimationTime(self.indicatorBarGps1, self.driveDistance2)
		 self:setAnimationTime(self.tractorIcon, self.driveDistance2)
	   end;
	   end
	   end
	    if self.driveDistance1 ~= nil then
	   VehicleHudUtils.setHudValue(self, self.fieldKilom, self.driveDistance1 * 1000, 100);
	   end
	    if self.driveDistance >= 4 then
		self.driveDistance = 0
		end
   	   local data = spec.guidanceData
	   if spec.guidanceSteeringIsActive then
	   setVisibility(self.gpsSteering, true);
	   setVisibility(self.gpsSteering2, true);
       end		
	   end;
	   end;
	   end;
	   
	   local dirX, _, dirZ = localDirectionToWorld(self.rootNode, 0, 0, 1);
	   local arrowDirection = MathUtil.round(math.deg(math.abs(MathUtil.getYRotationFromDirection(dirX, dirZ) - math.pi)), 1);
	   if self.fieldRad ~= nil then
	    VehicleHudUtils.setHudValue(self, self.fieldRad, arrowDirection, 100);
	   if self.arrowAngle ~= nil then 
		  self:setAnimationTime(self.arrowAngle, arrowDirection / 360)
	   end
	   end
	   local currentWorkingField = 0
	   if g_currentMission.controlledVehicle ~= nil then
    	posX, _, posZ = getWorldTranslation(g_currentMission.controlledVehicle.rootNode);
       end;

	   if posX ~= nil and posZ ~= nil then
	   local farmland = g_farmlandManager:getFarmlandAtWorldPosition(posX, posZ);
       if farmland ~= nil then
	   local fieldMapping = g_fieldManager.farmlandIdFieldMapping[farmland.id];
       if fieldMapping ~= nil and fieldMapping[1] ~= nil then
          currentWorkingField = fieldMapping[1].fieldId;
       end;
	   end;
	   end;
		
	   if self.fieldNo ~= nil then
		 VehicleHudUtils.setHudValue(self, self.fieldNo, currentWorkingField, 100);
	   end
	   if self.vData ~= nil then
	   if self.vData.is[1] or self.vData.is[2] then
		  setVisibility(self.diffLock, true);
	   else
		  setVisibility(self.diffLock, false);
	   end
	   if self.vData.is[3] == 1 then
		  setVisibility(self.frontDiff, true);
	   else
		  setVisibility(self.frontDiff, false);
	  end
	   if self.vData.is[5] and self.vData.is[6] then
		setVisibility(self.parkBrake, true);
		setVisibility(self.parkBrake2, true);
	   else
		setVisibility(self.parkBrake, false);
		setVisibility(self.parkBrake2, false);
	   end
	   if not self:getIsMotorStarted() then
		setVisibility(self.diffLock, false);
		setVisibility(self.frontDiff, false);
		setVisibility(self.parkBrake, false);
		setVisibility(self.parkBrake2, false);
	   end
	   end
end