--[[ solarBatteryScript 

Author: 		HoFFi (modding-welt.com)´
Description: 	adds abbility for a vehicle to only work if solar power is active, else switching to battery
Version: 		1.0.0.0
Changelog: 		2020-10-22 	- initial release


--------------------------------------------------------------------------------------------------

Moddesc:
	<specializations>
        <specialization name="solarBatteryScript" className="solarBatteryScript" filename="scripts/solarBatteryScript.lua"/>
    </specializations>
	
	<vehicleTypes>
		<type name="your vehicleType name" className="Vehicle" filename="$dataS/scripts/vehicles/Vehicle.lua"  parent="xxxxxx">
			...
			...
			...
			...
			<specialization name="solarBatteryScript" />
		</type>
	</vehicleTypes>
	
	<l10n>
		<text name="Battery"><en>Battery</en><de>Batterie</de></text>
	</l10n>
	
XML (optional):
	<solarBatteryScript batteryTime="0.25" showInHud="true" warnSoundFile="$data/sounds/vehicles/reverse_beep/komatsu_reverse_beep_loop.ogg"/>
	
	
	batteryTime (optional) = time in hours battery will last --> default: 0.25
	showInHud (optional) = if true, you get battery status in F1-hud --> default: true
	warnSoundFile (optional) = custom warn sound --> default: "$data/sounds/vehicles/reverse_beep/komatsu_reverse_beep_loop.ogg"
]]


solarBatteryScript = {};

solarBatteryScript.modDir = g_currentModDirectory;
solarBatteryScript.currentModName = g_currentModName;

function solarBatteryScript.prerequisitesPresent(specializations)
    return true; 
end;

function solarBatteryScript.registerEventListeners(vehicleType)
	for _, spec in pairs({"onLoad", "onUpdate", "onDraw"}) do
		SpecializationUtil.registerEventListener(vehicleType, spec, solarBatteryScript)
	end
end

function solarBatteryScript:onLoad(savegame)
	self.solarBatteryScript = {}
	self.solarBatteryScript.showInHud = Utils.getNoNil(getXMLBool(self.xmlFile, "vehicle.solarBatteryScript#showInHud"), true);
	self.solarBatteryScript.warnSound = Utils.getNoNil(getXMLString(self.xmlFile, "vehicle.solarBatteryScript#warnSoundFile"), "$data/sounds/vehicles/reverse_beep/komatsu_reverse_beep_loop.ogg")
	self.solarBatteryScript.batteryCapacityHours = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.solarBatteryScript#batteryTime"), 0.25) * 3600000;
	self.solarBatteryScript.gaugeWidth = 0;
	self.solarBatteryScript.batteryCharge = 100;
	self.solarBatteryScript.timer = 0
	self.solarBatteryScript.dieselFillUnitI = Utils.getNoNil(getXMLInt(self.xmlFile, "vehicle.solarBatteryScript#dieselFillUnitIndex"), 1);
	self:setFillUnitCapacity(self.solarBatteryScript.dieselFillUnitI, self.solarBatteryScript.batteryCapacityHours)
	self:addFillUnitFillLevel(self:getOwnerFarmId(), self.solarBatteryScript.dieselFillUnitI, self.solarBatteryScript.batteryCapacityHours, FillType.DIESEL, ToolType.UNDEFINED, nil)
	
	local fillUnit = self:getFillUnitByIndex(self.solarBatteryScript.dieselFillUnitI)
	fillUnit.updateMass = false
end;


function solarBatteryScript:onUpdate(dt)
	if g_currentMission.environment.isSunOn == false or g_currentMission.environment.weather:getIsRaining() then
			self.solarBatteryScript.timer = self.solarBatteryScript.timer + (1 * g_currentMission.missionInfo.timeScale);
			if self.solarBatteryScript.batteryCapacityHours <= 0 then
				self.solarBatteryScript.batteryCapacityHours = 0 
			else
				self.solarBatteryScript.batteryCapacityHours = self.solarBatteryScript.batteryCapacityHours - (10 * g_currentMission.missionInfo.timeScale)
				self:addFillUnitFillLevel(self:getOwnerFarmId(), self.solarBatteryScript.dieselFillUnitI, -(10 * g_currentMission.missionInfo.timeScale), FillType.DIESEL, ToolType.UNDEFINED, nil)
			end
	else
		self.solarBatteryScript.timer = 0
		if self.solarBatteryScript.batteryCapacityHours >= Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.solarBatteryScript#batteryTime"), 0.25) * 3600000 then
			self.solarBatteryScript.batteryCapacityHours = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.solarBatteryScript#batteryTime"), 0.25) * 3600000
		else
			self.solarBatteryScript.batteryCapacityHours = self.solarBatteryScript.batteryCapacityHours + (50 * g_currentMission.missionInfo.timeScale)
			self:addFillUnitFillLevel(self:getOwnerFarmId(), self.solarBatteryScript.dieselFillUnitI, (50 * g_currentMission.missionInfo.timeScale), FillType.DIESEL, ToolType.UNDEFINED, nil)
		end
	end
	
	if self.solarBatteryScript.timer == (1 * g_currentMission.missionInfo.timeScale) then
		g_currentMission:showBlinkingWarning("Solar power not available. Switching to battery", 4000)
	end
	
	if self.solarBatteryScript.batteryCapacityHours <= 120 and self.solarBatteryScript.batteryCapacityHours > 0 then
		local fileName = Utils.getFilename(self.solarBatteryScript.warnSound, self.baseDirectory)
		self.solarBatteryScript.warnSample = createSample("warnSampleSound")
		loadSample(self.solarBatteryScript.warnSample, fileName, false)
		playSample(self.solarBatteryScript.warnSample, 1, 1.0, 0, 0, 0)
		g_currentMission:showBlinkingWarning("Battery empty", 4000)
	end
	
	
	
	self.solarBatteryScript.batteryCharge = (self.solarBatteryScript.batteryCapacityHours / (Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.solarBatteryScript#batteryTime"), 0.25) * 3600000)) * 100
end;

function solarBatteryScript:onDraw(isActiveForInput, isSelected)
	if self.isClient then
		if isSelected then
			if self.solarBatteryScript.showInHud then
				text1 = (MathUtil.round(self.solarBatteryScript.gaugeWidth, 1) * -1) - 0.1
				g_currentMission:addExtraPrintText(g_i18n:getText("Battery") ..": " .. MathUtil.round(self.solarBatteryScript.batteryCharge) .. " % / " .. tostring(MathUtil.round(((self.solarBatteryScript.batteryCapacityHours / 3600000) / g_currentMission.missionInfo.timeScale), 2)) .." h" )
				-- timers for testing
				-- g_currentMission:addExtraPrintText(tostring(self.solarBatteryScript.timer) .. "     " .. tostring(self.solarBatteryScript.batteryCapacityHours))
			end
		end
	end
end