--[[
    Author: PeterAH (Modding-Welt)
    Mod name: Adjust Working Speed
    Version: 1.0.0.0
    Date: October 2020
    Contact: https://www.modding-welt.com
    Discord: [MW] PeterAH#5807
]]

if g_specializationManager:getSpecializationByName("adjustWorkingSpeed") == nil then
    g_specializationManager.addSpecialization('adjustWorkingSpeed', 'adjustWorkingSpeed', 'adjustWorkingSpeed', Utils.getFilename('adjustWorkingSpeed.lua', g_currentModDirectory))
end

for vehicleTypeName, vehicleType in pairs(g_vehicleTypeManager.vehicleTypes) do 
    if vehicleType == nil then
    elseif SpecializationUtil.hasSpecialization(adjustWorkingSpeed, vehicleType.specializations) then
    elseif SpecializationUtil.hasSpecialization(Locomotive, vehicleType.specializations) then
    elseif vehicleTypeName == 'trainTimberTrailer' then
    elseif vehicleTypeName == 'trainTrailer' then
    elseif vehicleTypeName == 'pallet' then
    elseif vehicleTypeName == 'horse' then
    else
        g_vehicleTypeManager:addSpecialization(vehicleTypeName, 'adjustWorkingSpeed')
    end 
end

function initNewStoreConfig()
    --print("initNewStoreConfig =============================================================")	
    g_configurationManager:addConfigurationType("adjustWorkingSpeed", g_i18n:getText("CONFIG_TITLE"), nil, nil, nil, nil, ConfigurationUtil.SELECTOR_MULTIOPTION)
	StoreItemUtil.getConfigurationsFromXML = Utils.overwrittenFunction(StoreItemUtil.getConfigurationsFromXML, addNewStoreConfig)
end

function addNewStoreConfig(xmlFile, superFunc, baseXMLName, baseDir, customEnvironment, isMod, storeItem)
	local configurations = superFunc(xmlFile, baseXMLName, baseDir, customEnvironment, isMod, storeItem)    
    local speedLimit
    
    if storeItem ~= nil then
        if storeItem.specs.speedLimit == nil then
            speedLimit = 0
        elseif storeItem.specs.speedLimit == "" then
            speedLimit = 0
        else
            speedLimit = Utils.getNoNil(tonumber(storeItem.specs.speedLimit), 0)
        end
        --if speedLimit == 0 and configurations == nil then
        --    print(storeItem.categoryName)
        --end
        if speedLimit > 0.5 then
            if configurations == nil then
                if storeItem.categoryName == "ANIMALPENS" then
                elseif storeItem.categoryName == "PLACEABLEMISC" then
                elseif storeItem.categoryName == "DECORATION" then
                elseif storeItem.categoryName == "FARMHOUSES" then
                elseif storeItem.categoryName == "SILOS" then
                elseif storeItem.categoryName == "WOOD" then
                elseif storeItem.categoryName == "ANIMALS" then
                else
                    configurations = {}
                end
            end
        end
    end
    
    local integrateConfig = false
    if storeItem == nil then
    elseif configurations == nil then
    elseif configurations["adjustWorkingSpeed"] ~= nil then
    else
        integrateConfig = true
    end
    
    if speedLimit > 0.5 and integrateConfig == true then
        adjWS.i = adjWS.i + 1
        adjWS.xmls[adjWS.i] = storeItem.xmlFilename
        
        local i = 0
        local speed
        local milesSpeed
        local kph = " " .. g_i18n:getText("CONFIG_KPH")
        local cName = {}
        for speed = speedLimit - 7, speedLimit + 7 do
            i = i + 1
            if i == 8 then
                if g_gameSettings.useMiles == false then
                    cName[i] = math.max(tostring(speed), 1) .. kph .. " " .. g_i18n:getText("CONFIG_STANDARD")
                else
                    milesSpeed = math.floor(speed / 1.609344)
                    cName[i] = math.max(tostring(milesSpeed), 1) .. " mph " .. g_i18n:getText("CONFIG_STANDARD")
                end
            else
                if g_gameSettings.useMiles == false then
                    cName[i] = math.max(tostring(speed), 1) .. kph
                else
                    milesSpeed = math.floor(speed / 0.1609344 - 5) / 10
                    cName[i] = math.max(tostring(milesSpeed), 1) .. " mph "
                end
            end
        end
        
        configurations["adjustWorkingSpeed"] = {
            {name = cName[1], index = 1, isDefault = false,  price = 0, dailyUpkeep = 0, desc = ""},
            {name = cName[2], index = 2, isDefault = false, price = 0, dailyUpkeep = 0, desc = ""},
            {name = cName[3], index = 3, isDefault = false, price = 0, dailyUpkeep = 0, desc = ""},
            {name = cName[4], index = 4, isDefault = false, price = 0, dailyUpkeep = 0, desc = ""},
            {name = cName[5], index = 5, isDefault = false, price = 0, dailyUpkeep = 0, desc = ""},
            {name = cName[6], index = 6, isDefault = false, price = 0, dailyUpkeep = 0, desc = ""},
            {name = cName[7], index = 7, isDefault = false, price = 0, dailyUpkeep = 0, desc = ""},
            {name = cName[8], index = 8, isDefault = true,  price = 0, dailyUpkeep = 0, desc = ""},
            {name = cName[9], index = 9, isDefault = false, price = 0, dailyUpkeep = 0, desc = ""},
            {name = cName[10],index = 10,isDefault = false, price = 0, dailyUpkeep = 0, desc = ""},
            {name = cName[11],index = 11,isDefault = false, price = 0, dailyUpkeep = 0, desc = ""},
            {name = cName[12],index = 12,isDefault = false, price = 0, dailyUpkeep = 0, desc = ""},
            {name = cName[13],index = 13,isDefault = false, price = 0, dailyUpkeep = 0, desc = ""},
            {name = cName[14],index = 14,isDefault = false, price = 0, dailyUpkeep = 0, desc = ""},
            {name = cName[15],index = 15,isDefault = false, price = 0, dailyUpkeep = 0, desc = ""}
        }
        
    end
    
    return configurations
end

adjWS = {}   -- adjWS = adjustWorkingSpeed
adjWS.xmls = {}
adjWS.i = 0
if g_configurationManager.configurations["adjustWorkingSpeed"] == nil then
    initNewStoreConfig()
end

function adjWS:update(dt)
    
    if adjWS.miles ~= g_gameSettings.useMiles then
        adjWS.miles = g_gameSettings.useMiles
        
        local ii = 0
        for ii = 1, adjWS.i do
            local storeItem = g_storeManager:getItemByXMLFilename(adjWS.xmls[ii])
            if storeItem ~= nil and storeItem.configurations ~= nil then
                if storeItem.configurations["adjustWorkingSpeed"] ~= nil then
                    
                    local i = 0
                    local speed
                    local milesSpeed
                    local kph = " " .. g_i18n:getText("CONFIG_KPH")
                    local speedLimit = Utils.getNoNil(tonumber(storeItem.specs.speedLimit), 0)
                    for speed = speedLimit - 7, speedLimit + 7 do
                        i = i + 1
                        if i == 8 then
                            if g_gameSettings.useMiles == false then
                                storeItem.configurations["adjustWorkingSpeed"][i].name = math.max(tostring(speed), 1) .. kph .. " " .. g_i18n:getText("CONFIG_STANDARD")
                            else
                                milesSpeed = math.floor(speed / 1.609344)
                                storeItem.configurations["adjustWorkingSpeed"][i].name = math.max(tostring(milesSpeed), 1) .. " mph " .. g_i18n:getText("CONFIG_STANDARD")
                            end
                        else
                            if g_gameSettings.useMiles == false then
                                storeItem.configurations["adjustWorkingSpeed"][i].name = math.max(tostring(speed), 1) .. kph
                            else
                                milesSpeed = math.floor(speed / 0.1609344 - 5) / 10
                                storeItem.configurations["adjustWorkingSpeed"][i].name = math.max(tostring(milesSpeed), 1) .. " mph"
                            end
                        end
                    end
                    
                end
            end
        end
        
    end    
    --renderText(0.2, 0.35, 0.05,tostring(i))
end

if adjWS.active == nil then
	adjWS.active = true
    adjWS.miles = g_gameSettings.useMiles
	addModEventListener(adjWS)
end
