--[[ Cougar 

Author: 		HoFFi (modding-welt.com)


Description: 	- ...

Version: 		1.0.0.0

Changelog: 		2020-06-18 	- initial release
				


--------------------------------------------------------------------------------------------------

XML:
	<Cougar bar1="xxx" icon1="xxx" icon2="xxx" icon3="xxx" icon4="xxx" icon5="xxx"/>
	
Moddesc:
	<specializations>
        <specialization name="Cougar" className="Cougar" filename="Cougar.lua"/>
    </specializations>
	
	<vehicleTypes>
		<type name="newVehicleTypeName" parent="...." filename="$dataS/scripts/vehicles/Vehicle.lua">
			....
			<specialization name="Cougar" />
		</type>
	</vehicleTypes>
	

]]


Cougar = {};

Cougar.modDir = g_currentModDirectory;
Cougar.currentModName = g_currentModName;

print("Claas Cougar by HoFFi loaded - supported by Modding Welt");

function Cougar.prerequisitesPresent(specializations)
    return true; 
end;


function Cougar.registerEventListeners(vehicleType)
	for _, spec in pairs({"onLoad", "onDelete", "onUpdate", "onDraw", "onReadStream", "onWriteStream"}) do
		SpecializationUtil.registerEventListener(vehicleType, spec, Cougar)
	end
end


function Cougar:onLoad(savegame)
	self.Cougar = {};
	self.Cougar.load = 0;
	self.Cougar.bar1 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.Cougar#bar1"), self.i3dMappings);
	self.Cougar.icon1 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.Cougar#icon1"), self.i3dMappings);
	self.Cougar.icon2 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.Cougar#icon2"), self.i3dMappings);
	self.Cougar.icon3 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.Cougar#icon3"), self.i3dMappings);
	self.Cougar.icon4 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.Cougar#icon4"), self.i3dMappings);
	self.Cougar.icon5 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.Cougar#icon5"), self.i3dMappings);
	
	self.Cougar.icon1b = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.Cougar#icon1b"), self.i3dMappings);
	self.Cougar.icon2b = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.Cougar#icon2b"), self.i3dMappings);
	self.Cougar.icon3b = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.Cougar#icon3b"), self.i3dMappings);
	self.Cougar.icon4b = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.Cougar#icon4b"), self.i3dMappings);
	self.Cougar.icon5b = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.Cougar#icon5b"), self.i3dMappings);
end;



function Cougar:onUpdate(dt)
	--check load percentage
	self.Cougar.load = self.spec_mower.workAreaParameters.lastUsedAreasPct;
	if self.Cougar.load >= 0 then
		setScale(self.Cougar.bar1, 1, 1, self.Cougar.load);
	else
		setScale(self.Cougar.bar1, 1, 1, 0);
	end


	--check active
	if self:getIsWorkAreaActive(self:getWorkAreaByIndex(1)) == true then
		setVisibility(self.Cougar.icon1, true);
	else
		setVisibility(self.Cougar.icon1, false);
	end
	
	if self:getIsWorkAreaActive(self:getWorkAreaByIndex(2)) == true then
		setVisibility(self.Cougar.icon2, true);
	else
		setVisibility(self.Cougar.icon2, false);
	end
	
	if self:getIsWorkAreaActive(self:getWorkAreaByIndex(3)) == true then
		setVisibility(self.Cougar.icon3, true);
	else
		setVisibility(self.Cougar.icon3, false);
	end
	
	if self:getIsWorkAreaActive(self:getWorkAreaByIndex(4)) == true then
		setVisibility(self.Cougar.icon4, true);
	else
		setVisibility(self.Cougar.icon4, false);
	end
	
	if self:getIsWorkAreaActive(self:getWorkAreaByIndex(5)) == true then
		setVisibility(self.Cougar.icon5, true);
	else
		setVisibility(self.Cougar.icon5, false);
	end
	
	-- check processing
	if self:getIsWorkAreaProcessing(self:getWorkAreaByIndex(1)) == true then
		setVisibility(self.Cougar.icon1b, true);
	else
		setVisibility(self.Cougar.icon1b, false);
	end
	
	if self:getIsWorkAreaProcessing(self:getWorkAreaByIndex(2)) == true then
		setVisibility(self.Cougar.icon2b, true);
	else
		setVisibility(self.Cougar.icon2b, false);
	end
	
	if self:getIsWorkAreaProcessing(self:getWorkAreaByIndex(3)) == true then
		setVisibility(self.Cougar.icon3b, true);
	else
		setVisibility(self.Cougar.icon3b, false);
	end
	
	if self:getIsWorkAreaProcessing(self:getWorkAreaByIndex(4)) == true then
		setVisibility(self.Cougar.icon4b, true);
	else
		setVisibility(self.Cougar.icon4b, false);
	end
	
	if self:getIsWorkAreaProcessing(self:getWorkAreaByIndex(5)) == true then
		setVisibility(self.Cougar.icon5b, true);
	else
		setVisibility(self.Cougar.icon5b, false);
	end
end;

function Cougar:onDelete()
end;

function Cougar:onReadStream(streamId, connection)
end;

function Cougar:onWriteStream(streamId, connection)
end;

function Cougar:onDraw(isActiveForInput, isSelected)
end