--[[ screenFunctions 

Author: 		Dj Antonis

Description: 	script for various tractor onboard monitor informations

Version: 		1.0.0.0

Changelog: 		06/02/2020 	- initial release
				

]]


screenFunctions = {};

screenFunctions.modDir = g_currentModDirectory;
screenFunctions.currentModName = g_currentModName;

function screenFunctions.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations); 
end;

function screenFunctions.registerEventListeners(vehicleType)
	for _, spec in pairs({"onLoad", "onUpdate"}) do
		SpecializationUtil.registerEventListener(vehicleType, spec, screenFunctions)
	end
end

function screenFunctions:onLoad(savegame)
	
	self.currentVoltage = 24.8
	self.batvolt = VehicleHudUtils.loadHud(self, self.xmlFile, "batteryVolt");
	self.loadprc = VehicleHudUtils.loadHud(self, self.xmlFile, "loadPercent");
	self.slipprc = VehicleHudUtils.loadHud(self, self.xmlFile, "slipPercent");
	
end;


function screenFunctions:onUpdate(dt)

    
	local spec = self.spec_motorized
	local loadPercentage = spec.motor:getMotorAppliedTorque() / math.max(spec.motor:getMotorAvailableTorque(), 0.0001)
       spec.actualLoadPercentage = loadPercentage
        if spec.actualLoadPercentage > spec.smoothedLoadPercentage then
            spec.smoothedLoadPercentage = 0.95*spec.smoothedLoadPercentage + 0.05*loadPercentage
        else
            spec.smoothedLoadPercentage = 0.98*spec.smoothedLoadPercentage + 0.02*loadPercentage
        end
		if self:getIsMotorStarted() then
          if self.loadprc ~= nil then
		    if spec.smoothedLoadPercentage ~= nil then
					
			VehicleHudUtils.setHudValue(self, self.loadprc, spec.smoothedLoadPercentage * 106, 100); 
				end;
			end;
		end; 
	local currentVoltage = self.currentVoltage + (spec.motor:getLastMotorRpm() - spec.motor:getMinRpm()) / (spec.motor:getMaxRpm() - spec.motor:getMinRpm())
	   spec.batteryVolt = currentVoltage
	 	if self:getIsMotorStarted() then
            if self.batvolt ~= nil then
				if spec.batteryVolt ~= nil then
					
					VehicleHudUtils.setHudValue(self, self.batvolt, spec.batteryVolt, 100); 
				end;
			end;
		end; 
	local UseGUI = true;
	    if g_client and UseGUI then
		-- Check number of vehicles
		numVehicles = table.getn(g_currentMission.vehicles);
		-- If vehicles present run code
		if numVehicles ~= nil then
			-- Run code for vehicles
			if numVehicles >= 1 then
				-- Search for controlled vehicle
				for VehicleIndex=1, numVehicles do
		local vehicle = g_currentMission.vehicles[VehicleIndex];
		if vehicle ~= nil then
	    	if vehicle.spec_motorized then
			    if vehicle.spec_wheels ~= nil then	
					if vehicle:getIsControlled() then
						if g_currentMission.controlledVehicle == vehicle then
		               if self:getIsMotorStarted() then
                     if self.slipprc ~= nil then
				   if vehicle.GUISlip ~= nil then
					VehicleHudUtils.setHudValue(self, self.slipprc, vehicle.GUISlip , 100); 
	     			       end;
		    	        end;
		             end; 				
     		       end;
				 end;
			   end;
		   	  end;
			 end;
           end;
		  end;
		 end;
	    end;
					
end