-- Version from @[Team LTW] kingkalle in the official Giants Forums
-- https://forum.giants-software.com/viewtopic.php?f=884&t=103797&start=90#p1083352
-- also other people that have contributed to making this script work in Fs19 @elky and probably others
-- THANKS!
 
ModMap = {}
local ModMap_mt = Class(ModMap, Mission00)
 
function ModMap:new(baseDirectory, customMt, missionCollaborators)
    local mt = customMt
    if mt == nil then
        mt = ModMap_mt
    end
    local self = ModMap:superClass():new(baseDirectory, mt, missionCollaborators)
 
    -- Number of additional channels that are used compared to the original setting (2)
    local numAdditionalAngleChannels = 2;
 
    self.terrainDetailAngleNumChannels = self.terrainDetailAngleNumChannels + numAdditionalAngleChannels;
    self.terrainDetailAngleMaxValue = (2^self.terrainDetailAngleNumChannels) - 1;
 
    self.sprayLevelFirstChannel = self.sprayLevelFirstChannel + numAdditionalAngleChannels;
 
    self.plowCounterFirstChannel = self.plowCounterFirstChannel + numAdditionalAngleChannels;
    self.limeCounterFirstChannel = self.limeCounterFirstChannel + numAdditionalAngleChannels;
 
    return self
end

function ModMap:load()
   ModMap:superClass().load(self);
   if (not self.missionInfo.isValid) and (not self.missionDynamicInfo.isMultiplayer) then
      local modDesc = loadXMLFile("modDesc", self.baseDirectory .. "modDesc.xml");
      local key = "modDesc.maps.map#defaultSingleplayerItemsXMLFilename"
      if not hasXMLProperty(modDesc, key) then
         print("ERROR : xmlKey 'defaultSingleplayerItemsXMLFilename' in modDesc not found! ")
         return;
      end;
      self.missionInfo.itemsXMLLoad  = Utils.getFilename(getXMLString(modDesc, key), self.baseDirectory);
   end;
end;