--[[ fruitTypeParts 

Author: 		HoFFi (modding-welt.com)


Description: 	- script to disable threshing other fruits than canola if rape seed knifes are activated
				- when threshing canola without knifes, you get less yield
				- script must be added to cutter

Version: 		1.0.0.0

Changelog: 		2019-08-29 	- initial release
				2019-09-05  - bug fixing and improvement
				


--------------------------------------------------------------------------------------------------

XML:
	<fruitTypeParts sideKnivesNode="rapsMesserNode" threshingLossPercentage="10"/>
	
Moddesc:
	<specializations>
        <specialization name="fruitTypeParts" className="fruitTypeParts" filename="fruitTypeParts.lua"/>
    </specializations>
	
	<vehicleTypes>
		<type name="newVehicleTypeName" parent="...." filename="$dataS/scripts/vehicles/Vehicle.lua">
			....
			<specialization name="fruitTypeParts" />
		</type>
	</vehicleTypes>

	<l10n>
		<text name="FTPcanolaWarning"><en>This cutter is configured for canola ONLY!</en><de>Dieses Schneidwerk ist NUR für RAPS konfiguriert!</de></text>
		<text name="FTPloss"><en>Loss</en><de>Verlust</de></text>
		<text name="FTPknifesON"><en>knifes equipted</en><de>Rapsmesser aktiv</de></text>
		<text name="FTPknifesOFF"><en>knifes not equipted</en><de>Rapsmesser inaktiv</de></text>
	</l10n>
]]


fruitTypeParts = {};

fruitTypeParts.modDir = g_currentModDirectory;
fruitTypeParts.currentModName = g_currentModName;

function fruitTypeParts.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations); 
end;


function fruitTypeParts.registerEventListeners(vehicleType)
	for _, spec in pairs({"onLoad", "onDelete", "onUpdate", "onDraw", "onReadStream", "onWriteStream"}) do
		SpecializationUtil.registerEventListener(vehicleType, spec, fruitTypeParts)
	end
end


function fruitTypeParts:onLoad(savegame)
	self.sideKnivesNode = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.fruitTypeParts#sideKnivesNode"), self.i3dMappings);
	self.threshingLossPercentage = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.fruitTypeParts#threshingLossPercentage"), 10);
	
	self.lastFT = 0
end;



function fruitTypeParts:onUpdate()
	local spec = self.spec_cutter
	local attacherVehicle = self:getAttacherVehicle()
	self.lastFT = spec.lastValidInputFruitType

	if self.sideKnivesNode ~= nil then
		if getVisibility(self.sideKnivesNode) then
			if self.lastFT == FillType.BARLEY or self.lastFT == FillType.COTTON or self.lastFT == FillType.DRYGRASS or self.lastFT == FillType.GRASS or self.lastFT == FillType.GRASSWINDROW or self.lastFT == FillType.MAIZE or self.lastFT == FillType.OAT or self.lastFT == FillType.POPPLAR or self.lastFT == FillType.POTATO or self.lastFT == FillType.STRAW or self.lastFT == FillType.SUGARBEET or self.lastFT == FillType.SUGARCANE or self.lastFT == FillType.SUNFLOWER or self.lastFT == FillType.WHEAT then
				self:setIsTurnedOn(false, true)
				if self:getIsAIActive() ~= true then
					g_currentMission:showBlinkingWarning(g_i18n:getText("FTPcanolaWarning"), 2000)
				end
			end
		else
			if self.lastFT == FillType.CANOLA then
				if attacherVehicle ~= nil then
                    attacherVehicle.spec_combine.threshingScale = 1 - (self.threshingLossPercentage / 100)
                end
			else
				if attacherVehicle ~= nil then
                    attacherVehicle.spec_combine.threshingScale = 1
                end
			end
		end
	else
		if attacherVehicle ~= nil then
            attacherVehicle.spec_combine.threshingScale = 1
        end
	end
end;

function fruitTypeParts:onDelete()
end;

function fruitTypeParts:onReadStream(streamId, connection)
end;

function fruitTypeParts:onWriteStream(streamId, connection)
end;

function fruitTypeParts:onDraw(isActiveForInput, isSelected)
	if self.isClient then
		if isSelected then
				if self:getAttacherVehicle() ~= nil then
					local attacherVehicle = self:getAttacherVehicle()
					text2 = (1 - attacherVehicle.spec_combine.threshingScale) * 100
				else
					text2 = " "
				end
				
				if self.lastFT ~= 0 then
					local fruitType1 = g_fruitTypeManager:getFruitTypeByIndex(self.lastFT)
					text1 = fruitType1.fillType.title
				else
					text1 = " - "
				end
				
				if getVisibility(self.sideKnivesNode) then
					text3 = g_i18n:getText("FTPknifesON")
				else
					text3 = g_i18n:getText("FTPknifesOFF")
				end
				g_currentMission:addExtraPrintText(g_i18n:getText("statistic_fillType") .. ": " .. text1 .. " | " .. g_i18n:getText("FTPloss") .. ": " .. text2 .. "% | " .. text3)
		end
	end
end