--[[ threshingFlowIndicator 

Author: 		HoFFi (modding-welt.com)

Description: 	script to visualize the current threshing flow

Version: 		1.0.1.0

Changelog: 		2019-08-08 - initial release
				2019-08-12 - added more complex way of showing the current load (indicator bar with 13 lights)

--------------------------------------------------------------------------------------------------

XML:
	<threshingFlowIndicator indicatorBarNode="name of bar in i3d" showInHud="false" lightsRootNode="lightsOn">
		<lights light1="greenstarON01" light2="greenstarON02" light3="greenstarON03" light4="greenstarON04" light5="greenstarON05" light6="greenstarON06" light7="greenstarON07" light8="greenstarON08" light9="greenstarON09" light10="greenstarON10" light11="greenstarON11" light12="greenstarON12" light13="greenstarON13" />
	</threshingFlowIndicator>
	
Moddesc:
	<specializations>
        <specialization name="threshingFlowIndicator" className="threshingFlowIndicator" filename="threshingFlowIndicator.lua"/>
    </specializations>
	
	<vehicleTypes>
		<type name="newVehicleTypeName" parent="baseDrivable" filename="$dataS/scripts/vehicles/Vehicle.lua">
			....
			<specialization name="threshingFlowIndicator" />
		</type>
	</vehicleTypes>
	
	<l10n>
		<text name="Auslastung"><en>Load (cutter):</en><de>Auslastung (Schneidwerk):</de></text>
	</l10n>
	
Explaination:
	indicatorBarNode = visual object (bar) to be scaled
	showInHud = if true, current flow will be displayed in hud (left upper corner)
	lightsRootNode = parent object of light objects 

]]


threshingFlowIndicator = {};

threshingFlowIndicator.modDir = g_currentModDirectory;
threshingFlowIndicator.currentModName = g_currentModName;

function threshingFlowIndicator.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Combine, specializations); 
end;

function threshingFlowIndicator.registerEventListeners(vehicleType)
	for _, spec in pairs({"onLoad", "onDelete", "onUpdate", "onDraw", "onReadStream", "onWriteStream"}) do
		SpecializationUtil.registerEventListener(vehicleType, spec, threshingFlowIndicator)
	end
end

function threshingFlowIndicator:onLoad(savegame)
	self.indicatorBarNode = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.threshingFlowIndicator#indicatorBarNode"), self.i3dMappings);
	self.lightsRootNode = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.threshingFlowIndicator#lightsRootNode"), self.i3dMappings);
	self.showInHud = getXMLBool(self.xmlFile, "vehicle.threshingFlowIndicator#showInHud");
	self.currentFlow = 0
	
	self.light1 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.threshingFlowIndicator.lights#light1"), self.i3dMappings);
	self.light2 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.threshingFlowIndicator.lights#light2"), self.i3dMappings);
	self.light3 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.threshingFlowIndicator.lights#light3"), self.i3dMappings);
	self.light4 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.threshingFlowIndicator.lights#light4"), self.i3dMappings);
	self.light5 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.threshingFlowIndicator.lights#light5"), self.i3dMappings);
	self.light6 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.threshingFlowIndicator.lights#light6"), self.i3dMappings);
	self.light7 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.threshingFlowIndicator.lights#light7"), self.i3dMappings);
	self.light8 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.threshingFlowIndicator.lights#light8"), self.i3dMappings);
	self.light9 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.threshingFlowIndicator.lights#light9"), self.i3dMappings);
	self.light10 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.threshingFlowIndicator.lights#light10"), self.i3dMappings);
	self.light11 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.threshingFlowIndicator.lights#light11"), self.i3dMappings);
	self.light12 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.threshingFlowIndicator.lights#light12"), self.i3dMappings);
	self.light13 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.threshingFlowIndicator.lights#light13"), self.i3dMappings);
end;


function threshingFlowIndicator:onUpdate(dt)
	local lightsAmount = getNumOfChildren(self.lightsRootNode)

	local spec = self.spec_combine
    if spec ~= nil then
		setVisibility(self.light1, false);
		setVisibility(self.light2, false);
		setVisibility(self.light3, false);
		setVisibility(self.light4, false);
		setVisibility(self.light5, false);
		setVisibility(self.light6, false);
		setVisibility(self.light7, false);
		setVisibility(self.light8, false);
		setVisibility(self.light9, false);
		setVisibility(self.light10, false);
		setVisibility(self.light11, false);
		setVisibility(self.light12, false);
		setVisibility(self.light13, false);
		setScale(self.indicatorBarNode, 1, 1, 0);
        if spec.numAttachedCutters > 0 then
            for cutter, _ in pairs(spec.attachedCutters) do
                if cutter.getCutterLoad ~= nil then
					self.currentFlow = cutter:getCutterLoad()
						setScale(self.indicatorBarNode, 1, 1, self.currentFlow);
					
						if self.currentFlow > (1 / lightsAmount) * 1 then
							setVisibility(self.light1, true);
						end
						if self.currentFlow >= (1 / lightsAmount) * 2 then
							setVisibility(self.light2, true);
						end
						if self.currentFlow >= (1 / lightsAmount) * 3 then
							setVisibility(self.light3, true);
						end
						if self.currentFlow >= (1 / lightsAmount) * 4 then
							setVisibility(self.light4, true);
						end
						if self.currentFlow >= (1 / lightsAmount) * 5 then
							setVisibility(self.light5, true);
						end
						if self.currentFlow >= (1 / lightsAmount) * 6 then
							setVisibility(self.light6, true);
						end
						if self.currentFlow >= (1 / lightsAmount) * 7 then
							setVisibility(self.light7, true);
						end
						if self.currentFlow >= (1 / lightsAmount) * 8 then
							setVisibility(self.light8, true);
						end
						if self.currentFlow >= (1 / lightsAmount) * 9 then
							setVisibility(self.light9, true);
						end
						if self.currentFlow >= (1 / lightsAmount) * 10 then
							setVisibility(self.light10, true);
						end
						if self.currentFlow >= (1 / lightsAmount) * 11 then
							setVisibility(self.light11, true);
						end
						if self.currentFlow >= (1 / lightsAmount) * 12 then
							setVisibility(self.light12, true);
						end
						if self.currentFlow >= (1 / lightsAmount) * 12.5 then
							setVisibility(self.light13, true);
						end
                end
            end
        end
    end

	
	
end;

function threshingFlowIndicator:onDelete()
end;

function threshingFlowIndicator:onReadStream(streamId, connection)
end;

function threshingFlowIndicator:onWriteStream(streamId, connection)
end;

function threshingFlowIndicator:onDraw(isActiveForInput, isSelected)
	if self.isClient then
		if isSelected then
			if self.showInHud then
				g_currentMission:addExtraPrintText(g_i18n:getText("Auslastung").." " .. MathUtil.round(self.currentFlow*100, 1) .. "%")
			end
		end
	end
end