--[[
CultivatorTurnedOnRotationNodes

Author:	Ifko[nator]
Datum:	06.08.2017

Version:	v1.0
History:	v1.0 - initial implementation in FS17
]]

CultivatorTurnedOnRotationNodes = {};
	
function CultivatorTurnedOnRotationNodes.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Cultivator, specializations);
end;

function CultivatorTurnedOnRotationNodes:load(savegame)
	self.cultivatorTurnedOnRotationNodes = Utils.loadRotationNodes(self.xmlFile, {}, "vehicle.turnedOnRotationNodes.turnedOnRotationNode", "cultivator", self.components); 
	
	if self.isClient then
		self.sampleMulcher = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.mulcherSound", nil, self.baseDirectory);
	end;
end;

function CultivatorTurnedOnRotationNodes:update(dt)
	if self.isClient then
        Utils.updateRotationNodes(self, self.cultivatorTurnedOnRotationNodes, dt, self:getIsActive() and self:getIsTurnedOn());
	end;
end;

function CultivatorTurnedOnRotationNodes:updateTick(dt)
	if self.isClient then	
		if self:getIsActive() and self:getIsTurnedOn() then
            if self:getIsActiveForSound() then
               SoundUtil.playSample(self.sampleMulcher, 0, 0, nil);
            end;
        else
			SoundUtil.stopSample(self.sampleMulcher);
        end;
	end;
end;

function CultivatorTurnedOnRotationNodes:delete()
    if self.isClient then
        SoundUtil.deleteSample(self.sampleMulcher);
    end;
end;

function CultivatorTurnedOnRotationNodes:onDeactivateSounds()
    if self.isClient then
        SoundUtil.stopSample(self.sampleMulcher, true);
    end;
end;

--## unused but needed functions

function CultivatorTurnedOnRotationNodes:mouseEvent(posX, posY, isDown, isUp, button)end;
function CultivatorTurnedOnRotationNodes:keyEvent(unicode, sym, modifier, isDown)end;
function CultivatorTurnedOnRotationNodes:draw()end;