-- 
-- OverloadPipe 
-- 
-- @Interface: 1.4.4.0 1.4.4RC8
-- @Author: kevink98 /  MilchTrigger(LS15):Marhu
-- @Date: 29.09.2017
-- @Version: 1.2.0
-- 
-- @Support: http://ls-modcompany.com
-- @mCompanyInfo: http://mcompany-info.de/
-- 

OverloadPipe = {};
OverloadPipe.Dir = g_currentModDirectory;

function OverloadPipe.prerequisitesPresent(specializations)
    return true
end;

function OverloadPipe:load(savegame)	
	self.UpdateOverloadPipe = SpecializationUtil.callSpecializationsFunction("UpdateOverloadPipe");
	self.setOverloadPipe = SpecializationUtil.callSpecializationsFunction("setOverloadPipe");
	self.setTrigger = SpecializationUtil.callSpecializationsFunction("setTrigger");
	
	local OverloadPipe = getXMLString(self.xmlFile, "vehicle.OverloadPipe#index");
	if OverloadPipe ~= nil then
		self.OverloadPipe = {}
		self.OverloadPipe.node0 = Utils.indexToObject(self.components,OverloadPipe)
		self.OverloadPipe.node1 = getChildAt(self.OverloadPipe.node0,0)
		self.OverloadPipe.node2 = getChildAt(self.OverloadPipe.node1,0)
		local _,_,baseDistance = getTranslation(self.OverloadPipe.node2);
		self.OverloadPipe.pose = {getTranslation(self.OverloadPipe.node0)};
		self.OverloadPipe.rot = {getRotation(self.OverloadPipe.node0)};
		self.OverloadPipe.baseDistance = baseDistance;
		self.OverloadPipe.attacher = {}
		local i = 0;
		while true do
			local key = string.format("vehicle.OverloadPipe.attacher(%d)", i);
			if not hasXMLProperty(self.xmlFile, key) then
				break;
			end;
			local attacher = Utils.indexToObject(self.components,getXMLString(self.xmlFile, key .. "#index"))
			table.insert(self.OverloadPipe.attacher,attacher)
			i = i + 1
		end;	
	end;	
	self.fillOverloadPipe = false;
end;


function OverloadPipe:update(dt)
	if self.isClient then	
		if self.isFilling then
			self:UpdateOverloadPipe(true);
		else
			self:UpdateOverloadPipe(false);
		end;
	end;
end;

function OverloadPipe:getSaveAttributesAndNodes(nodeIdent)	
	return "","";
end

function OverloadPipe:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	return BaseMission.VEHICLE_LOAD_OK;
end

function OverloadPipe:setTrigger(triggerId)
	if self.triggerId == nil then
		self.triggerId = triggerId;
	end;
end;

function OverloadPipe:UpdateOverloadPipe(vis)
	if self.OverloadPipe then
		if vis and self.triggerId ~= nil then
			local parent = getParent(self.triggerId)
			local attacher = parent ~= nil and getChild(parent,"OverloadPipe") or 0;
			if attacher ~= 0 then
				local minDist = math.huge;
				local site
				local xa,ya,za = getWorldTranslation(attacher);
				for i = 1, table.getn(self.OverloadPipe.attacher) do
					local x1, y1, z1 = getWorldTranslation(self.OverloadPipe.attacher[i])
					dist = Utils.vector3Length(xa-x1, ya-y1, za-z1);
					if dist < minDist then
						minDist = dist
						site = self.OverloadPipe.attacher[i]
					end
				end
				local x,y,z = getTranslation(site)
				local rx,ry,rz = getRotation(site)
				setTranslation(self.OverloadPipe.node0,x,y,z)
				setRotation(self.OverloadPipe.node0,rx,ry,rz)
				local dx,dy,dz = worldToLocal(self.OverloadPipe.node0, xa,ya,za);
				setDirection(self.OverloadPipe.node1, dx, dy, dz, 0, 1, 0);
				if not self.OverloadPipe.attach then
					link(attacher,self.OverloadPipe.node2)
					setTranslation(self.OverloadPipe.node2, 0,0,0);
				end
				self.OverloadPipe.attach = true
			end;
		elseif self.OverloadPipe.attach then
			setTranslation(self.OverloadPipe.node0,unpack(self.OverloadPipe.pose))
			setRotation(self.OverloadPipe.node0,unpack(self.OverloadPipe.rot))
			setRotation(self.OverloadPipe.node1,0,0,0)
			link(self.OverloadPipe.node1,self.OverloadPipe.node2)
			setTranslation(self.OverloadPipe.node2, 0,0,self.OverloadPipe.baseDistance);
			setRotation(self.OverloadPipe.node2,0,0,0)
			self.OverloadPipe.attach = nil;
			self.triggerId = nil;
		end;
	end;
end;

function OverloadPipe:setOverloadPipe(triggerId)
	local parent = getParent(triggerId)
	local attacher = parent ~= nil and getChild(parent,"OverloadPipe") or 0;
	if attacher ~= 0 then
		local minDist = math.huge;
		local site
		local xa,ya,za = getWorldTranslation(attacher);
		for i = 1, table.getn(self.OverloadPipe.attacher) do
			local x1, y1, z1 = getWorldTranslation(self.OverloadPipe.attacher[i])
			dist = Utils.vector3Length(xa-x1, ya-y1, za-z1);
			if dist < minDist then
				minDist = dist
				site = self.OverloadPipe.attacher[i]
			end
		end
		local x,y,z = getTranslation(site)
		local rx,ry,rz = getRotation(site)
		setTranslation(self.OverloadPipe.node0,x,y,z)
		setRotation(self.OverloadPipe.node0,rx,ry,rz)
		local dx,dy,dz = worldToLocal(self.OverloadPipe.node0, xa,ya,za);
		setDirection(self.OverloadPipe.node1, dx, dy, dz, 0, 1, 0);
		if not self.OverloadPipe.attach then
			link(attacher,self.OverloadPipe.node2)
			setTranslation(self.OverloadPipe.node2, 0,0,0);
		end
		self.OverloadPipe.attach = true
	end;
end;

function OverloadPipe:updateTick(dt) end;
function OverloadPipe:readStream(streamId, connection) end;
function OverloadPipe:writeStream(streamId, connection) end;
function OverloadPipe:readUpdateStream(streamId, timestamp, connection) end;
function OverloadPipe:writeUpdateStream(streamId, connection, dirtyMask) end;
function OverloadPipe:draw() end;
function OverloadPipe:onAttach() end; 
function OverloadPipe:onDetach() end;
function OverloadPipe:onLeave() end;
function OverloadPipe:setFilling(isFill, noEventSend) end;
function OverloadPipe:mouseEvent(posX, posY, isDown, isUp, button) end;
function OverloadPipe:keyEvent(unicode, sym, modifier, isDown) end;
function OverloadPipe:delete() end;