--[[
Interface: 1.5.1.0 b1580

Copyright (C) GtX (Andy), 2017

Author: GtX | Andy
Date: 21.06.2017

Support only at: https://ls-modcompany.com

History:
V 1.0.0.0 @ 21.06.2017 - Project Started.
V 1.1.0.0 @ 13/07/2017 - Improved functions added after testing.
v 1.2.0.0 @ 28/04/2018 - Script optimization, script can now be used with no animations if needed.
						 Added new trigger marker function for fuel and service functions.
						 repairVehicles by Rival is now supported.
						 
v 1.2.0.1 @ 26/05/2018 - Fix problem causing flickering F1 menu when using repairVehicles by Rival.

Important:
Free for use in other mods - no permission needed.
No changes are to be made to this script without permission from GtX @ https://ls-modcompany.com
]]

ServiceTrailer = {}

function ServiceTrailer.prerequisitesPresent(specializations)
    return true
end

function ServiceTrailer:load(savegame)
	self.setIsFuelTurnedOn = ServiceTrailer.setIsFuelTurnedOn
    self.getIsFuelTurnedOn = ServiceTrailer.getIsFuelTurnedOn
    self.onFuelTurnedOn = SpecializationUtil.callSpecializationsFunction("onFuelTurnedOn")
    self.onFuelTurnedOff = SpecializationUtil.callSpecializationsFunction("onFuelTurnedOff")

	self.triggerCallback = VehicleSellingPoint.triggerCallback
	self.sellAreaTriggerCallback = VehicleSellingPoint.sellAreaTriggerCallback
	self.determineCurrentVehicle = VehicleSellingPoint.determineCurrentVehicle
	self.onActivateObject = VehicleSellingPoint.onActivateObject
	self.getIsActivatable = VehicleSellingPoint.getIsActivatable
	self.drawActivate = VehicleSellingPoint.drawActivate

	self.setServiceAnimation = ServiceTrailer.setServiceAnimation
	self.setShowMarkers = ServiceTrailer.setShowMarkers
	self.playerServiceTrigger = SpecializationUtil.callSpecializationsFunction("playerServiceTrigger")
	self.playerFuelTrigger = SpecializationUtil.callSpecializationsFunction("playerFuelTrigger")
	self.isTankFilled = ServiceTrailer.isTankFilled
	self.setMarkerColour = ServiceTrailer.setMarkerColour

	if self.isClient then
		self.serviceGroup = {}
		self.serviceGroup.sellTriggerId = Utils.indexToObject(self.components, getXMLString(self.xmlFile,"vehicle.serviceTrailer.service#playerTriggerIndex"))
		self.serviceGroup.sellAreaTriggerId = Utils.indexToObject(self.components, getXMLString(self.xmlFile,"vehicle.serviceTrailer.service#vehicleTriggerIndex"))
		self.serviceGroup.renderText = Utils.getNoNil(getXMLBool(self.xmlFile, "vehicle.serviceTrailer#renderScreenText"), false)
		self.activateText = g_i18n:getText("action_activateServiceMenu")

		addTrigger(self.serviceGroup.sellTriggerId, "triggerCallback", self)
		addTrigger(self.serviceGroup.sellAreaTriggerId, "sellAreaTriggerCallback", self)

		self.vehicleInRange = {}
		self.currentVehicle = nil
		self.currentVehicleId = 0

		self.ownWorkshop = true
		self.isEnabled = true
		self.objectActivated = false
		self.showServiceMarkers = true
		self.showFuelMarkers = true

		if savegame ~= nil then
			local showServiceMarkers = Utils.getNoNil(getXMLBool(savegame.xmlFile, savegame.key.."#showServiceMarkers"), self.showServiceMarkers)
			self:setShowMarkers(showServiceMarkers, true, true)

			local showFuelMarkers = Utils.getNoNil(getXMLBool(savegame.xmlFile, savegame.key.."#showFuelMarkers"), self.showFuelMarkers)
			self:setShowMarkers(showFuelMarkers, false, true)
		end

		if SpecializationUtil.hasSpecialization(AnimatedVehicle, self.specializations) then

			if hasXMLProperty(self.xmlFile, "vehicle.serviceTrailer.serviceAnim") then
				self.animService = {}
				self.animService.playerTriggerId = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.serviceTrailer.serviceAnim#triggerIndex"))
				self.animService.animationName = getXMLString(self.xmlFile, "vehicle.serviceTrailer.serviceAnim#animationName")

				addTrigger(self.animService.playerTriggerId, "playerServiceTrigger", self )
				self.animService.player = false
				self.serviceAnimActive = false
				self.vehicleServiceName = nil

				local markers = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.serviceTrailer.serviceAnim#markers"))
				if markers ~= nil then
					self.animService.markergroupNode = markers
					setVisibility(markers, false)
					self.serviceUseShader = Utils.getNoNil(getXMLBool(self.xmlFile, "vehicle.serviceTrailer.serviceAnim#useEmissiveFalloffShader"), false)
					self.currentServiceVehicle = ""
					self.animService.markerGroup = {}
					local count = getNumOfChildren(markers)
					if count > 0 then
						for i = 1, count do
							local marker = getChildAt(markers, i-1)
							table.insert(self.animService.markerGroup, marker)
						end
					end
				end
			end

			if SpecializationUtil.hasSpecialization(FuelTrailer, self.specializations) then
				if hasXMLProperty(self.xmlFile, "vehicle.serviceTrailer.operateFuel") then
					self.operateFuel = {}
					self.operateFuel.playerTriggerId = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.serviceTrailer.operateFuel#triggerIndex"))
					addTrigger(self.operateFuel.playerTriggerId, "playerFuelTrigger", self )
					self.operateFuel.isTurnedOn = false
					self.operateFuel.player = false

					self.operateFuel.rotationNodes = Utils.loadRotationNodes(self.xmlFile, {}, "vehicle.turnedOnRotationNodes.turnedOnRotationNode", "fuelPump", self.components)

					self.operateFuel.sampleMotorRun = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.serviceTrailer.runSound", nil, self.baseDirectory, self.components[1].node)

					self.operateFuel.runPS = {}
					Utils.loadParticleSystem(self.xmlFile, self.operateFuel.runPS, "vehicle.serviceTrailer.exhaust", self.components, false, nil, self.baseDirectory)

					local turnOnAnimation = getXMLString(self.xmlFile, "vehicle.serviceTrailer.operateFuel#animationName")
					if turnOnAnimation ~= nil then
						self.operateFuel.turnOnAnimation = {}
						self.operateFuel.turnOnAnimation.name = turnOnAnimation
						self.operateFuel.turnOnAnimation.turnOnSpeedScale = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.serviceTrailer.operateFuel#animationTurnOnSpeedScale"), 1)
						self.operateFuel.turnOnAnimation.turnOffSpeedScale = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.serviceTrailer.operateFuel#animationTurnOffSpeedScale"), -self.operateFuel.turnOnAnimation.turnOnSpeedScale)
					end

					local markers = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.serviceTrailer.operateFuel#markers"))
					if markers ~= nil then
						self.operateFuel.markergroupNode = markers
						setVisibility(markers, false)
						self.fuelUseShader = Utils.getNoNil(getXMLBool(self.xmlFile, "vehicle.serviceTrailer.operateFuel#useEmissiveFalloffShader"), false)
						self.currentFuelVehicle = true
						self.operateFuel.markerGroup = {}
						local count = getNumOfChildren(markers)
						if count > 0 then
							for i = 1, count do
								local marker = getChildAt(markers, i-1)
								table.insert(self.operateFuel.markerGroup, marker)
							end
						end
					end
				end
			end
		end
    end
end

function ServiceTrailer:getSaveAttributesAndNodes(nodeIdent)
	local attributes = ""
	local nodes = ""

	if self.animService ~= nil then
		if self.animService.markerGroup ~= nil then
			attributes = attributes..' showServiceMarkers="'..tostring(self.showServiceMarkers)..'"'
		end
	end

	if self.operateFuel ~= nil then
		if self.operateFuel.markerGroup ~= nil then
			attributes = attributes..' showFuelMarkers="'..tostring(self.showFuelMarkers)..'"'
		end
	end

    return attributes, nodes
end

function ServiceTrailer:readStream(streamId, connection)
	if self.animService ~= nil then
		local serviceState = streamReadBool(streamId)
		self:setServiceAnimation(serviceState, true)

		if self.animService.markerGroup ~= nil then
			local markerState = streamReadBool(streamId)
			self:setShowMarkers(markerState, true, true)
		end
	end
	if self.operateFuel ~= nil then
		local fuelState = streamReadBool(streamId)
		self:setIsFuelTurnedOn(fuelState, true)

		if self.operateFuel.markerGroup ~= nil then
			local markerState = streamReadBool(streamId)
			self:setShowMarkers(markerState, false, true)
		end
	end
end

function ServiceTrailer:writeStream(streamId, connection)
	if self.animService ~= nil then
		local serviceState = self.serviceAnimActive
		streamWriteBool(streamId, serviceState)

		if self.animService.markerGroup ~= nil then
			local markerState = self.showServiceMarkers
			streamWriteBool(streamId, markerState)
		end
	end
	if self.operateFuel ~= nil then
		local fuelState = self.operateFuel.isTurnedOn
		streamWriteBool(streamId, fuelState)

		if self.operateFuel.markerGroup ~= nil then
			local markerState = self.showFuelMarkers
			streamWriteBool(streamId, markerState)
		end
	end
end

function ServiceTrailer:delete()
	if g_currentMission:getIsClient() then
		removeTrigger(self.serviceGroup.sellTriggerId)
		removeTrigger(self.serviceGroup.sellAreaTriggerId)

		if self.animService ~= nil then
			removeTrigger(self.animService.playerTriggerId)
		end

		if self.operateFuel ~= nil then
			removeTrigger(self.operateFuel.playerTriggerId)
			if self.operateFuel.sampleMotorRun ~= nil then
				SoundUtil.deleteSample(self.operateFuel.sampleMotorRun)
			end
			if self.operateFuel.runPS ~= nil then
				Utils.deleteParticleSystem(self.operateFuel.runPS)
			end
		end
    end
end

function ServiceTrailer:updateTick(dt)
	-- This is not perfect but the only way to try and work with repairVehicles.lua is reset in each cycle.
	if self.currentVehicle ~= nil and self.currentVehicle.repairVehicle ~= nil then
		if self.currentVehicle.vehicleNode ~= nil then
			self.currentVehicle.vehicleNode = nil
		end
		self.currentVehicle.rvWIR = true
	end
end

function ServiceTrailer:update(dt)
	if self.isClient then
		if self.animService ~= nil then
			if self.animService.markerGroup ~= nil then
				if self.serviceAnimActive then
					local animationTimeS = self:getAnimationTime(self.animService.animationName)
					if animationTimeS == 1 then
						if self.animService.markerGroup ~= nil then
							if self.showServiceMarkers then
								if not getVisibility(self.animService.markergroupNode) then
									setVisibility(self.animService.markergroupNode, true)
								end
								if self.serviceUseShader then
									if self.currentServiceVehicle ~= self.currentVehicle then
										self.currentServiceVehicle = self.currentVehicle
										self:setMarkerColour(self.animService.markerGroup, self.currentVehicle)
									end
								end
							else
								if getVisibility(self.animService.markergroupNode) then
									setVisibility(self.animService.markergroupNode, false)
								end
							end
						end
						if self.currentVehicle ~= nil then
							local storeItem = StoreItemsUtil.storeItemsByXMLFilename[self.currentVehicle.configFileName:lower()]
							if storeItem ~= nil then
								local nameString = g_i18n:getText("ui_statisticViewVehicleSelection")..":  "..storeItem.brand.."  "..storeItem.name
								self.vehicleServiceName = nameString
							end
						else
							self.vehicleServiceName = nil
						end
					end
				else
					if self.animService.markerGroup ~= nil then
						if getVisibility(self.animService.markergroupNode) then
							setVisibility(self.animService.markergroupNode, false)
						end
					end
					if self.vehicleServiceName ~= nil then
						self.vehicleServiceName = nil
					end
				end
			end

			if self.animService.player then
				if InputBinding.hasEvent(InputBinding.service_activateService) then
					self:setServiceAnimation(not self.serviceAnimActive)
				end

				local animationTimeS = self:getAnimationTime(self.animService.animationName)
				if animationTimeS == 1 then
					if InputBinding.hasEvent(InputBinding.service_showMarkers) then
						self:setShowMarkers(not self.showServiceMarkers, true)
					end

					if self.showServiceMarkers then
						g_currentMission:addHelpButtonText(string.format(g_i18n:getText("action_turnOffOBJECT"), "Service Marker"), InputBinding.service_showMarkers)
					else
						g_currentMission:addHelpButtonText(string.format(g_i18n:getText("action_turnOnOBJECT"), "Service Marker"), InputBinding.service_showMarkers)
					end
				end

				if animationTimeS > 0 then
					g_currentMission:addHelpButtonText(g_i18n:getText("action_deactivateService"), InputBinding.service_activateService)
					if animationTimeS == 1 then
						if self.vehicleServiceName ~= nil then
							g_currentMission:addExtraPrintText(self.vehicleServiceName)
						else
							g_currentMission:addExtraPrintText(g_i18n:getText("ui_statisticViewVehicleSelection")..":  N/A")
						end
					end
					if self.serviceGroup.renderText and g_gui.currentGui == nil then
						setTextAlignment(RenderText.ALIGN_CENTER)
						renderText( 0.5, 0.06, 0.02, g_i18n:getText("action_deactivateService"))
						if animationTimeS == 1 then
							if self.vehicleServiceName ~= nil then
								setTextColor(0,1,0,1)
								renderText( 0.5, 0.09, 0.02, self.vehicleServiceName)
							else
								setTextColor(1,0,0,1)
								renderText( 0.5, 0.09, 0.02, g_i18n:getText("ui_statisticViewVehicleSelection")..":  N/A")
							end
							setTextColor(1,1,1,1)
						end
					end
				elseif animationTimeS < 1 then
					g_currentMission:addHelpButtonText(g_i18n:getText("action_activateService"), InputBinding.service_activateService)
					if self.serviceGroup.renderText and g_gui.currentGui == nil then
						setTextAlignment(RenderText.ALIGN_CENTER)
						renderText( 0.5, 0.06, 0.02, g_i18n:getText("action_activateService"))
					end
				end
			end
		end

		if self.operateFuel ~= nil then
			if self.operateFuel.isTurnedOn then
				if self.operateFuel.markerGroup ~= nil then
					if self.showFuelMarkers then

						if self.fuelUseShader then
							local vehicleToFuel = nil
							if self.gasStationTrigger ~= nil then
								if self.gasStationTrigger.vehiclesTriggerCount ~= nil then
									for vehicle,count in pairs(self.gasStationTrigger.vehiclesTriggerCount) do
										if count > 0 then
											vehicleToFuel = true
										end
									end
								end
							end

							if self.currentFuelVehicle ~= vehicleToFuel then
								self.currentFuelVehicle = vehicleToFuel
								self:setMarkerColour(self.operateFuel.markerGroup, self.currentFuelVehicle)
							end
						end

						if not getVisibility(self.operateFuel.markergroupNode) then
							setVisibility(self.operateFuel.markergroupNode, true)
						end
					else
						if getVisibility(self.operateFuel.markergroupNode) then
							setVisibility(self.operateFuel.markergroupNode, false)
						end
					end
				end
			else
				if self.operateFuel.markerGroup ~= nil then
					if getVisibility(self.operateFuel.markergroupNode) then
						setVisibility(self.operateFuel.markergroupNode, false)
					end
				end
			end

			if self.operateFuel.player then
				if InputBinding.hasEvent(InputBinding.service_activateFuel) then
					local doNotStart = not self:isTankFilled()
					if doNotStart then
						g_currentMission:showBlinkingWarning(g_i18n:getText("warning_fuelTankEmpty"))
					else
						self:setIsFuelTurnedOn(not self.operateFuel.isTurnedOn)
					end
				end

				if self.operateFuel.isTurnedOn then
					if InputBinding.hasEvent(InputBinding.service_showMarkers) then
						self:setShowMarkers(not self.showFuelMarkers, false)
					end

					if self.showFuelMarkers then
						g_currentMission:addHelpButtonText(string.format(g_i18n:getText("action_turnOffOBJECT"), "Fuel Marker"), InputBinding.service_showMarkers)
					else
						g_currentMission:addHelpButtonText(string.format(g_i18n:getText("action_turnOnOBJECT"), "Fuel Marker"), InputBinding.service_showMarkers)
					end
				end

				if self.operateFuel.isTurnedOn then
					g_currentMission:addHelpButtonText(g_i18n:getText("action_stopFuelPump"), InputBinding.service_activateFuel)
					if self.serviceGroup.renderText and g_gui.currentGui == nil then
						setTextAlignment(RenderText.ALIGN_CENTER)
						renderText( 0.5, 0.06, 0.02, g_i18n:getText("action_stopFuelPump"))
					end
				else
					g_currentMission:addHelpButtonText(g_i18n:getText("action_startFuelPump"), InputBinding.service_activateFuel)
					if self.serviceGroup.renderText and g_gui.currentGui == nil then
						setTextAlignment(RenderText.ALIGN_CENTER)
						renderText( 0.5, 0.06, 0.02, g_i18n:getText("action_startFuelPump"))
					end
				end
			end		

			if self:getIsFuelTurnedOn() then
				SoundUtil.play3DSample(self.operateFuel.sampleMotorRun)
				Utils.setEmittingState(self.operateFuel.runPS, true)
			end

			Utils.updateRotationNodes(self, self.operateFuel.rotationNodes, dt, self:getIsFuelTurnedOn())

			local emptyTank = not self:isTankFilled()
			if emptyTank then
				self:setIsFuelTurnedOn(false, nil)
			end
		end
	end
end

function ServiceTrailer:playerServiceTrigger(triggerId, otherId, onEnter, onLeave, onStay)
	if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.animService.player = true
	elseif onLeave and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.animService.player = false
	end
end

function ServiceTrailer:playerFuelTrigger(triggerId, otherId, onEnter, onLeave, onStay)
	if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.operateFuel.player = true
	elseif onLeave and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.operateFuel.player = false
	end
end

function ServiceTrailer:setServiceAnimation(state, noEventSend)
	ServiceAnimationEvent.sendEvent(self, state, noEventSend)
	local animationTime = self:getAnimationTime(self.animService.animationName)

	if state and animationTime < 1 then
		self:playAnimation(self.animService.animationName, 1, animationTime, true)
	elseif state and animationTime >= 1 then
		self:playAnimation(self.animService.animationName, 1, 0, true)
	elseif animationTime > 0 then
		self:playAnimation(self.animService.animationName, -1, animationTime, true)
	end
	self.serviceAnimActive = state
end

function ServiceTrailer:setShowMarkers(state, isService, noEventSend)
	ShowMarkersEvent.sendEvent(self, state, isService, noEventSend)

	if isService then
		self.showServiceMarkers = state
	else
		self.showFuelMarkers = state
	end
end

function ServiceTrailer:getIsFuelTurnedOn()
	if self.operateFuel ~= nil then
		return self.operateFuel.isTurnedOn
	else
		return false
	end
end

function ServiceTrailer:setIsFuelTurnedOn(isTurnedOn, noEventSend)
    if self.operateFuel ~= nil then
		if isTurnedOn ~= self.operateFuel.isTurnedOn then
			TurnedOnFuelEvent.sendEvent(self, isTurnedOn, noEventSend)
			self.operateFuel.isTurnedOn = isTurnedOn
			if self.operateFuel.isTurnedOn then
				self:onFuelTurnedOn(noEventSend)
			else
				self:onFuelTurnedOff(noEventSend)
			end
		end
	end
end

function ServiceTrailer:onFuelTurnedOn(noEventSend)
	if self.isClient then
		if self.operateFuel ~= nil then
			if self.playAnimation ~= nil then
				if self.operateFuel.turnOnAnimation ~= nil then
					self:playAnimation(self.operateFuel.turnOnAnimation.name, self.operateFuel.turnOnAnimation.turnOnSpeedScale, self:getAnimationTime(self.operateFuel.turnOnAnimation.name), true)
				end
			end
		end
    end
end

function ServiceTrailer:onFuelTurnedOff(noEventSend)
    if self.isClient then
		if self.operateFuel ~= nil then
			if self.playAnimation ~= nil then
				if self.operateFuel.turnOnAnimation ~= nil then
					self:playAnimation(self.operateFuel.turnOnAnimation.name, self.operateFuel.turnOnAnimation.turnOffSpeedScale, self:getAnimationTime(self.operateFuel.turnOnAnimation.name), true)
				end
			end

			SoundUtil.stop3DSample(self.operateFuel.sampleMotorRun)
			Utils.setEmittingState(self.operateFuel.runPS, false)
		end
    end
end

function ServiceTrailer:setMarkerColour(markerGroup, currentVehicle)
	local colour = nil

	if currentVehicle ~= nil then
		colour = {0, 1, 0, 1}
	else
		colour = {1, 0, 0, 1}
	end

	for _,marker in pairs(markerGroup) do
		setShaderParameter(marker, "colorScale", colour[1], colour[2], colour[3], colour[3], false)
	end
end

function ServiceTrailer:isTankFilled()
	if self.getFillLevel ~= nil then
		return self:getFillLevel() > 0
	end
	return false
end

function ServiceTrailer:draw()
end

function ServiceTrailer:mouseEvent(posX, posY, isDown, isUp, button)
end

function ServiceTrailer:keyEvent(unicode, sym, modifier, isDown)
end

-- Operate Service Event --

ServiceAnimationEvent = {}
ServiceAnimationEvent_mt = Class(ServiceAnimationEvent, Event)
InitEventClass(ServiceAnimationEvent, "ServiceAnimationEvent")

function ServiceAnimationEvent:emptyNew()
    local self = Event:new(ServiceAnimationEvent_mt)
    return self
end

function ServiceAnimationEvent:new(object, state)
    local self = ServiceAnimationEvent:emptyNew()
    self.object = object
	self.state = state
    return self
end

function ServiceAnimationEvent:readStream(streamId, connection)
	self.object = readNetworkNodeObject(streamId)
	self.state = streamReadBool(streamId)
    self:run(connection)
end

function ServiceAnimationEvent:writeStream(streamId, connection)
	writeNetworkNodeObject(streamId, self.object)
	streamWriteBool(streamId, self.state)
end

function ServiceAnimationEvent:run(connection)
    self.object:setServiceAnimation(self.state, true)
    if not connection:getIsServer() then
        g_server:broadcastEvent(ServiceAnimationEvent:new(self.object, self.state), nil, connection, self.object)
    end
end

function ServiceAnimationEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ServiceAnimationEvent:new(vehicle, state), nil, nil, vehicle)
		else
			g_client:getServerConnection():sendEvent(ServiceAnimationEvent:new(vehicle, state))
		end
	end
end

-- Operate Fuel Event --

TurnedOnFuelEvent = {}
TurnedOnFuelEvent_mt = Class(TurnedOnFuelEvent, Event)
InitEventClass(TurnedOnFuelEvent, "TurnedOnFuelEvent")


function TurnedOnFuelEvent:emptyNew()
    local self = Event:new(TurnedOnFuelEvent_mt)
    return self
end

function TurnedOnFuelEvent:new(object, isTurnedOn)
    local self = TurnedOnFuelEvent:emptyNew()
    self.object = object
    self.isTurnedOn = isTurnedOn
    return self
end

function TurnedOnFuelEvent:readStream(streamId, connection)
    self.object = readNetworkNodeObject(streamId)
    self.isTurnedOn = streamReadBool(streamId)
    self:run(connection)
end

function TurnedOnFuelEvent:writeStream(streamId, connection)
    writeNetworkNodeObject(streamId, self.object)
    streamWriteBool(streamId, self.isTurnedOn)
end

function TurnedOnFuelEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.object)
    end
    if self.object ~= nil then
        self.object:setIsFuelTurnedOn(self.isTurnedOn, true)
    end
end

function TurnedOnFuelEvent.sendEvent(vehicle, isTurnedOn, noEventSend)
    if isTurnedOn ~= vehicle.operateFuel.isTurnedOn then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(TurnedOnFuelEvent:new(vehicle, isTurnedOn), nil, nil, vehicle)
            else
                g_client:getServerConnection():sendEvent(TurnedOnFuelEvent:new(vehicle, isTurnedOn))
            end
        end
    end
end

-- Show/Hide Markers Event --

ShowMarkersEvent = {}
ShowMarkersEvent_mt = Class(ShowMarkersEvent, Event)
InitEventClass(ShowMarkersEvent, "ShowMarkersEvent")

function ShowMarkersEvent:emptyNew()
    local self = Event:new(ShowMarkersEvent_mt)
    return self
end

function ShowMarkersEvent:new(object, state, isService)
    local self = ShowMarkersEvent:emptyNew()
    self.object = object
	self.state = state
	self.isService = isService
    return self
end

function ShowMarkersEvent:readStream(streamId, connection)
	self.object = readNetworkNodeObject(streamId)
	self.state = streamReadBool(streamId)
	self.isService = streamReadBool(streamId)
    self:run(connection)
end

function ShowMarkersEvent:writeStream(streamId, connection)
	writeNetworkNodeObject(streamId, self.object)
	streamWriteBool(streamId, self.state)
	streamWriteBool(streamId, self.isService)
end

function ShowMarkersEvent:run(connection)
    self.object:setShowMarkers(self.state, self.isService, true)
    if not connection:getIsServer() then
        g_server:broadcastEvent(ShowMarkersEvent:new(self.object, self.state, self.isService), nil, connection, self.object)
    end
end

function ShowMarkersEvent.sendEvent(vehicle, state, isService, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ShowMarkersEvent:new(vehicle, state, isService), nil, nil, vehicle)
		else
			g_client:getServerConnection():sendEvent(ShowMarkersEvent:new(vehicle, state, isService))
		end
	end
end