--
-- BackupCamACGui
-- Specialization for a additional GUI for FS17
--
-- @author:		Michi77
-- @date:		24/12/15
-- @version:	v1.0
-- @history:	v1.0 - initial version
--
-- free for non-commercial usage
-- note: rafftnixGUI needed!!
-- @author: 	Sveni
-- @history: 	v1.3 - FS17 tauglich
-- @date: 		04/04/17 
--

BackupCamACGui = {};

function BackupCamACGui.prerequisitesPresent(specializations)
    return RafftnixGUI ~= nil;
end;

function BackupCamACGui:load(xmlFile)
	self.gui = RafftnixGUI:new(nil, false, false);
	self.addBackupCam = SpecializationUtil.callSpecializationsFunction("addBackupCam");
	self.removeBackupCam = SpecializationUtil.callSpecializationsFunction("removeBackupCam");
	self.cameraButton1Callback = SpecializationUtil.callSpecializationsFunction("cameraButton1Callback");
	self.cameraButton2Callback = SpecializationUtil.callSpecializationsFunction("cameraButton2Callback");
	self.cameraButton3Callback = SpecializationUtil.callSpecializationsFunction("cameraButton3Callback");
	self.cameraButton4Callback = SpecializationUtil.callSpecializationsFunction("cameraButton4Callback");
	self.cameraButton5Callback = SpecializationUtil.callSpecializationsFunction("cameraButton5Callback");
	self.cameraNotAvailable = SpecializationUtil.callSpecializationsFunction("cameraNotAvailable");
	self.cameraButtonOffCallback = SpecializationUtil.callSpecializationsFunction("cameraButtonOffCallback");

	self.blackBackgroundHeight = 0.033;
	self.blackBackground = self.gui:createImage(self.gui.baseElement, 0.805, 0.2085, 0.174, self.blackBackgroundHeight, "hud/hud_block.dds");
	
	self.backupCams = {};
	self.currentCam = 0;
	self.maxBackupCams = 5;
	-- local posX = getXMLFloat(xmlFile, "vehicle.BackupCamACGui.position#x");
	-- local posY = getXMLFloat(xmlFile, "vehicle.BackupCamACGui.position#y");
	-- local width = getXMLFloat(xmlFile, "vehicle.BackupCamACGui.position#width");
	-- local height = getXMLFloat(xmlFile, "vehicle.BackupCamACGui.position#height");
	local i = 0;
	while true do		
		local key = string.format("vehicle.backupCams.cam(%d)#index", i);
		if not hasXMLProperty(self.xmlFile, key) then
			break;
		end;
		local cam = Utils.indexToObject(self.components, getXMLString(self.xmlFile, string.format("vehicle.backupCams.cam(%d)#index", i)));
		-- local camOverlay = self.gui:createRenderOverlay(self.gui.baseElement, posX, posY+height, width, height, cam, 512, 512, getScreenAspectRatio());
		local camOverlay = self.gui:createRenderOverlay(self.gui.baseElement, 0.8095, 0.24, 0.166, 0.166, cam, 512, 512, getScreenAspectRatio());

		self:addBackupCam(cam, camOverlay);
		i = i + 1;
	end;

	self.cameraNotAvailableText = self.gui:createText(self.gui.baseElement, 0.83, 0.2*1.5, 0.166, 0.166, g_i18n:getText("CAM_NOT_AVAILABLE"), 0.015, {1,1,1,1});
	self.cameraNotAvailableText.visibility = false;
	self:cameraButtonOffCallback();
	self.currentCam = 0;
	self.gui.cameraButton1 = self.gui:createImgButton(self.gui.baseElement, 0.8095, 		 0.21, 0.025, 0.026, "hud/panel_button1_diffuse.dds", self.cameraButton1Callback, self);
	self.gui.cameraButton2 = self.gui:createImgButton(self.gui.baseElement, 0.8095+1*0.0275, 0.21, 0.025, 0.026, "hud/panel_button2_diffuse.dds", self.cameraButton2Callback, self);
	self.gui.cameraButton3 = self.gui:createImgButton(self.gui.baseElement, 0.8095+2*0.0275, 0.21, 0.025, 0.026, "hud/panel_button3_diffuse.dds", self.cameraButton3Callback, self);
	self.gui.cameraButton4 = self.gui:createImgButton(self.gui.baseElement, 0.8095+3*0.0275, 0.21, 0.025, 0.026, "hud/panel_button4_diffuse.dds", self.cameraButton4Callback, self);
	self.gui.cameraButton5 = self.gui:createImgButton(self.gui.baseElement, 0.8095+4*0.0275, 0.21, 0.025, 0.026, "hud/panel_button5_diffuse.dds", self.cameraButton5Callback, self);
	self.gui.cameraButtonOff = self.gui:createImgButton(self.gui.baseElement, 0.8095+5*0.0275, 0.21, 0.025, 0.026, "hud/panel_button_onoff_diffuse.dds", self.cameraButtonOffCallback, self);

	self.isOpened = false;
end;

function BackupCamACGui:delete()
end;

function BackupCamACGui:addBackupCam(cam, overlay)
	if table.getn(self.backupCams) < self.maxBackupCams then
		self.backupCams[#self.backupCams + 1] = {};
		self.backupCams[#self.backupCams].index = cam;
		if overlay ~= nil then
			self.backupCams[#self.backupCams].overlay = overlay;
		else
			local camOverlay = self.gui:createRenderOverlay(self.gui.baseElement, 0.8095, 0.24, 0.166, 0.166, cam, 512, 512, getScreenAspectRatio());
			self.backupCams[#self.backupCams].overlay = camOverlay;
			self.backupCams[#self.backupCams].overlay.visibility = false;
		end;
		--print("Cam Cop: "..cam);
	else
		print("cam maximum reached");
	end;
end;

function BackupCamACGui:removeBackupCam(cam)
	for i=1, #self.backupCams do
		if self.backupCams[i].index == cam then
			self.backupCams[i].overlay.visibility = false;
			table.remove(self.backupCams, i);
			break;
		end;
	end;
	if self.currentCam == 4 or self.currentCam == 5 then
		self:cameraNotAvailable(true);
	end;
end;

function BackupCamACGui:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BackupCamACGui:keyEvent(unicode, sym, modifier, isDown)
end;

function BackupCamACGui:update(dt)
	if self.isEntered and self.cameras[self.camIndex].isInside then
		if InputBinding.hasEvent(InputBinding.ACTIVATE_CAMERAS) then
			self.isOpened = not self.isOpened;
			self.gui.mouseActive = self.isOpened; 

			if self.isOpened == false then
				InputBinding.setShowMouseCursor(false);
			end;
		end;
		if g_currentMission.showHudEnv == false then
			self.gui:close();
		else
			self.gui:open();
		end;
	else
		self.gui:close();
	end;
end;

function BackupCamACGui:draw()
	
end;

function BackupCamACGui:cameraNotAvailable(state)
	self.cameraNotAvailableText.visibility = state;
end;
function BackupCamACGui:cameraButton1Callback()
	self:cameraButtonOffCallback();
	if self.backupCams[1] ~= nil then self.backupCams[1].overlay.visibility = true; self.currentCam = 1; else self:cameraNotAvailable(true); end;
	self.blackBackground.height = self.blackBackgroundHeight * 6.2;
end;
function BackupCamACGui:cameraButton2Callback()
	self:cameraButtonOffCallback();
	if self.backupCams[2] ~= nil then self.backupCams[2].overlay.visibility = true; self.currentCam = 2; else self:cameraNotAvailable(true); end;
	self.blackBackground.height = self.blackBackgroundHeight * 6.2;
end;
function BackupCamACGui:cameraButton3Callback()
	self:cameraButtonOffCallback();
	if self.backupCams[3] ~= nil then self.backupCams[3].overlay.visibility = true; self.currentCam = 3; else self:cameraNotAvailable(true); end;
	self.blackBackground.height = self.blackBackgroundHeight * 6.2;
end;
function BackupCamACGui:cameraButton4Callback()
	self:cameraButtonOffCallback();
	if self.backupCams[4] ~= nil then self.backupCams[4].overlay.visibility = true; self.currentCam = 4; else self:cameraNotAvailable(true); end;
	self.blackBackground.height = self.blackBackgroundHeight * 6.2;
end;
function BackupCamACGui:cameraButton5Callback()
	self:cameraButtonOffCallback();
	if self.backupCams[5] ~= nil then self.backupCams[5].overlay.visibility = true; self.currentCam = 5; else self:cameraNotAvailable(true); end;
	self.blackBackground.height = self.blackBackgroundHeight * 6.2;
end;
function BackupCamACGui:cameraButtonOffCallback()
	self:cameraNotAvailable(false);
	if self.backupCams[1] ~= nil then self.backupCams[1].overlay.visibility = false; end;
	if self.backupCams[2] ~= nil then self.backupCams[2].overlay.visibility = false; end;
	if self.backupCams[3] ~= nil then self.backupCams[3].overlay.visibility = false; end;
	if self.backupCams[4] ~= nil then self.backupCams[4].overlay.visibility = false; end;
	if self.backupCams[5] ~= nil then self.backupCams[5].overlay.visibility = false; end;
	self.blackBackground.height = self.blackBackgroundHeight;
	self.currentCam = 0;
end;