--[[ FrontloaderControls 

Author: 		HoFFi (modding-welt.com)

Description: 	script to animate a joystick according to frontloader-arm and tool movement

Version: 		1.0

Changelog: 		21-03-2018 - initial release
				25-03-2018 - added function to show current FL-Tool angle via hud-needle

--------------------------------------------------------------------------------------------------

XML:
	<frontloaderControls>
		<joystick node="0>20|0" node2="0>20|0|0" rotFront="20" rotBack="-20"  heightCheckNode="1>4|0|0|1|2|1" heightCheckGroundNode="0>20|2|1|0"/>
	</frontloaderControls>
	
Explaination:
	node = TG or object of joystick which rotates forwards/backwards
	node2 = TG or object of joystick which rotates to right/left side
	rotFront/Back = angle of rotation
	heightCheckNode = TG located in wing which is needed to get the worldRotation
	heightCheckGroundNode = TG (e.g. with a needle) which is animated due to value of heightCheckNode 
	
	
Recommended structure in GE

	xyz							e.g. cabin_vis
	-transform_group			node
	--transform_group			node2
	---Joystick					visual joystick object

	
Hint: 
- please make sure rotation of node and node2 in GE is set to 0 0 0
- please do not use same index for node and node2

]]

--AttacherJoints.registerJointType("WeidemannWeight");
--AttacherJoints.registerJointType("WeidemannTool");

frontloaderControls = {};

frontloaderControls.modDir = g_currentModDirectory;
frontloaderControls.currentModName = g_currentModName;

--addModEventListener(frontloaderControls);


function frontloaderControls.prerequisitesPresent(specializations)
    return true; 
end;


function frontloaderControls:load(savegame)
	self.FLcontrols = {};
	self.FLcontrols.joystick = {};
	self.FLcontrols.joystick.node = Utils.indexToObject( self.components, getXMLString(self.xmlFile, "vehicle.frontloaderControls.joystick#node") );
	self.FLcontrols.joystick.node2 = Utils.indexToObject( self.components, getXMLString(self.xmlFile, "vehicle.frontloaderControls.joystick#node2") );
	self.FLcontrols.joystick.heightCheckNode = Utils.indexToObject( self.components, getXMLString(self.xmlFile, "vehicle.frontloaderControls.joystick#heightCheckNode") );
	self.FLcontrols.joystick.heightCheckGroundNode = Utils.indexToObject( self.components, getXMLString(self.xmlFile, "vehicle.frontloaderControls.joystick#heightCheckGroundNode") );
	self.FLcontrols.joystick.heightCheckIndicator = Utils.indexToObject( self.components, getXMLString(self.xmlFile, "vehicle.frontloaderControls.joystick#heightCheckIndicator") );
	
	if self.FLcontrols.joystick.node ~= nil then
		self.FLcontrols.joystick.rotF = math.rad( Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.frontloaderControls.joystick#rotFront"), 0) );
		self.FLcontrols.joystick.rotB = math.rad( Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.frontloaderControls.joystick#rotBack"), 0) );
		self.FLcontrols.joystick.rotT = 0;
		self.FLcontrols.joystick.rotC = 0;
		self.FLcontrols.joystick.rotF2 = math.rad( Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.frontloaderControls.joystick#rotFront"), 0) );
		self.FLcontrols.joystick.rotB2 = math.rad( Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.frontloaderControls.joystick#rotBack"), 0) );
		self.FLcontrols.joystick.rotT2 = 0;
		self.FLcontrols.joystick.rotC2 = 0;
		
		self.FLcontrols.curRot = 0;
		self.FLcontrols.angle = 0;
		
		self.FLcontrols.joystick.direction = 1; -- DO NOT CHANGE THIS!
	end;
	
end;

function frontloaderControls:delete()
end;

function frontloaderControls:readStream(streamId, connection)
end;

function frontloaderControls:writeStream(streamId, connection)
end;

function frontloaderControls:mouseEvent(posX, posY, isDown, isUp, button)
end;

function frontloaderControls:keyEvent(unicode, sym, modifier, isDown)
end;

function frontloaderControls:update(dt)
	if self.isEntered and self.cameras[self.camIndex].isInside then
		if self.isClient then
			if self.FLcontrols.joystick.node then
				frontloaderControls.updateJoystick(self, dt);
			end;
		end;
	end;
	
	
	
end;

function frontloaderControls:updateTick(dt)
end;

function frontloaderControls:onLeave()
end;

function frontloaderControls:draw()

	--if self:getIsActive() then
	--	if self.isClient then
	--		renderText(0, 0, 1, self.FLposX);
	--	end
	--end;
end;

function frontloaderControls.updateJoystick(self, dt)

	local x, y, z = localToLocal(self.FLcontrols.joystick.heightCheckNode, self.FLcontrols.joystick.heightCheckGroundNode, 0, 0, 0)
	local y2 = y / 5;
	setScale(self.FLcontrols.joystick.heightCheckIndicator, 1, y2, 1);
	
	
	local axisFLarm = 0 
	local axisFLtool = 0 	
	
	axisFLarm = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FRONTLOADER_ARM);
	if InputBinding.isAxisZero(axisFLarm) then 
		axisFLarm = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FRONTLOADER_ARM); 
	end
	axisFLtool = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FRONTLOADER_TOOL);
	if InputBinding.isAxisZero(axisFLtool) then 
		axisFLtool = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FRONTLOADER_TOOL); 
	end
	

	if axisFLarm > 0 then
		self.FLcontrols.joystick.rotT = -self.FLcontrols.joystick.rotF*axisFLarm;
	elseif axisFLarm < 0 then
		self.FLcontrols.joystick.rotT = self.FLcontrols.joystick.rotB*axisFLarm;
	else
		self.FLcontrols.joystick.rotT = 0;
	end
	if axisFLtool > 0 then
		self.FLcontrols.joystick.rotT2 = -self.FLcontrols.joystick.rotF2*axisFLtool;
	elseif axisFLtool < 0 then
		self.FLcontrols.joystick.rotT2 = self.FLcontrols.joystick.rotB2*axisFLtool;
	else
		self.FLcontrols.joystick.rotT2 = 0;
	end
	
	
	if self.FLcontrols.joystick.rotC < self.FLcontrols.joystick.rotT then
		self.FLcontrols.joystick.rotC = self.FLcontrols.joystick.rotC + dt/1000;
		if self.FLcontrols.joystick.rotC > self.FLcontrols.joystick.rotT then
			self.FLcontrols.joystick.rotC = self.FLcontrols.joystick.rotT;
		end;
	elseif self.FLcontrols.joystick.rotC > self.FLcontrols.joystick.rotT then
		self.FLcontrols.joystick.rotC = self.FLcontrols.joystick.rotC - dt/1000;
		if self.FLcontrols.joystick.rotC < self.FLcontrols.joystick.rotT then
			self.FLcontrols.joystick.rotC = self.FLcontrols.joystick.rotT;
		end;
	end;
	if self.FLcontrols.joystick.rotC2 < self.FLcontrols.joystick.rotT2 then
		self.FLcontrols.joystick.rotC2 = self.FLcontrols.joystick.rotC2 + dt/1000;
		if self.FLcontrols.joystick.rotC2 > self.FLcontrols.joystick.rotT2 then
			self.FLcontrols.joystick.rotC2 = self.FLcontrols.joystick.rotT2;
		end;
	elseif self.FLcontrols.joystick.rotC2 > self.FLcontrols.joystick.rotT2 then
		self.FLcontrols.joystick.rotC2 = self.FLcontrols.joystick.rotC2 - dt/1000;
		if self.FLcontrols.joystick.rotC2 < self.FLcontrols.joystick.rotT2 then
			self.FLcontrols.joystick.rotC2 = self.FLcontrols.joystick.rotT2;
		end;
	end;
	
	setRotation( self.FLcontrols.joystick.node, self.FLcontrols.joystick.rotC, 0, 0 );
	setRotation( self.FLcontrols.joystick.node2, 0, 0, self.FLcontrols.joystick.rotC2 );
end;

