--
-- InteractiveButtons
-- Specialization for an interactive control button
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.1
-- @date  		29/08/11
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--				v2.1 - improvements
--
-- free for noncommerical-usage
--

InteractiveButtons = {};

function InteractiveButtons.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(InteractiveControl, specializations);
end;

function InteractiveButtons:load(savegame)

	local i=0;
	while true do
		local buttonName = string.format("vehicle.interactiveComponents.buttons.button(%d)", i);	
		if not hasXMLProperty(self.xmlFile, buttonName) then
			break;
		end;
		local name = Utils.getNoNil(g_i18n:getText(getXMLString(self.xmlFile, buttonName .. "#name")), "ERROR");
		local mark = Utils.indexToObject(self.components, getXMLString(self.xmlFile, buttonName .. "#mark"));
		local highlight = getChildAt(mark, 0);
		local size = Utils.getNoNil(getXMLFloat(self.xmlFile, buttonName .. "#size"), 0.1);
		local event = getXMLString(self.xmlFile, buttonName .. "#event");
		local onMessage = g_i18n:getText(Utils.getNoNil(getXMLString(self.xmlFile, buttonName .. "#onMessage"), "ic_button_on"));
		local offMessage =  g_i18n:getText(Utils.getNoNil(getXMLString(self.xmlFile, buttonName .. "#offMessage") , "ic_button_off"));
	
		local button = Button:new(nil, highlight, name, mark, size, event, self, onMessage, offMessage, self.infoBar);
		
		button.synch = Utils.getNoNil(getXMLBool(self.xmlFile, buttonName .. "#synch"), true);

		table.insert(self.interactiveObjects, button);
		i = i + 1;
	end;
end;

function InteractiveButtons:delete()
end;

function InteractiveButtons:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InteractiveButtons:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveButtons:update(dt)	
end;

function InteractiveButtons:draw()
end;



--
-- Button Class
-- Specifies an interactive Button
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  29/08/11
--

Button = {};

function Button:new(node, highlight, name, mark, size, event, vehicle, onMessage, offMessage, infobar)

	local Button_mt = Class(Button, InteractiveComponentInterface);	
    local instance = InteractiveComponentInterface:new(node, highlight, name, mark, size, onMessage, offMessage, infobar, Button_mt);

	instance.vehicle = vehicle;
	instance.event = event;
	
	return instance;	
end;

function Button:delete()
	InteractiveComponentInterface.delete(self);
end;

function Button:mouseEvent(posX, posY, isDown, isUp, button)
	InteractiveComponentInterface.mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Button:keyEvent(unicode, sym, modifier, isDown)
	InteractiveComponentInterface.keyEvent(self, unicode, sym, modifier, isDown);
end;

function Button:update(dt)
	if self.vehicle ~= nil then
		if self.event == "cablight" then
			self.isOpen = self.vehicle.cl.turnOn;
		--elseif self.event == " " then
		end;
	end;
	InteractiveComponentInterface.update(self, dt);
end;

function Button:draw()
	InteractiveComponentInterface.draw(self);
end;

function Button:doAction(noEventSend, forceAction)
	InteractiveComponentInterface.doAction(self, forceAction);
	
	if self.vehicle ~= nil then
		if self.playBcSound ~= nil and self.vehicle:getIsActiveForSound() then
			if self.playBcSound then
				SoundUtil.playSample(g_currentMission.sampleToggleLights, 1, 0, 1);
			end;
		end;
	end;
	
	
	if self.vehicle ~= nil then		
		if self.event == "toggleMotorIgnition" then
			if forceAction == nil then
				if not g_currentMission.missionInfo.automaticMotorStartEnabled then
					if self.vehicle.isMotorStarted then
						self.vehicle:stopMotor();
					else
						self.vehicle:startMotor();
					end;
				end;
			end;
		end;	
	end;
	if self.vehicle ~= nil then
		if self.event == "toggleBeaconLights" then
			if forceAction == nil then
				self.vehicle:setBeaconLightsVisibility(not self.vehicle.beaconLightsActive);
			end;
		end;
	end;
	if self.vehicle ~= nil then
		if self.event == "toggleWarningLights" then
			if forceAction == nil then
			local state = Lights.TURNLIGHT_OFF;
                if self.vehicle.turnLightState ~= Lights.TURNLIGHT_HAZARD then
                    state = Lights.TURNLIGHT_HAZARD;
                end
                self.vehicle:setTurnLightState(state);
			end;
		end;
	end;
	if self.vehicle ~= nil then
		if self.event == "toggleCablight" then
			if forceAction == nil then
				local state = not self.vehicle.cl.turnOn;
				self.vehicle:setCablight(state, true);
			end;
		end;	
	end;
	if self.vehicle ~= nil then
		if self.event == "toggleFrontLights" then
			if self.vehicle.numLightTypes >= 1 then
				if forceAction ~= (bitAND(self.vehicle.lightsTypesMask, 2^0) == 1 ) then
					self.vehicle:setLightsTypesMask(bitXOR(self.vehicle.lightsTypesMask, 2^0));
				end;
			end;
		end;
	end;
	if self.vehicle ~= nil then
		if self.event == "toggleHighBeamLights" then
			if self.vehicle.numLightTypes >= 4 then
				if forceAction ~= (bitAND(self.vehicle.lightsTypesMask, 2^3) == 8 ) then
					self.vehicle:setLightsTypesMask(bitXOR(self.vehicle.lightsTypesMask, 2^3));
				end;
			end;
		end;
	end;
	if self.vehicle ~= nil then
		if self.event == "toggleFrontWorkLights" then
			if self.vehicle.numLightTypes >= 3 then
				if forceAction ~= (bitAND(self.vehicle.lightsTypesMask, 2^2) == 4 ) then
					self.vehicle:setLightsTypesMask(bitXOR(self.vehicle.lightsTypesMask, 2^2));
				end;
			end;
		end;
	end;
	if self.vehicle ~= nil then
		if self.event == "toggleRearWorkLights" then
			if self.vehicle.numLightTypes >= 2 then
				if forceAction ~= (bitAND(self.vehicle.lightsTypesMask, 2^1) == 2 ) then
					self.vehicle:setLightsTypesMask(bitXOR(self.vehicle.lightsTypesMask, 2^1));
				end;
			end;
		end;
	end;
	if self.vehicle ~= nil then
		if self.event == "toggleFLT" then
			if forceAction == nil then
				if self.vehicle.crabSteering.state == 1 then
					self.vehicle:setCrabSteering(2);
				else
					self.vehicle:setCrabSteering(1)
				end;
			end;
		end;
	end;
	if self.vehicle ~= nil then
		if self.event == "toggleCrabState1" then
			if forceAction == nil then
				self.vehicle:setCrabSteering(1);
			end;
		end;
	end;
	if self.vehicle ~= nil then
		if self.event == "toggleCrabState2" then
			if forceAction == nil then
				self.vehicle:setCrabSteering(2);
			end;
		end;
	end;
	if self.vehicle ~= nil then
		if self.event == "toggleCrabState3" then
			if forceAction == nil then
				self.vehicle:setCrabSteering(3);
			end;
		end;
	end;
	if self.vehicle ~= nil then
		if self.event == "toggleCrabState4" then
			if forceAction == nil then
				self.vehicle:setCrabSteering(4);
			end;
		end;
	end;
	if self.vehicle ~= nil then
		if self.event == "toggleFoldingParts" then
			if forceAction == nil then
				if self.vehicle:getIsFoldAllowed() then
	                if self.vehicle:getToggledFoldDirection() == self.turnOnFoldDirection then
	                    self.vehicle:setFoldState(self.vehicle:getToggledFoldDirection(), true);
	                else
	                    self.vehicle:setFoldState(self.vehicle:getToggledFoldDirection(), false);
	                end
	            end
			end;
		end;
	end;
	if self.vehicle ~= nil then
		if self.event == "toggleFoldingMiddleParts" then
			if forceAction == nil then
				local direction = self.vehicle:getToggledFoldMiddleDirection();
				if direction ~= 0 then
					if direction == self.turnOnFoldDirection then
						self.vehicle:setFoldState(direction, false)
					else
						self.vehicle:setFoldState(direction, true)
					end
				end
			end;
		end;
	end;
	if self.vehicle ~= nil then
		if self.event == "toggleLockMovingTools" then
			if forceAction == nil then
				if self.vehicle.lmt.toolState == 1 then
					self.vehicle.lmt.toolState = 2
				else
					self.vehicle.lmt.toolState = 1
				end;
			end;
		end;
	end;
	if self.vehicle ~= nil then
		if self.event == "toggleCruiseState" then
			if forceAction == nil then
				if self.vehicle.cruiseControl.state == Drivable.CRUISECONTROL_STATE_OFF then
                    self.vehicle:setCruiseControlState(Drivable.CRUISECONTROL_STATE_ACTIVE);
                else
                    self.vehicle:setCruiseControlState(Drivable.CRUISECONTROL_STATE_OFF);
                end;
			end;
		end;
	end;
	if self.vehicle ~= nil then
		if self.event == "toggleCruiseSpeedRaise" then
			if forceAction == nil then
				self.vehicle:setCruiseControlMaxSpeed(self.vehicle.cruiseControl.speed + 1);
			end;
		end;
	end;
	if self.vehicle ~= nil then
		if self.event == "toggleCruiseSpeedLower" then
			if forceAction == nil then
				self.vehicle:setCruiseControlMaxSpeed(self.vehicle.cruiseControl.speed - 1);
			end;
		end;
	end;
	if self.vehicle ~= nil then
		if self.event == "toggleHarvesterChopper" then
			if forceAction == nil then
				if self.vehicle.isStrawEnabled then
                    self.vehicle:setIsStrawEnabled(false)
                else
                    self.vehicle:setIsStrawEnabled(true)
                end;
			end;
		end;
	end;
	if self.vehicle ~= nil then
		if self.event == "toggleVehiclePipe" then
			if forceAction == nil then
				local nextState = self.vehicle.pipeTargetState+1;
				if nextState > self.vehicle.pipeNumStates then
					nextState = 1;
				end;
				if self.vehicle:getIsPipeStateChangeAllowed(nextState) then
                    self.vehicle:setPipeState(nextState);
                elseif nextState ~= 1 and self:getIsPipeStateChangeAllowed(1) then
                    self.vehicle:setPipeState(1);
                end
			end;
		end;
	end;
	if self.event == "lowerBack" then
		if self.vehicle.lowerBack then
			self.vehicle:setJointMoveDown(1, false);
			self.vehicle.lowerBack = false;
		else
			self.vehicle:setJointMoveDown(1, true);
			self.vehicle.lowerBack = true
		end;
	end;
		
		if self.event == "lowerFront" then
		if self.vehicle.lowerFront then
			self.vehicle:setJointMoveDown(2, false);
			self.vehicle.lowerFront = false;
		else
			self.vehicle:setJointMoveDown(2, true);
			self.vehicle.lowerFront = true;
		end;
	end;
end;

function Button:onEnter(dt)
	InteractiveComponentInterface.onEnter(self, dt);
end;

function Button:onExit(dt)
	InteractiveComponentInterface.onExit(self, dt);
end;

function Button:setActive()
	InteractiveComponentInterface.setActive(self, isActive);
end;

function Button:setVisible(isVisible)
	InteractiveComponentInterface.setVisible(self, isVisible);
end;