-- 
-- FillTrigger Trailer specialization Script for FS17 tank trailers
-- by Blacky_BPG
-- 
-- Version: 1.5.3.1     |     13.05.2018
-- 

FillTriggerTrailer = {}

function FillTriggerTrailer.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Fillable, specializations)
end

function FillTriggerTrailer:load(savegame)
	local fillTriggerNode = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.fillTrigger#index"))
	if fillTriggerNode ~= nil then
		self.fillTriggerTrailer = FillTrigger:new()
		local triggerLoaded = self.fillTriggerTrailer:load(fillTriggerNode)
		if triggerLoaded then
			self.fillTriggerTrailer.parent = self
			g_currentMission:addNonUpdateable(self.fillTriggerTrailer)
		else
			print("ERROR: FillTrigger can't be loaded !")
		end
	end
end

function FillTriggerTrailer:delete()
	if self.fillTriggerTrailer ~= nil then
		self.fillTriggerTrailer:delete()
	end
end

function FillTriggerTrailer:mouseEvent(posX, posY, isDown, isUp, button) end
function FillTriggerTrailer:keyEvent(unicode, sym, modifier, isDown) end
function FillTriggerTrailer:readUpdateStream(streamId, timestamp, connection) end
function FillTriggerTrailer:writeUpdateStream(streamId, connection, dirtyMask) end
function FillTriggerTrailer:update(dt) end
function FillTriggerTrailer:readStream(streamId, connection) end
function FillTriggerTrailer:writeStream(streamId, connection) end
function FillTriggerTrailer:updateTick(dt) end
function FillTriggerTrailer:draw() end
