--
-- Puller
--
-- @author TyKonKet
-- @date 13/04/2017
Puller = {}
source(g_currentModDirectory .. "spec/pullerEvents.lua")

function Puller.prerequisitesPresent(specializations)
    return true
end

function Puller:preLoad(savegame)
    self.getAttachmentsSaveNodes = Utils.overwrittenFunction(self.getAttachmentsSaveNodes, Puller.getAttachmentsSaveNodes)
    self.loadAttachmentFromNodes = Utils.overwrittenFunction(self.loadAttachmentFromNodes, Puller.loadAttachmentFromNodes)
    self.canBeGrabbed = Puller.canBeGrabbed
    self.getIsTurnedOn = Puller.getIsTurnedOn
    self.pulledVehicleThrottle = false
end

function Puller:load(savegame)
    self.isGrabbable = Utils.getNoNil(getXMLBool(self.xmlFile, "vehicle.grabbable#isGrabbable"), false)
    self.isGrabbableOnlyIfDetach = Utils.getNoNil(getXMLBool(self.xmlFile, "vehicle.grabbable#isGrabbableOnlyIfDetach"), false)
    self.attachPoint = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.puller#index"))
    self.attachPointCollision = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.puller#rootNode"))
    self.attachRadius = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.puller#attachRadius"), 1)
    self.isAttached = false
    self.joint = {}
    self.inRangeVehicle = nil
end

function Puller:getAttachmentsSaveNodes(superFunc, nodeIdent, vehiclesToId)
end

function Puller:loadAttachmentFromNodes(superFunc, xmlFile, key, idsToVehicle)
end

function Puller:delete()
end

function Puller:mouseEvent(posX, posY, isDown, isUp, button)
end

function Puller:keyEvent(unicode, sym, modifier, isDown)
end

function Puller:readStream(streamId, connection)
end

function Puller:writeStream(streamId, connection)
end

function Puller:update(dt)
end

function Puller:updateTick(dt)
end

function Puller:onAttachObject(object, jointId, noEventSend)
end

function Puller:onDetachObject(noEventSend)
end

function Puller:draw()
end

function Puller:canBeGrabbed()
    if self.isGrabbable then
        if self.isGrabbableOnlyIfDetach then
            if not self.isAttached and self.attacherVehicle == nil then
                return true
            end
        else
            return true
        end
    end
    return false
end

function Player:pickUpObjectRaycastCallback(hitObjectId, x, y, z, distance)
    if distance > 0.5 and distance <= Player.MAX_PICKABLE_OBJECT_DISTANCE then
        if hitObjectId ~= g_currentMission.terrainDetailId and Player.PICKED_UP_OBJECTS[hitObjectId] ~= true then
            if getRigidBodyType(hitObjectId) == "Dynamic" then
                local object = g_currentMission:getNodeObject(hitObjectId)
                if (object ~= nil and object.dynamicMountObject == nil) or g_currentMission.nodeToVehicle[hitObjectId] == nil then
                    self.lastFoundObject = hitObjectId
                    self.lastFoundObjectMass = getMass(hitObjectId)
                    self.lastFoundObjectHitPoint = {x, y, z}
                    return false
                end
                if g_currentMission.nodeToVehicle[hitObjectId].canBeGrabbed ~= nil and g_currentMission.nodeToVehicle[hitObjectId]:canBeGrabbed() then
                    self.lastFoundObject = hitObjectId
                    self.lastFoundObjectMass = Player.MAX_PICKABLE_OBJECT_MASS * 0.9
                    self.lastFoundObjectHitPoint = {x, y, z}
                    return false
                end
            end
        end
    end
    return true
end

function Player:throwObject()
    if self.pickedUpObject ~= nil and self.pickedUpObjectJointId ~= nil then
        self:pickUpObject(false)
        local dx, dy, dz = localDirectionToWorld(self.cameraNode, 0, 0, -1)
        local mass = getMass(self.pickedUpObject)
        local v = 8.0 * (1.1 - math.min(1, mass / Player.MAX_PICKABLE_OBJECT_MASS))
        local vx = dx * v
        local vy = dy * v
        local vz = dz * v
        setLinearVelocity(self.pickedUpObject, vx, vy, vz)
        local object = g_currentMission:getNodeObject(self.pickedUpObject)
        if object ~= nil then
            object.thrownFromPosition = {getWorldTranslation(g_currentMission.player.rootNode)}
        end
    end
end

function Player:pickUpObject(state, noEventSend)
    if self.isServer then
        if state and (self.isObjectInRange and self.lastFoundObject ~= nil) and not self.isCarryingObject then
            local constr = JointConstructor:new()
            constr:setActors(self.pickUpKinematicHelper.node, self.lastFoundObject)
            constr:setJointTransforms(self.pickUpKinematicHelper.node, self.lastFoundObject)

            for i = 0, 2 do
                constr:setRotationLimit(i, 0, 0)
                constr:setTranslationLimit(i, true, 0, 0)
            end

            local wx = self.lastFoundObjectHitPoint[1]
            local wy = self.lastFoundObjectHitPoint[2]
            local wz = self.lastFoundObjectHitPoint[3]
            constr:setJointWorldPositions(wx, wy, wz, wx, wy, wz)

            local nx, ny, nz = localDirectionToWorld(self.lastFoundObject, 1, 0, 0)
            constr:setJointWorldAxes(nx, ny, nz, nx, ny, nz)

            local yx, yy, yz = localDirectionToWorld(self.lastFoundObject, 0, 1, 0)
            constr:setJointWorldNormals(yx, yy, yz, yx, yy, yz)

            constr:setEnableCollision(false)

            local dampingRatio = 1.0
            local mass = getMass(self.lastFoundObject) * 100
            if getMass(self.lastFoundObject) > Player.MAX_PICKABLE_OBJECT_MASS * 0.9 then
                mass = getMass(self.lastFoundObject) * 0.4 * 100
            else
                mass = getMass(self.lastFoundObject) * 100
            end

            local rotationLimitSpring = {}
            local rotationLimitDamper = {}
            for i = 1, 3 do
                rotationLimitSpring[i] = mass * 60
                rotationLimitDamper[i] = dampingRatio * 2 * math.sqrt(mass * rotationLimitSpring[i])
            end
            constr:setRotationLimitSpring(rotationLimitSpring[1], rotationLimitDamper[1], rotationLimitSpring[2], rotationLimitDamper[2], rotationLimitSpring[3], rotationLimitDamper[3])

            local translationLimitSpring = {}
            local translationLimitDamper = {}
            for i = 1, 3 do
                translationLimitSpring[i] = mass * 60
                translationLimitDamper[i] = dampingRatio * 2 * math.sqrt(mass * translationLimitSpring[i])
            end
            constr:setTranslationLimitSpring(translationLimitSpring[1], translationLimitDamper[1], translationLimitSpring[2], translationLimitDamper[2], translationLimitSpring[3], translationLimitDamper[3])

            local forceAcceleration = 4
            local forceLimit = forceAcceleration * mass
            constr:setBreakable(forceLimit, forceLimit)
            self.pickedUpObjectJointId = constr:finalize()
            addJointBreakReport(self.pickedUpObjectJointId, "onPickedUpObjectJointBreak", self)

            self.pickedUpObject = self.lastFoundObject
            self.isCarryingObject = true
            Player.PICKED_UP_OBJECTS[self.pickedUpObject] = true
            local object = g_currentMission:getNodeObject(self.pickedUpObject)
            if object ~= nil then
                object.thrownFromPosition = nil
            end
        else
            if self.pickedUpObjectJointId ~= nil then
                removeJoint(self.pickedUpObjectJointId)
                self.pickedUpObjectJointId = nil
                self.isCarryingObject = false
                Player.PICKED_UP_OBJECTS[self.pickedUpObject] = false

                if entityExists(self.pickedUpObject) then
                    local vx, vy, vz = getLinearVelocity(self.pickedUpObject)
                    vx = Utils.clamp(vx, -5, 5)
                    vy = Utils.clamp(vy, -5, 5)
                    vz = Utils.clamp(vz, -5, 5)
                    setLinearVelocity(self.pickedUpObject, vx, vy, vz)
                end
                local object = g_currentMission:getNodeObject(self.pickedUpObject)
                if object ~= nil then
                    object.thrownFromPosition = nil
                end
            end
        end
    end
end

function Puller:leaveVehicle(superFunc)
end

function Puller:getIsTurnedOn()
    return self.pulledVehicleThrottle
end