--[[
TimedVisibility

Script to show objects between the given 'eveningTime' and 'morningTime' in the xmlFile

@Author:	Ifko[nator]
@Date:		19.11.2017

@Version:	1.0

@History:	V1.0 @07.01.2017 - initial release in FS 17
			V1.5 @19.11.2017 - added possibility to show objects when it is foggy

@Usage:

	<timedVisibilitys>
		<timedVisibility index="0>2|3|2" eveningTime="19" morningTime="8"/>
		<timedVisibility index="0>2|2" eveningTime="17" morningTime="3" showOnFog="false"/>
		
		...
	</timedVisibilitys>

]]

TimedVisibility = {};

function TimedVisibility.prerequisitesPresent(specializations)
    return true; 
end;

function TimedVisibility:load(savegame)
	local count = 0;

	self.objects = {};
	
	while true do
		local xmlString = "vehicle.timedVisibilitys.timedVisibility(" .. tostring(count) .. ")";
		
		if not hasXMLProperty(self.xmlFile, xmlString) then
            break;
        end;
		
		local object = {};
		
		object.node = Utils.indexToObject(self.components, getXMLString(self.xmlFile, xmlString .. "#index"));
		
		if object.node ~= nil then
			object.eveningTime = tonumber(Utils.getNoNil(getXMLString(self.xmlFile, xmlString .. "#eveningTime"), 20));
			object.morningTime = tonumber(Utils.getNoNil(getXMLString(self.xmlFile, xmlString .. "#morningTime"), 7) - 1);
			object.showOnFog = Utils.getNoNil(getXMLBool(self.xmlFile, xmlString .. "#showOnFog"), true);
			
			table.insert(self.objects, object);
		end;
	
		count = count + 1;
	end;
	
	self.getIsFoggy = TimedVisibility.getIsFoggy;
end;

function TimedVisibility:getIsFoggy()
	return g_currentMission.environment.currentRain ~= nil and g_currentMission.environment.currentRain.rainTypeId == Environment.RAINTYPE_FOG;
end;

function TimedVisibility:update(dt)
	for _, object in pairs(self.objects) do
		local show = object.showOnFog and self:getIsFoggy();
		
		if not show then
			show = g_currentMission.environment.currentHour >= object.eveningTime or g_currentMission.environment.currentHour <= object.morningTime;
		end;
	
		setVisibility(object.node, show);
	end;
end;

function TimedVisibility:delete()end;
function TimedVisibility:mouseEvent(posX, posY, isDown, isUp, button)end;
function TimedVisibility:keyEvent(unicode, sym, modifier, isDown)end;
function TimedVisibility:draw()end;