--[[
CoverDrawFix

Script to only allow show the text for the cover in the F1 menu, when the configuration with the cover is buyed!

@Author:	Ifko[nator]
@Date:		23.04.2018

@Version:	V1.0

@History:	V1.0 @23.04.2018 - initial release in FS 17

@xml entry example:

<coverDrawFix configName="board" activeConfig="configuration_boardsPlane"/>
]]

CoverDrawFix = {};

function CoverDrawFix.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function CoverDrawFix:load(savegame)
	self.coverDrawFix = {};
	
	self.coverDrawFix.configName = Utils.getNoNil(getXMLString(self.xmlFile, "vehicle.coverDrawFix#configName"), "");
	self.coverDrawFix.activeConfig = Utils.getNoNil(getXMLString(self.xmlFile, "vehicle.coverDrawFix#activeConfig"), "");
	self.coverDrawFix.coverIsBought = false;
   
    if self.coverDrawFix.configName ~= "" and self.coverDrawFix.activeConfig ~= "" then
        local storeItem = StoreItemsUtil.storeItemsByXMLFilename[string.lower(self.configFileName)];

        if storeItem.configurations ~= nil and storeItem.configurations[self.coverDrawFix.configName] ~= nil then
			local configurations = storeItem.configurations[self.coverDrawFix.configName];
            local config = configurations[self.configurations[self.coverDrawFix.configName]];
       
			if g_i18n:hasText(self.coverDrawFix.activeConfig) then
				self.coverDrawFix.activeConfig = g_i18n:getText(self.coverDrawFix.activeConfig);
			end;
			
			self.coverDrawFix.coverIsBought = config.name == self.coverDrawFix.activeConfig;
        end;
    end;
	
	if not self.coverDrawFix.coverIsBought then
		Cover.draw = Utils.overwrittenFunction(Cover.draw, CoverDrawFix.drawFix);
	end;
end;

function CoverDrawFix:update(dt)
	if not self.coverDrawFix.coverIsBought and not self.isCoverOpen then
		self:setCoverState(true);
	end;
end;

function CoverDrawFix:drawFix(superFunc)
	if self.coverDrawFix ~= nil and not self.coverDrawFix.coverIsBought then
		return;
	end;
	
	if superFunc ~= nil then
		return superFunc(self);
	end;
end;

--## unused but needed functions

function CoverDrawFix:draw()end;
function CoverDrawFix:delete()end;
function CoverDrawFix:mouseEvent(posX, posY, isDown, isUp, button)end;
function CoverDrawFix:keyEvent(unicode, sym, modifier, isDown)end;
function CoverDrawFix:updateTick(dt)end;