local metadata = {
"## Interface:FS17 1.2.1.0 1.2.1RC2",
"## Title: HolmerAndRopaPotato",
"## Notes: HolmerAndRopaPotato",
"## Author: Marhu",
"## Convert: Ifko[nator]",
"## Version: 2.0.0",
"## Date: 15.03.2016",
"## Date convert: 03.11.2016",
"## Web: http://marhu.net"
}

local DebugEbene = 0;
local function getmdata(v) v="## "..v..": "; for i=1,table.getn(metadata) do local _,n=string.find(metadata[i],v);if n then return (string.sub (metadata[i], n+1)); end;end;end;
local function Debug(e,s,...) if e <= DebugEbene then print((getmdata("Title")).." v"..(getmdata("Version"))..": "..string.format(s,...)); end; end;
local function L(name) local t = getmdata("Title"); return g_i18n:hasText(t.."_"..name) and g_i18n:getText(t.."_"..name) or name; end
--print("Script " .. (getmdata("Title")) .. " v" .. (getmdata("Version")) .. " by " .. (getmdata("Author")) .. " converted to FS 17 by " .. (getmdata("Convert")) ..  " registered in " ..numVehicleTypes.. " vehicleTypes! Support on " .. (getmdata("Web")));

local function copyTable(orig)
    local orig_type = type(orig);
    local copy;
	
    if orig_type == 'table' then
        copy = {};
		
        for orig_key, orig_value in next, orig, nil do
            copy[copyTable(orig_key)] = copyTable(orig_value);
        end;
        
		setmetatable(copy, copyTable(getmetatable(orig)));
    else -- number, string, boolean, etc
        copy = orig;
    end;
	
    return copy;
end

HolmerAndRopaPotato = {};

function HolmerAndRopaPotato.prerequisitesPresent(specializations)
    return true;
end;

function HolmerAndRopaPotato:preLoad(savegame)
	local fillTypes = getXMLString(self.xmlFile, "vehicle.fillUnits.fillUnit(0)#fillTypes");
	
	if fillTypes then
		--print("filltypes old = " .. fillTypes);
		
		if not string.find(fillTypes, "potato") then
			setXMLString(self.xmlFile, "vehicle.fillUnits.fillUnit#fillTypes", "sugarBeet potato");
			
			--print("filltypes new = " .. getXMLString(self.xmlFile, "vehicle.fillUnits.fillUnit(0)#fillTypes"));
			
			self.doAddPotato = true;
		else
			self.doAddPotato = false;
		end;
	end;
end;

function HolmerAndRopaPotato:load(savegame)
	if self.fillUnits then	
		for fillType, fillUnit in pairs(self.fillUnits) do
			if fillUnit.fillTypes ~= nil and fillUnit.fillTypes[FillUtil.FILLTYPE_SUGARBEET] ~= nil and self.doAddPotato and self.pipeScrollers ~= nil then
				if self.pipeScrollers[FillUtil.FILLTYPE_SUGARBEET] and not self.pipeScrollers[FruitUtil.FRUITTYPE_POTATO] then
					self.pipeScrollers[FruitUtil.FRUITTYPE_POTATO] = copyTable(self.pipeScrollers[FillUtil.FILLTYPE_SUGARBEET]);
				end;
			end;
		end;
	end;
	
	if self.fruitTypes ~= nil and self.fruitTypes[FruitUtil.FRUITTYPE_SUGARBEET] and not self.fruitTypes[FruitUtil.FRUITTYPE_POTATO] then
		self.fruitTypes[FruitUtil.FRUITTYPE_POTATO] = true;
		
		self.checkPreparerFruitTypes = true;
	end;
end;

function HolmerAndRopaPotato:delete()
end;

function HolmerAndRopaPotato:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HolmerAndRopaPotato:keyEvent(unicode, sym, modifier, isDown)
end;

function HolmerAndRopaPotato:update(dt)
end;

function HolmerAndRopaPotato:updateTick(dt)
	if self.checkPreparerFruitTypes then
		local combine = self:getCombine();
		
		if self.fruitPreparer.isSpeedLimitActive and combine ~= nil then		
			if combine.fillUnits ~= nil then	
				for _, fillUnit in pairs(combine.fillUnits) do
					--renderText(0.5, 0.5, 0.02, "fillUnit.currentFillType = " .. FillUtil.fillTypeIntToName[fillUnit.currentFillType]);
					--renderText(0.5, 0.48, 0.02, "self.fruitPreparer.fruitType = " .. FruitUtil.fruitIndexToDesc[self.fruitPreparer.fruitType].name);
					
					if fillUnit.currentFillType == FillUtil.FILLTYPE_UNKNOWN then
						if self.fruitPreparer.fruitType == FruitUtil.FRUITTYPE_POTATO then
							local desc = FruitUtil.fruitIndexToDesc[FruitUtil.FRUITTYPE_SUGARBEET];
							
							if desc ~= nil then
								self.fruitPreparer.fruitType = desc.index;
								self.aiRequiredFruitType = desc.index;
								self.aiRequiredMinGrowthState = desc.minPreparingGrowthState;
								self.aiRequiredMaxGrowthState = desc.maxPreparingGrowthState;
								combine.fruitPreparerFruitType = desc.index;
							end;
						elseif self.fruitPreparer.fruitType == FruitUtil.FRUITTYPE_SUGARBEET then
							local desc = FruitUtil.fruitIndexToDesc[FruitUtil.FRUITTYPE_POTATO];
				
							if desc ~= nil then
								self.fruitPreparer.fruitType = desc.index;
								self.aiRequiredFruitType = desc.index;
								self.aiRequiredMinGrowthState = desc.minPreparingGrowthState;
								self.aiRequiredMaxGrowthState = desc.maxPreparingGrowthState;
								combine.fruitPreparerFruitType = desc.index;
							end;
						end;
					elseif self.currentInputFruitType ~= self.fruitPreparer.fruitType then	
						local desc = FruitUtil.fruitIndexToDesc[self.currentInputFruitType];
						
						if desc == nil then
							for _, fillUnit in pairs(combine.fillUnits) do	
								desc = FruitUtil.fruitIndexToDesc[FruitUtil.fillTypeToFruitType[fillUnit.currentFillType]];
							end;
						end;
						
						if desc ~= nil then
							self.fruitPreparer.fruitType = desc.index;
							self.aiRequiredFruitType = desc.index;
							self.aiRequiredMinGrowthState = desc.minPreparingGrowthState;
							self.aiRequiredMaxGrowthState = desc.maxPreparingGrowthState;
							combine.fruitPreparerFruitType = desc.index;
						end;
					end;
				end;
			end;
		end;
	end;
end;

function HolmerAndRopaPotato:draw()
end;