local metadata = {
"## Interface:FS17 1.2.1.0 1.2.1RC2",
"## Title: HolmerAndRopaPotato_Register",
"## Notes: HolmerAndRopaPotato_Register",
"## Author: Marhu",
"## Convert: Ifko[nator]",
"## Version: 2.0.0",
"## Date: 15.03.2016",
"## Date convert: 03.11.2016",
"## Web: http://marhu.net"
}

local DebugEbene = 0;
local function getmdata(v) v="## "..v..": "; for i=1,table.getn(metadata) do local _,n=string.find(metadata[i],v);if n then return (string.sub (metadata[i], n+1)); end;end;end;
local function Debug(e,s,...) if e <= DebugEbene then print((getmdata("Title")).." v"..(getmdata("Version"))..": "..string.format(s,...)); end; end;
local function L(name) local t = getmdata("Title"); return g_i18n:hasText(t.."_"..name) and g_i18n:getText(t.."_"..name) or name; end
--print("Script "..(getmdata("Title")).." v"..(getmdata("Version")).." by "..(getmdata("Author")).." loaded! Support on "..(getmdata("Web")));
	
SpecializationUtil.registerSpecialization("holmerAndRopaPotato", "HolmerAndRopaPotato", g_currentModDirectory .. "HolmerAndRopaPotato.lua");

HolmerAndRopaPotato_Register = {};

HolmerAndRopaPotato_Register.vehicleTypes = {};
	
local modDesc = loadXMLFile("modDesc", g_currentModDirectory .. "modDesc.xml");
local vehicleTypeCount = 0;

while true do
	local vehicleTypeKey = "modDesc.supportetVehicleTypes.supportetVehicleType(" .. tostring(vehicleTypeCount) .. ")";
	
	if not hasXMLProperty(modDesc, vehicleTypeKey) then
		break;
	end;
	
	local vehicleType = getXMLString(modDesc, vehicleTypeKey .."#name");
	
	if vehicleType ~= nil then
		table.insert(HolmerAndRopaPotato_Register.vehicleTypes, vehicleType);
	end;
	
	vehicleTypeCount = vehicleTypeCount + 1;
end;

function HolmerAndRopaPotato_Register:loadMap(name)
	
	local function findVehicleTypes(vehicleType)
		for vehicleTypeNumber = 1, #HolmerAndRopaPotato_Register.vehicleTypes do
			if string.find(vehicleType, HolmerAndRopaPotato_Register.vehicleTypes[vehicleTypeNumber]) then
				return true;
			end;
		end;
		
		return false;
	end;
	
	local numVehicleTypes = 0;
	
	for vehicleType, vehilce in pairs(VehicleTypeUtil.vehicleTypes) do	
		if findVehicleTypes(vehicleType) then
			if not SpecializationUtil.hasSpecialization(HolmerAndRopaPotato, vehilce.specializations) then
				table.insert(vehilce.specializations, SpecializationUtil.getSpecialization("holmerAndRopaPotato"));
				
				numVehicleTypes = numVehicleTypes + 1;
			end;
		end;
	end;
	
	print("Script " .. (getmdata("Title")) .. " v" .. (getmdata("Version")) .. " by " .. (getmdata("Author")) .. " converted to FS 17 by " .. (getmdata("Convert")) ..  " registered in " .. numVehicleTypes .. " vehicleTypes! Support on " .. (getmdata("Web")));
end;

function HolmerAndRopaPotato_Register:ValueChanged()end;
function HolmerAndRopaPotato_Register:deleteMap()end;
function HolmerAndRopaPotato_Register:mouseEvent(posX, posY, isDown, isUp, button)end;
function HolmerAndRopaPotato_Register:keyEvent(unicode, sym, modifier, isDown)end;
function HolmerAndRopaPotato_Register:update(dt)end;
function HolmerAndRopaPotato_Register:draw()end;

addModEventListener(HolmerAndRopaPotato_Register);