--[[
Script to add new store category(s) in the mod view

Author:		Ifko[nator]
Date:		27.11.2017
Version:	1.8

History:	V 1.0 @ 16.11.2015 - intial release
			V 1.1 @ 09.12.2015 - bug fix for wrong placement of the new category in the mod view
			V 1.5 @ 25.10.2016 - add support for the new categories from FS 17
			V 1.8 @ 27.11.2017 - some improvements in the script, now it is smaller
]]

local modDesc = loadXMLFile("modDesc", g_currentModDirectory .. "modDesc.xml");
local debugPriority = Utils.getNoNil(getXMLString(modDesc,  "modDesc.storeItems.newCategories#debugPriority"), 0);

local function printError(errorMessage, isWarning, isInfo)
	local prefix = "Error ";
	
	if isWarning then
		prefix = "Warning ";
	elseif isInfo then
		prefix = "Info ";
	end;
	
	print(prefix .. "from the addStoreCategory.lua: " .. tostring(errorMessage));
end;

local function printDebug(debugMessage, priority, addStringDebug)
	if debugPriority >= priority then
		local prefix = "";
		
		if addStringDebug then
			prefix = "Debug: from the addStoreCategory.lua: "
		end;
		
		print(prefix .. tostring(debugMessage));
	end;
end;

local count = 0;

while true do
	local baseString = string.format("modDesc.storeItems.newCategories.newCategory(%d)", count);
	
	if not hasXMLProperty(modDesc, baseString) then
		break;
	end;
	
	local name = getXMLString(modDesc, baseString .. "#name");
	local previousCategory = getXMLString(modDesc, baseString .. "#previousCategory");
	local imageFilename = getXMLString(modDesc, baseString .. "#imageFilename");
	local image = Utils.getFilename(imageFilename, g_currentModDirectory);
	
	local modFilename, isMod, ModDirectoryIndex = Utils.removeModDirectory(g_currentModDirectory);
	
	if (name and image) ~= (nil and "") then
		if isMod then 
			local storeUtil = StoreItemsUtil.storeCategories;
			local storeItem = storeUtil.placeables.orderId;
			
			if previousCategory ~= (nil and "") then
				if storeUtil[previousCategory].orderId ~= nil then
					storeItem = storeUtil[previousCategory].orderId;
				else
					printError("The previous category '" .. previousCategory .. "' is not an standard category! Adding the category '" .. name .. "' from the Mod '" .. g_currentModName .. "' as last!", false, true);
				end;
			else
				printError("Missing the previous category name! Adding the category '" .. name .. "' from the Mod '" .. g_currentModName .. "' as last!", false, true);
			end;
		
			if storeUtil[name] == nil then
				local title = name;
				
				if g_i18n:hasText(name) then
					title = g_i18n:getText(name);
				else
					printError("Missing the l10n entry for the category '" .. name .. "'! This is not a Problem, but *not* 100% perfect!", true, false);
				end;
				
				printDebug("Add category '" .. name .. " '(title = '" .. title .. ")' from the Mod '" .. g_currentModName .. "' successfully.", 1, true);
				
				storeUtil[name] = {
					orderId = storeItem + 0.1,
					name = name,
					title = title,
					image = image
				};
			end;
		end;
	else
		if name == (nil or "") then
			printError("Missing the category name! Stop adding the category(" .. count .. ") from the Mod '" .. g_currentModName .. "' now!", false, false);
		else
			printError("Missing the image  for the category '" .. name .. "'! Stop adding the category(" .. count .. ") from the Mod '" .. g_currentModName .. "' now!", false, false);
		end;
	end;

	count = count + 1;
end;