--[[
Specialization to show a manure dust on a fillable vehicle

Author:		Ifko[nator]
Date:       30.08.2017
Version:    2.0

History: 	v1.0 @ 11.11.2015 - initial implemation in FS 15
			v2.0 @ 30.08.2017 - convert to FS 17
]]

ManureDust = {};

function ManureDust.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function ManureDust:load(savegame)
    self.manureDusts = {};
    
    local dustNumber = 0;
    
    while true do
        local dustKey = "vehicle.manureDusts.manureDust(" .. tostring(dustNumber) .. ")";
        
        if not hasXMLProperty(self.xmlFile, dustKey) then
            break;
        end;
        
		local node = getXMLString(self.xmlFile, dustKey .. "#node");
        node = Utils.indexToObject(self.components, node);
        
        if node ~= nil then
            local manureDust = {};
			
            manureDust.particleSystem = {};
            manureDust.node = node;
            
			ParticleUtil.loadParticleSystem(self.xmlFile, manureDust.particleSystem, dustKey, self.components, false, nil, self.baseDirectory);
            
			table.insert(self.manureDusts, manureDust);
        end;
        
        dustNumber = dustNumber + 1;
    end;
end;    
    
function ManureDust:delete()
    for _, manureDust in pairs(self.manureDusts) do
        ParticleUtil.deleteParticleSystem(manureDust.particleSystem);
    end;
end;

function ManureDust:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ManureDust:keyEvent(unicode, sym, modifier, isDown)
end;

function ManureDust:update(dt)    
    if self.isCoverOpen == nil then
        --## cover specialization is not available
        self.isCoverOpen = true;
    end;
    
    for _, manureDust in pairs(self.manureDusts) do
		for _, fillUnit in pairs(self.fillUnits) do	
			ParticleUtil.setEmittingState(manureDust.particleSystem, fillUnit.fillLevel > 0 and fillUnit.currentFillType == FillUtil.FILLTYPE_MANURE);
		end;
        
        --## blend out and in the particle system faster
        setVisibility(manureDust.node, self.isCoverOpen);    
    end;
end;

function ManureDust:draw()
end;