--[[
Specialization to animate springs on a trailer attacher

Author:  Ifko[nator]
Date:    21.08.2017
Version: 1.0
]]


Springs = {};

function Springs.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Springs:load(savegame)
    local xmlFile = self.xmlFile;
	
	self.springs = {};
	
	local springNumber = 0;
	
	while true do
		local springKey = "vehicle.springs.spring(" .. tonumber(springNumber) .. ")";
		
		if not hasXMLProperty(self.xmlFile, springKey) then
			break;
		end;
	
		local node = Utils.indexToObject(self.components, getXMLString(self.xmlFile, springKey .. "#index"));
		local part = Utils.indexToObject(self.components, getXMLString(self.xmlFile, springKey .. "#part"));
		local fixPoint = Utils.indexToObject(self.components, getXMLString(self.xmlFile, springKey .. "#fixPoint"));
		local target = Utils.indexToObject(self.components, getXMLString(self.xmlFile, springKey .. "#target"));
		
		if (node and part and fixPoint and target) ~= nil then
			local spring = {};
			
			spring.node = node;
			
			local x,y,z = getRotation(spring.node);
			
			spring.part = {x, y, z};
			spring.part = part;
			
			x,y,z = getTranslation(spring.part);
			
			spring.fixPoint = {x, y, z};
			spring.fixPoint = fixPoint;
			
			local ax, ay, az = getWorldTranslation(spring.part);
			local bx, by, bz = getWorldTranslation(spring.fixPoint);        
			spring.distance = Utils.vector3Length(ax - bx, ay - by, az - bz);    
			
			spring.target = {x, y, z};
			spring.target = target;
			
			table.insert(self.springs, spring);
		end;
	
		springNumber = springNumber + 1;
	end;
	
	self.hasSetLimitToZero = false;
end;

function Springs:update(dt)    
	if self.isServer then	
		if self.attacherVehicle == nil then
			if not self.hasSetLimitToZero then	
				setJointRotationLimit(self.componentJoints[2].jointIndex, 0, true, 0, 0);
			
				self.hasSetLimitToZero = true;
			end;
		else
			if self.hasSetLimitToZero then	
				setJointRotationLimit(self.componentJoints[2].jointIndex, 0, true, math.rad(-65), math.rad(65));
				
				self.hasSetLimitToZero = false;
			end;
		end;
	end;
	
	for _, spring in pairs(self.springs) do
		if spring.target ~= nil then
			local ax, ay, az = getWorldTranslation(spring.node);
			local bx, by, bz = getWorldTranslation(spring.target);
			local x, y, z = worldDirectionToLocal(getParent(spring.node), bx - ax, by - ay, bz - az);
			local upX, upY, upZ = 0, 1, 0;
			
			if math.abs(y) > 0.99 * Utils.vector3Length(x, y, z) then
				upY = 0;
				if y > 0 then
					upZ = 1;
				else
					upZ = -1;
				end;
			end;
			
			local distance = Utils.vector3Length(ax - bx, ay - by, az - bz);
			
			setTranslation(spring.part, 0, 0, distance - spring.distance);
			setDirection(spring.node, x, y, z, upX, upY, upZ);
		end;
	end;
end;

--## unused but needed functions

function Springs:delete()end;
function Springs:mouseEvent(posX, posY, isDown, isUp, button)end;
function Springs:keyEvent(unicode, sym, modifier, isDown)end;
function Springs:draw()end;