--
-- InteractiveButtons
-- Specialization for an interactive control button
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.1
-- @date  		29/08/11
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--				v2.1 - improvements
--
-- free for noncommerical-usage
--

InteractiveButtons = {};

function InteractiveButtons.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(InteractiveControl, specializations);
end;

function InteractiveButtons:load(savegame)

	local i=0;
	while true do
		local buttonName = string.format("vehicle.interactiveComponents.buttons.button(%d)", i);	
		if not hasXMLProperty(self.xmlFile, buttonName) then
			break;
		end;
		local name = Utils.getNoNil(g_i18n:getText(getXMLString(self.xmlFile, buttonName .. "#name")), "ERROR");
		local mark = Utils.indexToObject(self.components, getXMLString(self.xmlFile, buttonName .. "#mark"));
		local highlight = getChildAt(mark, 0);
		local size = Utils.getNoNil(getXMLFloat(self.xmlFile, buttonName .. "#size"), 0.1);
		local event = getXMLString(self.xmlFile, buttonName .. "#event");
		local onMessage = g_i18n:getText(Utils.getNoNil(getXMLString(self.xmlFile, buttonName .. "#onMessage"), "ic_button_on"));
		local offMessage =  g_i18n:getText(Utils.getNoNil(getXMLString(self.xmlFile, buttonName .. "#offMessage") , "ic_button_off"));
	
		local button = Button:new(nil, highlight, name, mark, size, event, self, onMessage, offMessage, self.infoBar);
		
		button.synch = Utils.getNoNil(getXMLBool(self.xmlFile, buttonName .. "#synch"), true);

		table.insert(self.interactiveObjects, button);
		i = i + 1;
	end;
end;

function InteractiveButtons:delete()
end;

function InteractiveButtons:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InteractiveButtons:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveButtons:update(dt)	
end;

function InteractiveButtons:draw()
end;



--
-- Button Class
-- Specifies an interactive Button
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  29/08/11
--

Button = {};

function Button:new(node, highlight, name, mark, size, event, vehicle, onMessage, offMessage, infobar)

	local Button_mt = Class(Button, InteractiveComponentInterface);	
    local instance = InteractiveComponentInterface:new(node, highlight, name, mark, size, onMessage, offMessage, infobar, Button_mt);

	instance.vehicle = vehicle;
	instance.event = event;
	
	return instance;	
end;

function Button:delete()
	InteractiveComponentInterface.delete(self);
end;

function Button:mouseEvent(posX, posY, isDown, isUp, button)
	InteractiveComponentInterface.mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Button:keyEvent(unicode, sym, modifier, isDown)
	InteractiveComponentInterface.keyEvent(self, unicode, sym, modifier, isDown);
end;

function Button:update(dt)
	if self.vehicle ~= nil then
	    if self.event == "toggleBeaconLight" then
	        self.isOpen = self.vehicle.beaconLightsActive == true;
	    elseif self.event == "toggleFrontLight" then
	        self.isOpen = (self.vehicle.lightsTypesMask == 1) or (self.vehicle.lightsTypesMask == 3) or (self.vehicle.lightsTypesMask == 5) or (self.vehicle.lightsTypesMask == 7) or (self.vehicle.lightsTypesMask == 9) or (self.vehicle.lightsTypesMask == 12) or (self.vehicle.lightsTypesMask == 13) or (self.vehicle.lightsTypesMask == 15);
		elseif self.event == "toggleBackWorkLight" then
	        self.isOpen = (self.vehicle.lightsTypesMask == 2) or (self.vehicle.lightsTypesMask == 3) or (self.vehicle.lightsTypesMask == 6) or (self.vehicle.lightsTypesMask == 7) or (self.vehicle.lightsTypesMask == 10) or (self.vehicle.lightsTypesMask == 12) or (self.vehicle.lightsTypesMask == 14) or (self.vehicle.lightsTypesMask == 15);
		elseif self.event == "toggleFrontWorkLight" then
	        self.isOpen = (self.vehicle.lightsTypesMask == 4) or (self.vehicle.lightsTypesMask == 5) or (self.vehicle.lightsTypesMask == 6) or (self.vehicle.lightsTypesMask == 7) or (self.vehicle.lightsTypesMask == 11) or (self.vehicle.lightsTypesMask == 13) or (self.vehicle.lightsTypesMask == 14) or (self.vehicle.lightsTypesMask == 15);
	    
		elseif self.event == "toggleFrontLLight" then
	        self.isOpen = (self.vehicle.lightsTypesMask == 8) or (self.vehicle.lightsTypesMask == 9) or (self.vehicle.lightsTypesMask == 10) or (self.vehicle.lightsTypesMask == 11) or (self.vehicle.lightsTypesMask == 12) or (self.vehicle.lightsTypesMask == 13) or (self.vehicle.lightsTypesMask == 14) or (self.vehicle.lightsTypesMask == 15);

	    elseif self.event == "toggleIndoorLight" then
			self.isOpen = self.vehicle.cl.turnOn;
		
	    --[[ elseif self.event == "toggleWarningLights" then
            self.isOpen = false;
            if self.vehicle.turnSignalState ~= 0 then
                self.isOpen = self.vehicle.turnSignalState == 3;
            end; ]]
        end;
	end;
	InteractiveComponentInterface.update(self, dt);
end;

function Button:draw()
	InteractiveComponentInterface.draw(self);
end;

function Button:doAction(noEventSend, forceAction)
	if self.vehicle ~= nil then
		if self.event == "toggleBeaconLight" then
            if forceAction == nil then
                if self.vehicle.beaconLightsActive then
				    self.vehicle:setBeaconLightsVisibility(false, true);
			    else
                    self.vehicle:setBeaconLightsVisibility(true, true);
			    end;
			end;
		elseif self.event == "toggleFrontLight" then
            if forceAction == nil then
			    if self.vehicle.lightsTypesMask == 0 then		
				    self.vehicle:setLightsTypesMask(1, true);	
			    elseif self.vehicle.lightsTypesMask == 1  then	
				    self.vehicle:setLightsTypesMask(0, true);	
					
			    elseif self.vehicle.lightsTypesMask == 2 then	
				    self.vehicle:setLightsTypesMask(3, true);	
			    elseif self.vehicle.lightsTypesMask == 3 then
				    self.vehicle:setLightsTypesMask(2, true);
				
				elseif self.vehicle.lightsTypesMask == 4 then	
				    self.vehicle:setLightsTypesMask(5, true);	
			    elseif self.vehicle.lightsTypesMask == 5 then
				    self.vehicle:setLightsTypesMask(4, true);
					
				elseif self.vehicle.lightsTypesMask == 6 then	
				    self.vehicle:setLightsTypesMask(7, true);	
			    elseif self.vehicle.lightsTypesMask == 7 then
				    self.vehicle:setLightsTypesMask(6, true);
				
				elseif self.vehicle.lightsTypesMask == 8 then		
				    self.vehicle:setLightsTypesMask(9, true);	
			    elseif self.vehicle.lightsTypesMask == 9  then	
				    self.vehicle:setLightsTypesMask(8, true);	
					
			    elseif self.vehicle.lightsTypesMask == 10 then	
				    self.vehicle:setLightsTypesMask(11, true);	
			    elseif self.vehicle.lightsTypesMask == 11 then
				    self.vehicle:setLightsTypesMask(10, true);
				
				elseif self.vehicle.lightsTypesMask == 12 then	
				    self.vehicle:setLightsTypesMask(13, true);	
			    elseif self.vehicle.lightsTypesMask == 13 then
				    self.vehicle:setLightsTypesMask(12, true);
					
				elseif self.vehicle.lightsTypesMask == 14 then	
				    self.vehicle:setLightsTypesMask(15, true);	
			    elseif self.vehicle.lightsTypesMask == 15 then
				    self.vehicle:setLightsTypesMask(14, true);
			    end;
			end;
			
		elseif self.event == "toggleBackWorkLight" then
            if forceAction == nil then
			    if self.vehicle.lightsTypesMask == 0 then		
				    self.vehicle:setLightsTypesMask(2, true);	
			    elseif self.vehicle.lightsTypesMask == 2  then	
				    self.vehicle:setLightsTypesMask(0, true);	
					
			    elseif self.vehicle.lightsTypesMask == 1 then	
				    self.vehicle:setLightsTypesMask(3, true);	
			    elseif self.vehicle.lightsTypesMask == 3 then
				    self.vehicle:setLightsTypesMask(1, true);
					
				elseif self.vehicle.lightsTypesMask == 4 then	
				    self.vehicle:setLightsTypesMask(6, true);	
			    elseif self.vehicle.lightsTypesMask == 6 then
				    self.vehicle:setLightsTypesMask(4, true);
			    
				elseif self.vehicle.lightsTypesMask == 5 then	
				    self.vehicle:setLightsTypesMask(7, true);	
			    elseif self.vehicle.lightsTypesMask == 7 then
				    self.vehicle:setLightsTypesMask(5, true);
					
				elseif self.vehicle.lightsTypesMask == 8 then		
				    self.vehicle:setLightsTypesMask(10, true);	
			    elseif self.vehicle.lightsTypesMask == 10  then	
				    self.vehicle:setLightsTypesMask(8, true);	
					
			    elseif self.vehicle.lightsTypesMask == 9 then	
				    self.vehicle:setLightsTypesMask(11, true);	
			    elseif self.vehicle.lightsTypesMask == 11 then
				    self.vehicle:setLightsTypesMask(9, true);
					
				elseif self.vehicle.lightsTypesMask == 12 then	
				    self.vehicle:setLightsTypesMask(14, true);	
			    elseif self.vehicle.lightsTypesMask == 14 then
				    self.vehicle:setLightsTypesMask(12, true);
			    
				elseif self.vehicle.lightsTypesMask == 13 then	
				    self.vehicle:setLightsTypesMask(15, true);	
			    elseif self.vehicle.lightsTypesMask == 15 then
				    self.vehicle:setLightsTypesMask(13, true);
			    end;
			end;
			
		elseif self.event == "toggleFrontWorkLight" then
            if forceAction == nil then
			    if self.vehicle.lightsTypesMask == 0 then		
				    self.vehicle:setLightsTypesMask(4, true);	
			    elseif self.vehicle.lightsTypesMask == 4  then	
				    self.vehicle:setLightsTypesMask(0, true);	
					
			    elseif self.vehicle.lightsTypesMask == 1 then	
				    self.vehicle:setLightsTypesMask(5, true);	
			    elseif self.vehicle.lightsTypesMask == 5 then
				    self.vehicle:setLightsTypesMask(1, true);
					
				elseif self.vehicle.lightsTypesMask == 2 then	
				    self.vehicle:setLightsTypesMask(6, true);	
			    elseif self.vehicle.lightsTypesMask == 6 then
				    self.vehicle:setLightsTypesMask(2, true);
			    
				elseif self.vehicle.lightsTypesMask == 3 then	
				    self.vehicle:setLightsTypesMask(7, true);	
			    elseif self.vehicle.lightsTypesMask == 7 then
				    self.vehicle:setLightsTypesMask(3, true);
					
				elseif self.vehicle.lightsTypesMask == 8 then		
				    self.vehicle:setLightsTypesMask(12, true);	
			    elseif self.vehicle.lightsTypesMask == 12  then	
				    self.vehicle:setLightsTypesMask(8, true);	
					
			    elseif self.vehicle.lightsTypesMask == 9 then	
				    self.vehicle:setLightsTypesMask(13, true);	
			    elseif self.vehicle.lightsTypesMask == 13 then
				    self.vehicle:setLightsTypesMask(9, true);
					
				elseif self.vehicle.lightsTypesMask == 10 then	
				    self.vehicle:setLightsTypesMask(14, true);	
			    elseif self.vehicle.lightsTypesMask == 14 then
				    self.vehicle:setLightsTypesMask(10, true);
			    
				elseif self.vehicle.lightsTypesMask == 11 then	
				    self.vehicle:setLightsTypesMask(15, true);	
			    elseif self.vehicle.lightsTypesMask == 15 then
				    self.vehicle:setLightsTypesMask(11, true);
			    end;
			end;
		
		elseif self.event == "toggleFrontLLight" then
            if forceAction == nil then
			    if self.vehicle.lightsTypesMask == 0 then		
				    self.vehicle:setLightsTypesMask(8, true);	
			    elseif self.vehicle.lightsTypesMask == 8  then	
				    self.vehicle:setLightsTypesMask(0, true);	
					
			    elseif self.vehicle.lightsTypesMask == 1 then	
				    self.vehicle:setLightsTypesMask(9, true);	
			    elseif self.vehicle.lightsTypesMask == 9 then
				    self.vehicle:setLightsTypesMask(1, true);
				
				elseif self.vehicle.lightsTypesMask == 2 then	
				    self.vehicle:setLightsTypesMask(10, true);	
			    elseif self.vehicle.lightsTypesMask == 10 then
				    self.vehicle:setLightsTypesMask(2, true);
					
				elseif self.vehicle.lightsTypesMask == 3 then	
				    self.vehicle:setLightsTypesMask(11, true);	
			    elseif self.vehicle.lightsTypesMask == 11 then
				    self.vehicle:setLightsTypesMask(3, true);
					
				elseif self.vehicle.lightsTypesMask == 4 then		
				    self.vehicle:setLightsTypesMask(12, true);	
			    elseif self.vehicle.lightsTypesMask == 12  then	
				    self.vehicle:setLightsTypesMask(4, true);	
					
			    elseif self.vehicle.lightsTypesMask == 5 then	
				    self.vehicle:setLightsTypesMask(13, true);	
			    elseif self.vehicle.lightsTypesMask == 13 then
				    self.vehicle:setLightsTypesMask(5, true);
				
				elseif self.vehicle.lightsTypesMask == 6 then	
				    self.vehicle:setLightsTypesMask(14, true);	
			    elseif self.vehicle.lightsTypesMask == 14 then
				    self.vehicle:setLightsTypesMask(6, true);
					
				elseif self.vehicle.lightsTypesMask == 7 then	
				    self.vehicle:setLightsTypesMask(15, true);	
			    elseif self.vehicle.lightsTypesMask == 15 then
				    self.vehicle:setLightsTypesMask(7, true);
			    end;
			end;
		
		elseif self.event == "toggleIndoorLight" then
			if forceAction == nil then
				local state = not self.vehicle.cl.turnOn;
				self.vehicle:setCablight(state, true);
			end;
		--[[ elseif self.event == "toggleWarningLights" then
			if forceAction == nil then
                if self.vehicle.turnSignalState == 3 then
				    self.vehicle:setTurnSignalState(0);
			    else
				    self.vehicle:setTurnSignalState(3);
			    end;
			end; ]]
        
		elseif self.event == "lowerBack" then
			if self.vehicle.lowerBack then
				self.vehicle:setJointMoveDown(1, false);
				self.vehicle.lowerBack = false;
			else
				self.vehicle:setJointMoveDown(1, true);
				self.vehicle.lowerBack = true
			end;
		
		elseif self.event == "lowerBack2" then
			if self.vehicle.lowerBack then
				self.vehicle:setJointMoveDown(1, false);
				self.vehicle.lowerBack = false;
			else
				self.vehicle:setJointMoveDown(1, true);
				self.vehicle.lowerBack = true
			end;
		
		elseif self.event == "lowerFront" then
			if self.vehicle.lowerFront then
				self.vehicle:setJointMoveDown(2, false);
				self.vehicle.lowerFront = false;
			else
				self.vehicle:setJointMoveDown(2, true);
				self.vehicle.lowerFront = true;
			end;
		
		elseif self.event == "togglePipe" then
			if forceAction == nil then
				local nextState = self.vehicle.targetPipeState+1;
				if nextState > self.vehicle.numPipeStates then
					nextState = 1;
				end;
				self.vehicle:setPipeState(nextState, true);
			end;
		
		elseif self.event == "toggleChopper" then
			local newValue = not self.vehicle.isStrawEnabled;
			if forceAction ~= nil then
					newValue = not forceAction;
			end;
			if self.vehicle.lastValidInputFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
				local fruitDesc = FruitUtil.fruitIndexToDesc[self.vehicle.lastValidInputFruitType];
				if fruitDesc.hasWindrow then
					--self.vehicle.isStrawEnabled = not self.vehicle.isStrawEnabled;
					self.vehicle:setIsStrawEnabled(newValue);
				end;
			else
				--self.vehicle.isStrawEnabled = not self.vehicle.isStrawEnabled;
				self.vehicle:setIsStrawEnabled(newValue);
			end;
		
		--[[elseif self.event == "toggleFolding" then
			if self.vehicle ~= nil then
				for k, implement in pairs(self.vehicle.attachedImplements) do
					if implement.object ~= nil then
						if implement.object:getIsFoldAllowed() then
							if implement.object:getToggledFoldDirection() == implement.object.turnOnFoldDirection then
								implement.object:setFoldState(implement.object:getToggledFoldDirection(), true);
							else
								implement.object:setFoldState(implement.object:getToggledFoldDirection(), false);
							end;
						end;
					end;
				end;
			end;]]
		
		elseif string.sub( self.event, 1, 10 ) == "l2gsToggle" and type( self.vehicle[self.event] ) == "function" then
			local fct = self.vehicle[self.event]
			fct( self.vehicle )
		end
	end;
end;

function Button:onEnter()
	InteractiveComponentInterface.onEnter(self);
end;

function Button:onExit()
	InteractiveComponentInterface.onExit(self);
end;

function Button:setActive()
	InteractiveComponentInterface.setActive(self, isActive);
end;

function Button:setVisible(isVisible)
	InteractiveComponentInterface.setVisible(self, isVisible);
end;