--[[
FenderVisibilityFix

Script to blend out fenders, when narrow wheels are active

@Author:	Ifko[nator]
@Date:		12.11.2017
@Version:	1.0 - initial release in FS 17
]]


FenderVisibilityFix = {};

function FenderVisibilityFix.prerequisitesPresent(specializations)
    return true;
end;

function FenderVisibilityFix:load(savegame)
    self.foundCareWheels = false;
	self.isAllWheels = false;
	
	local storeItem = StoreItemsUtil.storeItemsByXMLFilename[self.configFileName:lower()];
    
	if storeItem.configurations ~= nil then
        if storeItem.configurations["wheel"] ~= nil then
            local wheelConfigurations = storeItem.configurations["wheel"];
            local config = wheelConfigurations[self.configurations["wheel"]];
            
			for _, name in pairs({"configuration_valueTwinWheelsNarrow", "configuration_valueWheelNarrow", "configuration_Hinterrad"}) do
                if config.name == g_i18n:getText(name) then
                    self.foundCareWheels = true;
                    
					break;
                end;
            end;
        end;
		
		if storeItem.configurations["Antrieb"] ~= nil then
            local AntriebConfigurations = storeItem.configurations["Antrieb"];
            local config = AntriebConfigurations[self.configurations["Antrieb"]];
            
			self.isAllWheels = config.name == g_i18n:getText("configuration_Allrad");
        end;
    end;
	
	self.fenders = {};
	
	local fenderNumber = 0;

	while true do
		local getKey = "vehicle.disableFenders.disableFender(" .. tostring(fenderNumber) .. ")";
		
		if not hasXMLProperty(self.xmlFile, getKey) then
			break;
		end;
		
		local fender = {};
		
		fender.node = Utils.indexToObject(self.components, getXMLString(self.xmlFile, getKey .. "#node"));
		
		if fender.node ~= nil then
			fender.activeWithWheelNarrow = Utils.getNoNil(getXMLBool(self.xmlFile, getKey .. "#activeWithWheelNarrow"), false);
			
			table.insert(self.fenders, fender);
		end;
		
		fenderNumber = fenderNumber + 1;
	end;
end

function FenderVisibilityFix:update(dt)
	for _, fender in pairs(self.fenders) do
		if self.isAllWheels then	
			if self.foundCareWheels then
				setVisibility(fender.node, fender.activeWithWheelNarrow);
			else
				setVisibility(fender.node, not fender.activeWithWheelNarrow);
			end;
		else
			setVisibility(fender.node, false);
		end;
	end;
end;

--## Unused but needed functions 

function FenderVisibilityFix:delete()end;
function FenderVisibilityFix:mouseEvent(posX, posY, isDown, isUp, button)end;
function FenderVisibilityFix:keyEvent(unicode, sym, modifier, isDown)end;
function FenderVisibilityFix:updateTick(dt)end;
function FenderVisibilityFix:draw()end;